convolution_network_on_FPGA
===========================
The repository is part of my [graduation project](https://github.com/hunterlew/mstar_deeplearning_project), but focusing on convolution network inference acceleration on FPGA. 

Description
-----------
The project was built with ISE 14.7 software and vertix-7 FPGA. It performs a 7-layer network forward computation with certain accelerating strategies. First, train a SAR target classification network on MSTAR dataset with [MatConvNet](http://www.vlfeat.org/matconvnet/) and use early-stop. Then, transform the weights and inputs to FPGA using COE files generated by Matlab. Next, design native verilog-written models to fulfil the forward computation. The system uses 16-bit fix-point data to maintain precision. The result proves that it costs less than 1ms per image, outperforming other computing platforms.

Acceleration
------------
For trade-off between FPGA resource and speed, the first conv. layer uses shift-register structures for acceleration, considering that the size of inputs and weights in the first conv. layer are larger. The other conv. layers only uses pipe-line structures. Note that there are 18 files named with m_conv_1, indicating 18 shift-registers in the first conv. layer.

For the limit of bandwidth, the second conv. layer uses channel-grouping parallelization scheme. I used v7-415t and v7-485t FPGA for comparisons, which use different group numbers (4 vs 1) according to their different amounts of resource. You may notice the scheme in the file CNN_top.v, with the signal 'ram_ready' which controls the channel grouping and merging. 
