
//--------------------------------------------------------------------------------------------------------
// 模块： cartesian2polar
// Type    : synthesizable
// Standard: Verilog 2001 (IEEE1364-2001)
// 功能： 把直角坐标系 (x,y) 转换为极坐标系 
//--------------------------------------------------------------------------------------------------------

module cartesian2polar #(
    parameter ATTENUAION = 0
) (
    input  wire               rstn,
    input  wire               clk,
    input  wire               i_en,
    input  wire signed [15:0] i_x, i_y,
    output reg                o_en,
    output reg         [11:0] o_rho,
    output reg         [11:0] o_theta
);

reg [ 4:0] cnt;
reg        signx, signy, signxy;
reg [15:0] absx, absy;  // 0~32768
reg [27:0] smtb, smta;
reg [27:0] accb;
reg [15:0] acca;

reg [8:0] rom_a, rom_theta;
reg [8:0] a;
reg [11:0] theta;
reg [15:0] amp;

wire [23:0] mul = {15'd0,a} * {8'd0,absx};

wire [15:0] amp_w = {2'b0,mul[23:10]} + absx;
wire [15:0] ampatt_w = amp_w >> ATTENUAION;

always @ (posedge clk or negedge rstn)
    if(~rstn) begin
        cnt <= 0;
        {signx, signy, signxy, absx, absy, smtb, smta, accb, acca} <= 0;
        {a, theta, amp} <= 0;
        {o_en, o_rho, o_theta} <= 0;
    end else begin
        o_en <= 1'b0;
        if(cnt==5'd0) begin
            accb <= 0;
            acca <= 0;
            signx <= (i_x < $signed(16'd0));
            signy <= (i_y < $signed(16'd0));
            absx  <= (i_x < $signed(16'd0)) ? -i_x : i_x;
            absy  <= (i_y < $signed(16'd0)) ? -i_y : i_y;
            if(i_en)
                cnt <= 5'd30;
        end else begin
            cnt <= cnt - 5'd1;
            if(cnt>=5'd30) begin
                signxy <= absx < absy;
                if(absx < absy) begin
                    absx <= absy;
                    smtb <= {absy, 12'h0};
                    smta <= {absx, 12'h0};
                end else begin
                    smtb <= {absx, 12'h0};
                    smta <= {absy, 12'h0};
                end
            end else if(cnt>5'd4) begin
                if( accb + smtb <= 28'h8000 ) begin
                    accb <= accb + smtb;
                    acca <= acca + smta[15:0];
                end
                smtb <= smtb >> 1;
                smta <= smta >> 1;
            end else if(cnt==5'd4) begin
                a <= acca[15] ? 9'd424 : rom_a;
                theta <= (acca[15:3]>=13'd4090) ? 12'd512 : {3'b0,rom_theta};
            end else if(cnt==5'd3) begin
                if(signxy) begin
                    theta <= 12'd1024 - theta;
                end
            end else if(cnt==5'd2) begin
                amp <= ampatt_w;
                if(signx)
                    theta <= 12'd2048 - theta;
            end else if(cnt==5'd1) begin
                o_en <= 1'b1;
                o_rho <= amp>16'd4095 ? 12'd4095 : amp[11:0];
                o_theta <= signy ? 12'd0-theta : theta;
            end
        end
    end

always @ (posedge clk)
case(acca[14:3])
12'd0:{rom_a,rom_theta}<={9'd0,9'd0};
12'd1:{rom_a,rom_theta}<={9'd0,9'd0};
12'd2:{rom_a,rom_theta}<={9'd0,9'd0};
12'd3:{rom_a,rom_theta}<={9'd0,9'd0};
12'd4:{rom_a,rom_theta}<={9'd0,9'd1};
12'd5:{rom_a,rom_theta}<={9'd0,9'd1};
12'd6:{rom_a,rom_theta}<={9'd0,9'd1};
12'd7:{rom_a,rom_theta}<={9'd0,9'd1};
12'd8:{rom_a,rom_theta}<={9'd0,9'd1};
12'd9:{rom_a,rom_theta}<={9'd0,9'd1};
12'd10:{rom_a,rom_theta}<={9'd0,9'd2};
12'd11:{rom_a,rom_theta}<={9'd0,9'd2};
12'd12:{rom_a,rom_theta}<={9'd0,9'd2};
12'd13:{rom_a,rom_theta}<={9'd0,9'd2};
12'd14:{rom_a,rom_theta}<={9'd0,9'd2};
12'd15:{rom_a,rom_theta}<={9'd0,9'd2};
12'd16:{rom_a,rom_theta}<={9'd0,9'd3};
12'd17:{rom_a,rom_theta}<={9'd0,9'd3};
12'd18:{rom_a,rom_theta}<={9'd0,9'd3};
12'd19:{rom_a,rom_theta}<={9'd0,9'd3};
12'd20:{rom_a,rom_theta}<={9'd0,9'd3};
12'd21:{rom_a,rom_theta}<={9'd0,9'd3};
12'd22:{rom_a,rom_theta}<={9'd0,9'd4};
12'd23:{rom_a,rom_theta}<={9'd0,9'd4};
12'd24:{rom_a,rom_theta}<={9'd0,9'd4};
12'd25:{rom_a,rom_theta}<={9'd0,9'd4};
12'd26:{rom_a,rom_theta}<={9'd0,9'd4};
12'd27:{rom_a,rom_theta}<={9'd0,9'd4};
12'd28:{rom_a,rom_theta}<={9'd0,9'd4};
12'd29:{rom_a,rom_theta}<={9'd0,9'd5};
12'd30:{rom_a,rom_theta}<={9'd0,9'd5};
12'd31:{rom_a,rom_theta}<={9'd0,9'd5};
12'd32:{rom_a,rom_theta}<={9'd0,9'd5};
12'd33:{rom_a,rom_theta}<={9'd0,9'd5};
12'd34:{rom_a,rom_theta}<={9'd0,9'd5};
12'd35:{rom_a,rom_theta}<={9'd0,9'd6};
12'd36:{rom_a,rom_theta}<={9'd0,9'd6};
12'd37:{rom_a,rom_theta}<={9'd0,9'd6};
12'd38:{rom_a,rom_theta}<={9'd0,9'd6};
12'd39:{rom_a,rom_theta}<={9'd0,9'd6};
12'd40:{rom_a,rom_theta}<={9'd0,9'd6};
12'd41:{rom_a,rom_theta}<={9'd0,9'd7};
12'd42:{rom_a,rom_theta}<={9'd0,9'd7};
12'd43:{rom_a,rom_theta}<={9'd0,9'd7};
12'd44:{rom_a,rom_theta}<={9'd0,9'd7};
12'd45:{rom_a,rom_theta}<={9'd0,9'd7};
12'd46:{rom_a,rom_theta}<={9'd0,9'd7};
12'd47:{rom_a,rom_theta}<={9'd0,9'd7};
12'd48:{rom_a,rom_theta}<={9'd0,9'd8};
12'd49:{rom_a,rom_theta}<={9'd0,9'd8};
12'd50:{rom_a,rom_theta}<={9'd0,9'd8};
12'd51:{rom_a,rom_theta}<={9'd0,9'd8};
12'd52:{rom_a,rom_theta}<={9'd0,9'd8};
12'd53:{rom_a,rom_theta}<={9'd0,9'd8};
12'd54:{rom_a,rom_theta}<={9'd0,9'd9};
12'd55:{rom_a,rom_theta}<={9'd0,9'd9};
12'd56:{rom_a,rom_theta}<={9'd0,9'd9};
12'd57:{rom_a,rom_theta}<={9'd0,9'd9};
12'd58:{rom_a,rom_theta}<={9'd0,9'd9};
12'd59:{rom_a,rom_theta}<={9'd0,9'd9};
12'd60:{rom_a,rom_theta}<={9'd0,9'd10};
12'd61:{rom_a,rom_theta}<={9'd0,9'd10};
12'd62:{rom_a,rom_theta}<={9'd0,9'd10};
12'd63:{rom_a,rom_theta}<={9'd0,9'd10};
12'd64:{rom_a,rom_theta}<={9'd0,9'd10};
12'd65:{rom_a,rom_theta}<={9'd0,9'd10};
12'd66:{rom_a,rom_theta}<={9'd0,9'd11};
12'd67:{rom_a,rom_theta}<={9'd0,9'd11};
12'd68:{rom_a,rom_theta}<={9'd0,9'd11};
12'd69:{rom_a,rom_theta}<={9'd0,9'd11};
12'd70:{rom_a,rom_theta}<={9'd0,9'd11};
12'd71:{rom_a,rom_theta}<={9'd0,9'd11};
12'd72:{rom_a,rom_theta}<={9'd0,9'd11};
12'd73:{rom_a,rom_theta}<={9'd0,9'd12};
12'd74:{rom_a,rom_theta}<={9'd0,9'd12};
12'd75:{rom_a,rom_theta}<={9'd0,9'd12};
12'd76:{rom_a,rom_theta}<={9'd0,9'd12};
12'd77:{rom_a,rom_theta}<={9'd0,9'd12};
12'd78:{rom_a,rom_theta}<={9'd0,9'd12};
12'd79:{rom_a,rom_theta}<={9'd0,9'd13};
12'd80:{rom_a,rom_theta}<={9'd0,9'd13};
12'd81:{rom_a,rom_theta}<={9'd0,9'd13};
12'd82:{rom_a,rom_theta}<={9'd0,9'd13};
12'd83:{rom_a,rom_theta}<={9'd0,9'd13};
12'd84:{rom_a,rom_theta}<={9'd0,9'd13};
12'd85:{rom_a,rom_theta}<={9'd0,9'd14};
12'd86:{rom_a,rom_theta}<={9'd0,9'd14};
12'd87:{rom_a,rom_theta}<={9'd0,9'd14};
12'd88:{rom_a,rom_theta}<={9'd0,9'd14};
12'd89:{rom_a,rom_theta}<={9'd0,9'd14};
12'd90:{rom_a,rom_theta}<={9'd0,9'd14};
12'd91:{rom_a,rom_theta}<={9'd0,9'd14};
12'd92:{rom_a,rom_theta}<={9'd0,9'd15};
12'd93:{rom_a,rom_theta}<={9'd0,9'd15};
12'd94:{rom_a,rom_theta}<={9'd0,9'd15};
12'd95:{rom_a,rom_theta}<={9'd0,9'd15};
12'd96:{rom_a,rom_theta}<={9'd0,9'd15};
12'd97:{rom_a,rom_theta}<={9'd0,9'd15};
12'd98:{rom_a,rom_theta}<={9'd0,9'd16};
12'd99:{rom_a,rom_theta}<={9'd0,9'd16};
12'd100:{rom_a,rom_theta}<={9'd0,9'd16};
12'd101:{rom_a,rom_theta}<={9'd0,9'd16};
12'd102:{rom_a,rom_theta}<={9'd0,9'd16};
12'd103:{rom_a,rom_theta}<={9'd0,9'd16};
12'd104:{rom_a,rom_theta}<={9'd0,9'd17};
12'd105:{rom_a,rom_theta}<={9'd0,9'd17};
12'd106:{rom_a,rom_theta}<={9'd0,9'd17};
12'd107:{rom_a,rom_theta}<={9'd0,9'd17};
12'd108:{rom_a,rom_theta}<={9'd0,9'd17};
12'd109:{rom_a,rom_theta}<={9'd0,9'd17};
12'd110:{rom_a,rom_theta}<={9'd0,9'd18};
12'd111:{rom_a,rom_theta}<={9'd0,9'd18};
12'd112:{rom_a,rom_theta}<={9'd0,9'd18};
12'd113:{rom_a,rom_theta}<={9'd0,9'd18};
12'd114:{rom_a,rom_theta}<={9'd0,9'd18};
12'd115:{rom_a,rom_theta}<={9'd0,9'd18};
12'd116:{rom_a,rom_theta}<={9'd0,9'd18};
12'd117:{rom_a,rom_theta}<={9'd0,9'd19};
12'd118:{rom_a,rom_theta}<={9'd0,9'd19};
12'd119:{rom_a,rom_theta}<={9'd0,9'd19};
12'd120:{rom_a,rom_theta}<={9'd0,9'd19};
12'd121:{rom_a,rom_theta}<={9'd0,9'd19};
12'd122:{rom_a,rom_theta}<={9'd0,9'd19};
12'd123:{rom_a,rom_theta}<={9'd0,9'd20};
12'd124:{rom_a,rom_theta}<={9'd0,9'd20};
12'd125:{rom_a,rom_theta}<={9'd0,9'd20};
12'd126:{rom_a,rom_theta}<={9'd0,9'd20};
12'd127:{rom_a,rom_theta}<={9'd0,9'd20};
12'd128:{rom_a,rom_theta}<={9'd0,9'd20};
12'd129:{rom_a,rom_theta}<={9'd1,9'd21};
12'd130:{rom_a,rom_theta}<={9'd1,9'd21};
12'd131:{rom_a,rom_theta}<={9'd1,9'd21};
12'd132:{rom_a,rom_theta}<={9'd1,9'd21};
12'd133:{rom_a,rom_theta}<={9'd1,9'd21};
12'd134:{rom_a,rom_theta}<={9'd1,9'd21};
12'd135:{rom_a,rom_theta}<={9'd1,9'd21};
12'd136:{rom_a,rom_theta}<={9'd1,9'd22};
12'd137:{rom_a,rom_theta}<={9'd1,9'd22};
12'd138:{rom_a,rom_theta}<={9'd1,9'd22};
12'd139:{rom_a,rom_theta}<={9'd1,9'd22};
12'd140:{rom_a,rom_theta}<={9'd1,9'd22};
12'd141:{rom_a,rom_theta}<={9'd1,9'd22};
12'd142:{rom_a,rom_theta}<={9'd1,9'd23};
12'd143:{rom_a,rom_theta}<={9'd1,9'd23};
12'd144:{rom_a,rom_theta}<={9'd1,9'd23};
12'd145:{rom_a,rom_theta}<={9'd1,9'd23};
12'd146:{rom_a,rom_theta}<={9'd1,9'd23};
12'd147:{rom_a,rom_theta}<={9'd1,9'd23};
12'd148:{rom_a,rom_theta}<={9'd1,9'd24};
12'd149:{rom_a,rom_theta}<={9'd1,9'd24};
12'd150:{rom_a,rom_theta}<={9'd1,9'd24};
12'd151:{rom_a,rom_theta}<={9'd1,9'd24};
12'd152:{rom_a,rom_theta}<={9'd1,9'd24};
12'd153:{rom_a,rom_theta}<={9'd1,9'd24};
12'd154:{rom_a,rom_theta}<={9'd1,9'd24};
12'd155:{rom_a,rom_theta}<={9'd1,9'd25};
12'd156:{rom_a,rom_theta}<={9'd1,9'd25};
12'd157:{rom_a,rom_theta}<={9'd1,9'd25};
12'd158:{rom_a,rom_theta}<={9'd1,9'd25};
12'd159:{rom_a,rom_theta}<={9'd1,9'd25};
12'd160:{rom_a,rom_theta}<={9'd1,9'd25};
12'd161:{rom_a,rom_theta}<={9'd1,9'd26};
12'd162:{rom_a,rom_theta}<={9'd1,9'd26};
12'd163:{rom_a,rom_theta}<={9'd1,9'd26};
12'd164:{rom_a,rom_theta}<={9'd1,9'd26};
12'd165:{rom_a,rom_theta}<={9'd1,9'd26};
12'd166:{rom_a,rom_theta}<={9'd1,9'd26};
12'd167:{rom_a,rom_theta}<={9'd1,9'd27};
12'd168:{rom_a,rom_theta}<={9'd1,9'd27};
12'd169:{rom_a,rom_theta}<={9'd1,9'd27};
12'd170:{rom_a,rom_theta}<={9'd1,9'd27};
12'd171:{rom_a,rom_theta}<={9'd1,9'd27};
12'd172:{rom_a,rom_theta}<={9'd1,9'd27};
12'd173:{rom_a,rom_theta}<={9'd1,9'd28};
12'd174:{rom_a,rom_theta}<={9'd1,9'd28};
12'd175:{rom_a,rom_theta}<={9'd1,9'd28};
12'd176:{rom_a,rom_theta}<={9'd1,9'd28};
12'd177:{rom_a,rom_theta}<={9'd1,9'd28};
12'd178:{rom_a,rom_theta}<={9'd1,9'd28};
12'd179:{rom_a,rom_theta}<={9'd1,9'd28};
12'd180:{rom_a,rom_theta}<={9'd1,9'd29};
12'd181:{rom_a,rom_theta}<={9'd1,9'd29};
12'd182:{rom_a,rom_theta}<={9'd1,9'd29};
12'd183:{rom_a,rom_theta}<={9'd1,9'd29};
12'd184:{rom_a,rom_theta}<={9'd1,9'd29};
12'd185:{rom_a,rom_theta}<={9'd1,9'd29};
12'd186:{rom_a,rom_theta}<={9'd1,9'd30};
12'd187:{rom_a,rom_theta}<={9'd1,9'd30};
12'd188:{rom_a,rom_theta}<={9'd1,9'd30};
12'd189:{rom_a,rom_theta}<={9'd1,9'd30};
12'd190:{rom_a,rom_theta}<={9'd1,9'd30};
12'd191:{rom_a,rom_theta}<={9'd1,9'd30};
12'd192:{rom_a,rom_theta}<={9'd1,9'd31};
12'd193:{rom_a,rom_theta}<={9'd1,9'd31};
12'd194:{rom_a,rom_theta}<={9'd1,9'd31};
12'd195:{rom_a,rom_theta}<={9'd1,9'd31};
12'd196:{rom_a,rom_theta}<={9'd1,9'd31};
12'd197:{rom_a,rom_theta}<={9'd1,9'd31};
12'd198:{rom_a,rom_theta}<={9'd1,9'd31};
12'd199:{rom_a,rom_theta}<={9'd1,9'd32};
12'd200:{rom_a,rom_theta}<={9'd1,9'd32};
12'd201:{rom_a,rom_theta}<={9'd1,9'd32};
12'd202:{rom_a,rom_theta}<={9'd1,9'd32};
12'd203:{rom_a,rom_theta}<={9'd1,9'd32};
12'd204:{rom_a,rom_theta}<={9'd1,9'd32};
12'd205:{rom_a,rom_theta}<={9'd1,9'd33};
12'd206:{rom_a,rom_theta}<={9'd1,9'd33};
12'd207:{rom_a,rom_theta}<={9'd1,9'd33};
12'd208:{rom_a,rom_theta}<={9'd1,9'd33};
12'd209:{rom_a,rom_theta}<={9'd1,9'd33};
12'd210:{rom_a,rom_theta}<={9'd1,9'd33};
12'd211:{rom_a,rom_theta}<={9'd1,9'd34};
12'd212:{rom_a,rom_theta}<={9'd1,9'd34};
12'd213:{rom_a,rom_theta}<={9'd1,9'd34};
12'd214:{rom_a,rom_theta}<={9'd1,9'd34};
12'd215:{rom_a,rom_theta}<={9'd1,9'd34};
12'd216:{rom_a,rom_theta}<={9'd1,9'd34};
12'd217:{rom_a,rom_theta}<={9'd1,9'd35};
12'd218:{rom_a,rom_theta}<={9'd1,9'd35};
12'd219:{rom_a,rom_theta}<={9'd1,9'd35};
12'd220:{rom_a,rom_theta}<={9'd1,9'd35};
12'd221:{rom_a,rom_theta}<={9'd1,9'd35};
12'd222:{rom_a,rom_theta}<={9'd2,9'd35};
12'd223:{rom_a,rom_theta}<={9'd2,9'd35};
12'd224:{rom_a,rom_theta}<={9'd2,9'd36};
12'd225:{rom_a,rom_theta}<={9'd2,9'd36};
12'd226:{rom_a,rom_theta}<={9'd2,9'd36};
12'd227:{rom_a,rom_theta}<={9'd2,9'd36};
12'd228:{rom_a,rom_theta}<={9'd2,9'd36};
12'd229:{rom_a,rom_theta}<={9'd2,9'd36};
12'd230:{rom_a,rom_theta}<={9'd2,9'd37};
12'd231:{rom_a,rom_theta}<={9'd2,9'd37};
12'd232:{rom_a,rom_theta}<={9'd2,9'd37};
12'd233:{rom_a,rom_theta}<={9'd2,9'd37};
12'd234:{rom_a,rom_theta}<={9'd2,9'd37};
12'd235:{rom_a,rom_theta}<={9'd2,9'd37};
12'd236:{rom_a,rom_theta}<={9'd2,9'd38};
12'd237:{rom_a,rom_theta}<={9'd2,9'd38};
12'd238:{rom_a,rom_theta}<={9'd2,9'd38};
12'd239:{rom_a,rom_theta}<={9'd2,9'd38};
12'd240:{rom_a,rom_theta}<={9'd2,9'd38};
12'd241:{rom_a,rom_theta}<={9'd2,9'd38};
12'd242:{rom_a,rom_theta}<={9'd2,9'd38};
12'd243:{rom_a,rom_theta}<={9'd2,9'd39};
12'd244:{rom_a,rom_theta}<={9'd2,9'd39};
12'd245:{rom_a,rom_theta}<={9'd2,9'd39};
12'd246:{rom_a,rom_theta}<={9'd2,9'd39};
12'd247:{rom_a,rom_theta}<={9'd2,9'd39};
12'd248:{rom_a,rom_theta}<={9'd2,9'd39};
12'd249:{rom_a,rom_theta}<={9'd2,9'd40};
12'd250:{rom_a,rom_theta}<={9'd2,9'd40};
12'd251:{rom_a,rom_theta}<={9'd2,9'd40};
12'd252:{rom_a,rom_theta}<={9'd2,9'd40};
12'd253:{rom_a,rom_theta}<={9'd2,9'd40};
12'd254:{rom_a,rom_theta}<={9'd2,9'd40};
12'd255:{rom_a,rom_theta}<={9'd2,9'd41};
12'd256:{rom_a,rom_theta}<={9'd2,9'd41};
12'd257:{rom_a,rom_theta}<={9'd2,9'd41};
12'd258:{rom_a,rom_theta}<={9'd2,9'd41};
12'd259:{rom_a,rom_theta}<={9'd2,9'd41};
12'd260:{rom_a,rom_theta}<={9'd2,9'd41};
12'd261:{rom_a,rom_theta}<={9'd2,9'd41};
12'd262:{rom_a,rom_theta}<={9'd2,9'd42};
12'd263:{rom_a,rom_theta}<={9'd2,9'd42};
12'd264:{rom_a,rom_theta}<={9'd2,9'd42};
12'd265:{rom_a,rom_theta}<={9'd2,9'd42};
12'd266:{rom_a,rom_theta}<={9'd2,9'd42};
12'd267:{rom_a,rom_theta}<={9'd2,9'd42};
12'd268:{rom_a,rom_theta}<={9'd2,9'd43};
12'd269:{rom_a,rom_theta}<={9'd2,9'd43};
12'd270:{rom_a,rom_theta}<={9'd2,9'd43};
12'd271:{rom_a,rom_theta}<={9'd2,9'd43};
12'd272:{rom_a,rom_theta}<={9'd2,9'd43};
12'd273:{rom_a,rom_theta}<={9'd2,9'd43};
12'd274:{rom_a,rom_theta}<={9'd2,9'd44};
12'd275:{rom_a,rom_theta}<={9'd2,9'd44};
12'd276:{rom_a,rom_theta}<={9'd2,9'd44};
12'd277:{rom_a,rom_theta}<={9'd2,9'd44};
12'd278:{rom_a,rom_theta}<={9'd2,9'd44};
12'd279:{rom_a,rom_theta}<={9'd2,9'd44};
12'd280:{rom_a,rom_theta}<={9'd2,9'd44};
12'd281:{rom_a,rom_theta}<={9'd2,9'd45};
12'd282:{rom_a,rom_theta}<={9'd2,9'd45};
12'd283:{rom_a,rom_theta}<={9'd2,9'd45};
12'd284:{rom_a,rom_theta}<={9'd2,9'd45};
12'd285:{rom_a,rom_theta}<={9'd2,9'd45};
12'd286:{rom_a,rom_theta}<={9'd2,9'd45};
12'd287:{rom_a,rom_theta}<={9'd3,9'd46};
12'd288:{rom_a,rom_theta}<={9'd3,9'd46};
12'd289:{rom_a,rom_theta}<={9'd3,9'd46};
12'd290:{rom_a,rom_theta}<={9'd3,9'd46};
12'd291:{rom_a,rom_theta}<={9'd3,9'd46};
12'd292:{rom_a,rom_theta}<={9'd3,9'd46};
12'd293:{rom_a,rom_theta}<={9'd3,9'd47};
12'd294:{rom_a,rom_theta}<={9'd3,9'd47};
12'd295:{rom_a,rom_theta}<={9'd3,9'd47};
12'd296:{rom_a,rom_theta}<={9'd3,9'd47};
12'd297:{rom_a,rom_theta}<={9'd3,9'd47};
12'd298:{rom_a,rom_theta}<={9'd3,9'd47};
12'd299:{rom_a,rom_theta}<={9'd3,9'd48};
12'd300:{rom_a,rom_theta}<={9'd3,9'd48};
12'd301:{rom_a,rom_theta}<={9'd3,9'd48};
12'd302:{rom_a,rom_theta}<={9'd3,9'd48};
12'd303:{rom_a,rom_theta}<={9'd3,9'd48};
12'd304:{rom_a,rom_theta}<={9'd3,9'd48};
12'd305:{rom_a,rom_theta}<={9'd3,9'd48};
12'd306:{rom_a,rom_theta}<={9'd3,9'd49};
12'd307:{rom_a,rom_theta}<={9'd3,9'd49};
12'd308:{rom_a,rom_theta}<={9'd3,9'd49};
12'd309:{rom_a,rom_theta}<={9'd3,9'd49};
12'd310:{rom_a,rom_theta}<={9'd3,9'd49};
12'd311:{rom_a,rom_theta}<={9'd3,9'd49};
12'd312:{rom_a,rom_theta}<={9'd3,9'd50};
12'd313:{rom_a,rom_theta}<={9'd3,9'd50};
12'd314:{rom_a,rom_theta}<={9'd3,9'd50};
12'd315:{rom_a,rom_theta}<={9'd3,9'd50};
12'd316:{rom_a,rom_theta}<={9'd3,9'd50};
12'd317:{rom_a,rom_theta}<={9'd3,9'd50};
12'd318:{rom_a,rom_theta}<={9'd3,9'd51};
12'd319:{rom_a,rom_theta}<={9'd3,9'd51};
12'd320:{rom_a,rom_theta}<={9'd3,9'd51};
12'd321:{rom_a,rom_theta}<={9'd3,9'd51};
12'd322:{rom_a,rom_theta}<={9'd3,9'd51};
12'd323:{rom_a,rom_theta}<={9'd3,9'd51};
12'd324:{rom_a,rom_theta}<={9'd3,9'd51};
12'd325:{rom_a,rom_theta}<={9'd3,9'd52};
12'd326:{rom_a,rom_theta}<={9'd3,9'd52};
12'd327:{rom_a,rom_theta}<={9'd3,9'd52};
12'd328:{rom_a,rom_theta}<={9'd3,9'd52};
12'd329:{rom_a,rom_theta}<={9'd3,9'd52};
12'd330:{rom_a,rom_theta}<={9'd3,9'd52};
12'd331:{rom_a,rom_theta}<={9'd3,9'd53};
12'd332:{rom_a,rom_theta}<={9'd3,9'd53};
12'd333:{rom_a,rom_theta}<={9'd3,9'd53};
12'd334:{rom_a,rom_theta}<={9'd3,9'd53};
12'd335:{rom_a,rom_theta}<={9'd3,9'd53};
12'd336:{rom_a,rom_theta}<={9'd3,9'd53};
12'd337:{rom_a,rom_theta}<={9'd3,9'd54};
12'd338:{rom_a,rom_theta}<={9'd3,9'd54};
12'd339:{rom_a,rom_theta}<={9'd4,9'd54};
12'd340:{rom_a,rom_theta}<={9'd4,9'd54};
12'd341:{rom_a,rom_theta}<={9'd4,9'd54};
12'd342:{rom_a,rom_theta}<={9'd4,9'd54};
12'd343:{rom_a,rom_theta}<={9'd4,9'd54};
12'd344:{rom_a,rom_theta}<={9'd4,9'd55};
12'd345:{rom_a,rom_theta}<={9'd4,9'd55};
12'd346:{rom_a,rom_theta}<={9'd4,9'd55};
12'd347:{rom_a,rom_theta}<={9'd4,9'd55};
12'd348:{rom_a,rom_theta}<={9'd4,9'd55};
12'd349:{rom_a,rom_theta}<={9'd4,9'd55};
12'd350:{rom_a,rom_theta}<={9'd4,9'd56};
12'd351:{rom_a,rom_theta}<={9'd4,9'd56};
12'd352:{rom_a,rom_theta}<={9'd4,9'd56};
12'd353:{rom_a,rom_theta}<={9'd4,9'd56};
12'd354:{rom_a,rom_theta}<={9'd4,9'd56};
12'd355:{rom_a,rom_theta}<={9'd4,9'd56};
12'd356:{rom_a,rom_theta}<={9'd4,9'd57};
12'd357:{rom_a,rom_theta}<={9'd4,9'd57};
12'd358:{rom_a,rom_theta}<={9'd4,9'd57};
12'd359:{rom_a,rom_theta}<={9'd4,9'd57};
12'd360:{rom_a,rom_theta}<={9'd4,9'd57};
12'd361:{rom_a,rom_theta}<={9'd4,9'd57};
12'd362:{rom_a,rom_theta}<={9'd4,9'd57};
12'd363:{rom_a,rom_theta}<={9'd4,9'd58};
12'd364:{rom_a,rom_theta}<={9'd4,9'd58};
12'd365:{rom_a,rom_theta}<={9'd4,9'd58};
12'd366:{rom_a,rom_theta}<={9'd4,9'd58};
12'd367:{rom_a,rom_theta}<={9'd4,9'd58};
12'd368:{rom_a,rom_theta}<={9'd4,9'd58};
12'd369:{rom_a,rom_theta}<={9'd4,9'd59};
12'd370:{rom_a,rom_theta}<={9'd4,9'd59};
12'd371:{rom_a,rom_theta}<={9'd4,9'd59};
12'd372:{rom_a,rom_theta}<={9'd4,9'd59};
12'd373:{rom_a,rom_theta}<={9'd4,9'd59};
12'd374:{rom_a,rom_theta}<={9'd4,9'd59};
12'd375:{rom_a,rom_theta}<={9'd4,9'd60};
12'd376:{rom_a,rom_theta}<={9'd4,9'd60};
12'd377:{rom_a,rom_theta}<={9'd4,9'd60};
12'd378:{rom_a,rom_theta}<={9'd4,9'd60};
12'd379:{rom_a,rom_theta}<={9'd4,9'd60};
12'd380:{rom_a,rom_theta}<={9'd4,9'd60};
12'd381:{rom_a,rom_theta}<={9'd4,9'd60};
12'd382:{rom_a,rom_theta}<={9'd4,9'd61};
12'd383:{rom_a,rom_theta}<={9'd4,9'd61};
12'd384:{rom_a,rom_theta}<={9'd4,9'd61};
12'd385:{rom_a,rom_theta}<={9'd5,9'd61};
12'd386:{rom_a,rom_theta}<={9'd5,9'd61};
12'd387:{rom_a,rom_theta}<={9'd5,9'd61};
12'd388:{rom_a,rom_theta}<={9'd5,9'd62};
12'd389:{rom_a,rom_theta}<={9'd5,9'd62};
12'd390:{rom_a,rom_theta}<={9'd5,9'd62};
12'd391:{rom_a,rom_theta}<={9'd5,9'd62};
12'd392:{rom_a,rom_theta}<={9'd5,9'd62};
12'd393:{rom_a,rom_theta}<={9'd5,9'd62};
12'd394:{rom_a,rom_theta}<={9'd5,9'd63};
12'd395:{rom_a,rom_theta}<={9'd5,9'd63};
12'd396:{rom_a,rom_theta}<={9'd5,9'd63};
12'd397:{rom_a,rom_theta}<={9'd5,9'd63};
12'd398:{rom_a,rom_theta}<={9'd5,9'd63};
12'd399:{rom_a,rom_theta}<={9'd5,9'd63};
12'd400:{rom_a,rom_theta}<={9'd5,9'd63};
12'd401:{rom_a,rom_theta}<={9'd5,9'd64};
12'd402:{rom_a,rom_theta}<={9'd5,9'd64};
12'd403:{rom_a,rom_theta}<={9'd5,9'd64};
12'd404:{rom_a,rom_theta}<={9'd5,9'd64};
12'd405:{rom_a,rom_theta}<={9'd5,9'd64};
12'd406:{rom_a,rom_theta}<={9'd5,9'd64};
12'd407:{rom_a,rom_theta}<={9'd5,9'd65};
12'd408:{rom_a,rom_theta}<={9'd5,9'd65};
12'd409:{rom_a,rom_theta}<={9'd5,9'd65};
12'd410:{rom_a,rom_theta}<={9'd5,9'd65};
12'd411:{rom_a,rom_theta}<={9'd5,9'd65};
12'd412:{rom_a,rom_theta}<={9'd5,9'd65};
12'd413:{rom_a,rom_theta}<={9'd5,9'd66};
12'd414:{rom_a,rom_theta}<={9'd5,9'd66};
12'd415:{rom_a,rom_theta}<={9'd5,9'd66};
12'd416:{rom_a,rom_theta}<={9'd5,9'd66};
12'd417:{rom_a,rom_theta}<={9'd5,9'd66};
12'd418:{rom_a,rom_theta}<={9'd5,9'd66};
12'd419:{rom_a,rom_theta}<={9'd5,9'd66};
12'd420:{rom_a,rom_theta}<={9'd5,9'd67};
12'd421:{rom_a,rom_theta}<={9'd5,9'd67};
12'd422:{rom_a,rom_theta}<={9'd5,9'd67};
12'd423:{rom_a,rom_theta}<={9'd5,9'd67};
12'd424:{rom_a,rom_theta}<={9'd5,9'd67};
12'd425:{rom_a,rom_theta}<={9'd5,9'd67};
12'd426:{rom_a,rom_theta}<={9'd6,9'd68};
12'd427:{rom_a,rom_theta}<={9'd6,9'd68};
12'd428:{rom_a,rom_theta}<={9'd6,9'd68};
12'd429:{rom_a,rom_theta}<={9'd6,9'd68};
12'd430:{rom_a,rom_theta}<={9'd6,9'd68};
12'd431:{rom_a,rom_theta}<={9'd6,9'd68};
12'd432:{rom_a,rom_theta}<={9'd6,9'd69};
12'd433:{rom_a,rom_theta}<={9'd6,9'd69};
12'd434:{rom_a,rom_theta}<={9'd6,9'd69};
12'd435:{rom_a,rom_theta}<={9'd6,9'd69};
12'd436:{rom_a,rom_theta}<={9'd6,9'd69};
12'd437:{rom_a,rom_theta}<={9'd6,9'd69};
12'd438:{rom_a,rom_theta}<={9'd6,9'd69};
12'd439:{rom_a,rom_theta}<={9'd6,9'd70};
12'd440:{rom_a,rom_theta}<={9'd6,9'd70};
12'd441:{rom_a,rom_theta}<={9'd6,9'd70};
12'd442:{rom_a,rom_theta}<={9'd6,9'd70};
12'd443:{rom_a,rom_theta}<={9'd6,9'd70};
12'd444:{rom_a,rom_theta}<={9'd6,9'd70};
12'd445:{rom_a,rom_theta}<={9'd6,9'd71};
12'd446:{rom_a,rom_theta}<={9'd6,9'd71};
12'd447:{rom_a,rom_theta}<={9'd6,9'd71};
12'd448:{rom_a,rom_theta}<={9'd6,9'd71};
12'd449:{rom_a,rom_theta}<={9'd6,9'd71};
12'd450:{rom_a,rom_theta}<={9'd6,9'd71};
12'd451:{rom_a,rom_theta}<={9'd6,9'd71};
12'd452:{rom_a,rom_theta}<={9'd6,9'd72};
12'd453:{rom_a,rom_theta}<={9'd6,9'd72};
12'd454:{rom_a,rom_theta}<={9'd6,9'd72};
12'd455:{rom_a,rom_theta}<={9'd6,9'd72};
12'd456:{rom_a,rom_theta}<={9'd6,9'd72};
12'd457:{rom_a,rom_theta}<={9'd6,9'd72};
12'd458:{rom_a,rom_theta}<={9'd6,9'd73};
12'd459:{rom_a,rom_theta}<={9'd6,9'd73};
12'd460:{rom_a,rom_theta}<={9'd6,9'd73};
12'd461:{rom_a,rom_theta}<={9'd6,9'd73};
12'd462:{rom_a,rom_theta}<={9'd6,9'd73};
12'd463:{rom_a,rom_theta}<={9'd7,9'd73};
12'd464:{rom_a,rom_theta}<={9'd7,9'd74};
12'd465:{rom_a,rom_theta}<={9'd7,9'd74};
12'd466:{rom_a,rom_theta}<={9'd7,9'd74};
12'd467:{rom_a,rom_theta}<={9'd7,9'd74};
12'd468:{rom_a,rom_theta}<={9'd7,9'd74};
12'd469:{rom_a,rom_theta}<={9'd7,9'd74};
12'd470:{rom_a,rom_theta}<={9'd7,9'd74};
12'd471:{rom_a,rom_theta}<={9'd7,9'd75};
12'd472:{rom_a,rom_theta}<={9'd7,9'd75};
12'd473:{rom_a,rom_theta}<={9'd7,9'd75};
12'd474:{rom_a,rom_theta}<={9'd7,9'd75};
12'd475:{rom_a,rom_theta}<={9'd7,9'd75};
12'd476:{rom_a,rom_theta}<={9'd7,9'd75};
12'd477:{rom_a,rom_theta}<={9'd7,9'd76};
12'd478:{rom_a,rom_theta}<={9'd7,9'd76};
12'd479:{rom_a,rom_theta}<={9'd7,9'd76};
12'd480:{rom_a,rom_theta}<={9'd7,9'd76};
12'd481:{rom_a,rom_theta}<={9'd7,9'd76};
12'd482:{rom_a,rom_theta}<={9'd7,9'd76};
12'd483:{rom_a,rom_theta}<={9'd7,9'd77};
12'd484:{rom_a,rom_theta}<={9'd7,9'd77};
12'd485:{rom_a,rom_theta}<={9'd7,9'd77};
12'd486:{rom_a,rom_theta}<={9'd7,9'd77};
12'd487:{rom_a,rom_theta}<={9'd7,9'd77};
12'd488:{rom_a,rom_theta}<={9'd7,9'd77};
12'd489:{rom_a,rom_theta}<={9'd7,9'd77};
12'd490:{rom_a,rom_theta}<={9'd7,9'd78};
12'd491:{rom_a,rom_theta}<={9'd7,9'd78};
12'd492:{rom_a,rom_theta}<={9'd7,9'd78};
12'd493:{rom_a,rom_theta}<={9'd7,9'd78};
12'd494:{rom_a,rom_theta}<={9'd7,9'd78};
12'd495:{rom_a,rom_theta}<={9'd7,9'd78};
12'd496:{rom_a,rom_theta}<={9'd7,9'd79};
12'd497:{rom_a,rom_theta}<={9'd8,9'd79};
12'd498:{rom_a,rom_theta}<={9'd8,9'd79};
12'd499:{rom_a,rom_theta}<={9'd8,9'd79};
12'd500:{rom_a,rom_theta}<={9'd8,9'd79};
12'd501:{rom_a,rom_theta}<={9'd8,9'd79};
12'd502:{rom_a,rom_theta}<={9'd8,9'd79};
12'd503:{rom_a,rom_theta}<={9'd8,9'd80};
12'd504:{rom_a,rom_theta}<={9'd8,9'd80};
12'd505:{rom_a,rom_theta}<={9'd8,9'd80};
12'd506:{rom_a,rom_theta}<={9'd8,9'd80};
12'd507:{rom_a,rom_theta}<={9'd8,9'd80};
12'd508:{rom_a,rom_theta}<={9'd8,9'd80};
12'd509:{rom_a,rom_theta}<={9'd8,9'd81};
12'd510:{rom_a,rom_theta}<={9'd8,9'd81};
12'd511:{rom_a,rom_theta}<={9'd8,9'd81};
12'd512:{rom_a,rom_theta}<={9'd8,9'd81};
12'd513:{rom_a,rom_theta}<={9'd8,9'd81};
12'd514:{rom_a,rom_theta}<={9'd8,9'd81};
12'd515:{rom_a,rom_theta}<={9'd8,9'd82};
12'd516:{rom_a,rom_theta}<={9'd8,9'd82};
12'd517:{rom_a,rom_theta}<={9'd8,9'd82};
12'd518:{rom_a,rom_theta}<={9'd8,9'd82};
12'd519:{rom_a,rom_theta}<={9'd8,9'd82};
12'd520:{rom_a,rom_theta}<={9'd8,9'd82};
12'd521:{rom_a,rom_theta}<={9'd8,9'd82};
12'd522:{rom_a,rom_theta}<={9'd8,9'd83};
12'd523:{rom_a,rom_theta}<={9'd8,9'd83};
12'd524:{rom_a,rom_theta}<={9'd8,9'd83};
12'd525:{rom_a,rom_theta}<={9'd8,9'd83};
12'd526:{rom_a,rom_theta}<={9'd8,9'd83};
12'd527:{rom_a,rom_theta}<={9'd8,9'd83};
12'd528:{rom_a,rom_theta}<={9'd8,9'd84};
12'd529:{rom_a,rom_theta}<={9'd9,9'd84};
12'd530:{rom_a,rom_theta}<={9'd9,9'd84};
12'd531:{rom_a,rom_theta}<={9'd9,9'd84};
12'd532:{rom_a,rom_theta}<={9'd9,9'd84};
12'd533:{rom_a,rom_theta}<={9'd9,9'd84};
12'd534:{rom_a,rom_theta}<={9'd9,9'd85};
12'd535:{rom_a,rom_theta}<={9'd9,9'd85};
12'd536:{rom_a,rom_theta}<={9'd9,9'd85};
12'd537:{rom_a,rom_theta}<={9'd9,9'd85};
12'd538:{rom_a,rom_theta}<={9'd9,9'd85};
12'd539:{rom_a,rom_theta}<={9'd9,9'd85};
12'd540:{rom_a,rom_theta}<={9'd9,9'd85};
12'd541:{rom_a,rom_theta}<={9'd9,9'd86};
12'd542:{rom_a,rom_theta}<={9'd9,9'd86};
12'd543:{rom_a,rom_theta}<={9'd9,9'd86};
12'd544:{rom_a,rom_theta}<={9'd9,9'd86};
12'd545:{rom_a,rom_theta}<={9'd9,9'd86};
12'd546:{rom_a,rom_theta}<={9'd9,9'd86};
12'd547:{rom_a,rom_theta}<={9'd9,9'd87};
12'd548:{rom_a,rom_theta}<={9'd9,9'd87};
12'd549:{rom_a,rom_theta}<={9'd9,9'd87};
12'd550:{rom_a,rom_theta}<={9'd9,9'd87};
12'd551:{rom_a,rom_theta}<={9'd9,9'd87};
12'd552:{rom_a,rom_theta}<={9'd9,9'd87};
12'd553:{rom_a,rom_theta}<={9'd9,9'd87};
12'd554:{rom_a,rom_theta}<={9'd9,9'd88};
12'd555:{rom_a,rom_theta}<={9'd9,9'd88};
12'd556:{rom_a,rom_theta}<={9'd9,9'd88};
12'd557:{rom_a,rom_theta}<={9'd9,9'd88};
12'd558:{rom_a,rom_theta}<={9'd9,9'd88};
12'd559:{rom_a,rom_theta}<={9'd9,9'd88};
12'd560:{rom_a,rom_theta}<={9'd10,9'd89};
12'd561:{rom_a,rom_theta}<={9'd10,9'd89};
12'd562:{rom_a,rom_theta}<={9'd10,9'd89};
12'd563:{rom_a,rom_theta}<={9'd10,9'd89};
12'd564:{rom_a,rom_theta}<={9'd10,9'd89};
12'd565:{rom_a,rom_theta}<={9'd10,9'd89};
12'd566:{rom_a,rom_theta}<={9'd10,9'd90};
12'd567:{rom_a,rom_theta}<={9'd10,9'd90};
12'd568:{rom_a,rom_theta}<={9'd10,9'd90};
12'd569:{rom_a,rom_theta}<={9'd10,9'd90};
12'd570:{rom_a,rom_theta}<={9'd10,9'd90};
12'd571:{rom_a,rom_theta}<={9'd10,9'd90};
12'd572:{rom_a,rom_theta}<={9'd10,9'd90};
12'd573:{rom_a,rom_theta}<={9'd10,9'd91};
12'd574:{rom_a,rom_theta}<={9'd10,9'd91};
12'd575:{rom_a,rom_theta}<={9'd10,9'd91};
12'd576:{rom_a,rom_theta}<={9'd10,9'd91};
12'd577:{rom_a,rom_theta}<={9'd10,9'd91};
12'd578:{rom_a,rom_theta}<={9'd10,9'd91};
12'd579:{rom_a,rom_theta}<={9'd10,9'd92};
12'd580:{rom_a,rom_theta}<={9'd10,9'd92};
12'd581:{rom_a,rom_theta}<={9'd10,9'd92};
12'd582:{rom_a,rom_theta}<={9'd10,9'd92};
12'd583:{rom_a,rom_theta}<={9'd10,9'd92};
12'd584:{rom_a,rom_theta}<={9'd10,9'd92};
12'd585:{rom_a,rom_theta}<={9'd10,9'd92};
12'd586:{rom_a,rom_theta}<={9'd10,9'd93};
12'd587:{rom_a,rom_theta}<={9'd10,9'd93};
12'd588:{rom_a,rom_theta}<={9'd10,9'd93};
12'd589:{rom_a,rom_theta}<={9'd11,9'd93};
12'd590:{rom_a,rom_theta}<={9'd11,9'd93};
12'd591:{rom_a,rom_theta}<={9'd11,9'd93};
12'd592:{rom_a,rom_theta}<={9'd11,9'd94};
12'd593:{rom_a,rom_theta}<={9'd11,9'd94};
12'd594:{rom_a,rom_theta}<={9'd11,9'd94};
12'd595:{rom_a,rom_theta}<={9'd11,9'd94};
12'd596:{rom_a,rom_theta}<={9'd11,9'd94};
12'd597:{rom_a,rom_theta}<={9'd11,9'd94};
12'd598:{rom_a,rom_theta}<={9'd11,9'd95};
12'd599:{rom_a,rom_theta}<={9'd11,9'd95};
12'd600:{rom_a,rom_theta}<={9'd11,9'd95};
12'd601:{rom_a,rom_theta}<={9'd11,9'd95};
12'd602:{rom_a,rom_theta}<={9'd11,9'd95};
12'd603:{rom_a,rom_theta}<={9'd11,9'd95};
12'd604:{rom_a,rom_theta}<={9'd11,9'd95};
12'd605:{rom_a,rom_theta}<={9'd11,9'd96};
12'd606:{rom_a,rom_theta}<={9'd11,9'd96};
12'd607:{rom_a,rom_theta}<={9'd11,9'd96};
12'd608:{rom_a,rom_theta}<={9'd11,9'd96};
12'd609:{rom_a,rom_theta}<={9'd11,9'd96};
12'd610:{rom_a,rom_theta}<={9'd11,9'd96};
12'd611:{rom_a,rom_theta}<={9'd11,9'd97};
12'd612:{rom_a,rom_theta}<={9'd11,9'd97};
12'd613:{rom_a,rom_theta}<={9'd11,9'd97};
12'd614:{rom_a,rom_theta}<={9'd11,9'd97};
12'd615:{rom_a,rom_theta}<={9'd11,9'd97};
12'd616:{rom_a,rom_theta}<={9'd12,9'd97};
12'd617:{rom_a,rom_theta}<={9'd12,9'd97};
12'd618:{rom_a,rom_theta}<={9'd12,9'd98};
12'd619:{rom_a,rom_theta}<={9'd12,9'd98};
12'd620:{rom_a,rom_theta}<={9'd12,9'd98};
12'd621:{rom_a,rom_theta}<={9'd12,9'd98};
12'd622:{rom_a,rom_theta}<={9'd12,9'd98};
12'd623:{rom_a,rom_theta}<={9'd12,9'd98};
12'd624:{rom_a,rom_theta}<={9'd12,9'd99};
12'd625:{rom_a,rom_theta}<={9'd12,9'd99};
12'd626:{rom_a,rom_theta}<={9'd12,9'd99};
12'd627:{rom_a,rom_theta}<={9'd12,9'd99};
12'd628:{rom_a,rom_theta}<={9'd12,9'd99};
12'd629:{rom_a,rom_theta}<={9'd12,9'd99};
12'd630:{rom_a,rom_theta}<={9'd12,9'd99};
12'd631:{rom_a,rom_theta}<={9'd12,9'd100};
12'd632:{rom_a,rom_theta}<={9'd12,9'd100};
12'd633:{rom_a,rom_theta}<={9'd12,9'd100};
12'd634:{rom_a,rom_theta}<={9'd12,9'd100};
12'd635:{rom_a,rom_theta}<={9'd12,9'd100};
12'd636:{rom_a,rom_theta}<={9'd12,9'd100};
12'd637:{rom_a,rom_theta}<={9'd12,9'd101};
12'd638:{rom_a,rom_theta}<={9'd12,9'd101};
12'd639:{rom_a,rom_theta}<={9'd12,9'd101};
12'd640:{rom_a,rom_theta}<={9'd12,9'd101};
12'd641:{rom_a,rom_theta}<={9'd12,9'd101};
12'd642:{rom_a,rom_theta}<={9'd13,9'd101};
12'd643:{rom_a,rom_theta}<={9'd13,9'd102};
12'd644:{rom_a,rom_theta}<={9'd13,9'd102};
12'd645:{rom_a,rom_theta}<={9'd13,9'd102};
12'd646:{rom_a,rom_theta}<={9'd13,9'd102};
12'd647:{rom_a,rom_theta}<={9'd13,9'd102};
12'd648:{rom_a,rom_theta}<={9'd13,9'd102};
12'd649:{rom_a,rom_theta}<={9'd13,9'd102};
12'd650:{rom_a,rom_theta}<={9'd13,9'd103};
12'd651:{rom_a,rom_theta}<={9'd13,9'd103};
12'd652:{rom_a,rom_theta}<={9'd13,9'd103};
12'd653:{rom_a,rom_theta}<={9'd13,9'd103};
12'd654:{rom_a,rom_theta}<={9'd13,9'd103};
12'd655:{rom_a,rom_theta}<={9'd13,9'd103};
12'd656:{rom_a,rom_theta}<={9'd13,9'd104};
12'd657:{rom_a,rom_theta}<={9'd13,9'd104};
12'd658:{rom_a,rom_theta}<={9'd13,9'd104};
12'd659:{rom_a,rom_theta}<={9'd13,9'd104};
12'd660:{rom_a,rom_theta}<={9'd13,9'd104};
12'd661:{rom_a,rom_theta}<={9'd13,9'd104};
12'd662:{rom_a,rom_theta}<={9'd13,9'd104};
12'd663:{rom_a,rom_theta}<={9'd13,9'd105};
12'd664:{rom_a,rom_theta}<={9'd13,9'd105};
12'd665:{rom_a,rom_theta}<={9'd13,9'd105};
12'd666:{rom_a,rom_theta}<={9'd13,9'd105};
12'd667:{rom_a,rom_theta}<={9'd13,9'd105};
12'd668:{rom_a,rom_theta}<={9'd14,9'd105};
12'd669:{rom_a,rom_theta}<={9'd14,9'd106};
12'd670:{rom_a,rom_theta}<={9'd14,9'd106};
12'd671:{rom_a,rom_theta}<={9'd14,9'd106};
12'd672:{rom_a,rom_theta}<={9'd14,9'd106};
12'd673:{rom_a,rom_theta}<={9'd14,9'd106};
12'd674:{rom_a,rom_theta}<={9'd14,9'd106};
12'd675:{rom_a,rom_theta}<={9'd14,9'd106};
12'd676:{rom_a,rom_theta}<={9'd14,9'd107};
12'd677:{rom_a,rom_theta}<={9'd14,9'd107};
12'd678:{rom_a,rom_theta}<={9'd14,9'd107};
12'd679:{rom_a,rom_theta}<={9'd14,9'd107};
12'd680:{rom_a,rom_theta}<={9'd14,9'd107};
12'd681:{rom_a,rom_theta}<={9'd14,9'd107};
12'd682:{rom_a,rom_theta}<={9'd14,9'd108};
12'd683:{rom_a,rom_theta}<={9'd14,9'd108};
12'd684:{rom_a,rom_theta}<={9'd14,9'd108};
12'd685:{rom_a,rom_theta}<={9'd14,9'd108};
12'd686:{rom_a,rom_theta}<={9'd14,9'd108};
12'd687:{rom_a,rom_theta}<={9'd14,9'd108};
12'd688:{rom_a,rom_theta}<={9'd14,9'd108};
12'd689:{rom_a,rom_theta}<={9'd14,9'd109};
12'd690:{rom_a,rom_theta}<={9'd14,9'd109};
12'd691:{rom_a,rom_theta}<={9'd14,9'd109};
12'd692:{rom_a,rom_theta}<={9'd15,9'd109};
12'd693:{rom_a,rom_theta}<={9'd15,9'd109};
12'd694:{rom_a,rom_theta}<={9'd15,9'd109};
12'd695:{rom_a,rom_theta}<={9'd15,9'd110};
12'd696:{rom_a,rom_theta}<={9'd15,9'd110};
12'd697:{rom_a,rom_theta}<={9'd15,9'd110};
12'd698:{rom_a,rom_theta}<={9'd15,9'd110};
12'd699:{rom_a,rom_theta}<={9'd15,9'd110};
12'd700:{rom_a,rom_theta}<={9'd15,9'd110};
12'd701:{rom_a,rom_theta}<={9'd15,9'd110};
12'd702:{rom_a,rom_theta}<={9'd15,9'd111};
12'd703:{rom_a,rom_theta}<={9'd15,9'd111};
12'd704:{rom_a,rom_theta}<={9'd15,9'd111};
12'd705:{rom_a,rom_theta}<={9'd15,9'd111};
12'd706:{rom_a,rom_theta}<={9'd15,9'd111};
12'd707:{rom_a,rom_theta}<={9'd15,9'd111};
12'd708:{rom_a,rom_theta}<={9'd15,9'd112};
12'd709:{rom_a,rom_theta}<={9'd15,9'd112};
12'd710:{rom_a,rom_theta}<={9'd15,9'd112};
12'd711:{rom_a,rom_theta}<={9'd15,9'd112};
12'd712:{rom_a,rom_theta}<={9'd15,9'd112};
12'd713:{rom_a,rom_theta}<={9'd15,9'd112};
12'd714:{rom_a,rom_theta}<={9'd15,9'd113};
12'd715:{rom_a,rom_theta}<={9'd15,9'd113};
12'd716:{rom_a,rom_theta}<={9'd16,9'd113};
12'd717:{rom_a,rom_theta}<={9'd16,9'd113};
12'd718:{rom_a,rom_theta}<={9'd16,9'd113};
12'd719:{rom_a,rom_theta}<={9'd16,9'd113};
12'd720:{rom_a,rom_theta}<={9'd16,9'd113};
12'd721:{rom_a,rom_theta}<={9'd16,9'd114};
12'd722:{rom_a,rom_theta}<={9'd16,9'd114};
12'd723:{rom_a,rom_theta}<={9'd16,9'd114};
12'd724:{rom_a,rom_theta}<={9'd16,9'd114};
12'd725:{rom_a,rom_theta}<={9'd16,9'd114};
12'd726:{rom_a,rom_theta}<={9'd16,9'd114};
12'd727:{rom_a,rom_theta}<={9'd16,9'd115};
12'd728:{rom_a,rom_theta}<={9'd16,9'd115};
12'd729:{rom_a,rom_theta}<={9'd16,9'd115};
12'd730:{rom_a,rom_theta}<={9'd16,9'd115};
12'd731:{rom_a,rom_theta}<={9'd16,9'd115};
12'd732:{rom_a,rom_theta}<={9'd16,9'd115};
12'd733:{rom_a,rom_theta}<={9'd16,9'd115};
12'd734:{rom_a,rom_theta}<={9'd16,9'd116};
12'd735:{rom_a,rom_theta}<={9'd16,9'd116};
12'd736:{rom_a,rom_theta}<={9'd16,9'd116};
12'd737:{rom_a,rom_theta}<={9'd16,9'd116};
12'd738:{rom_a,rom_theta}<={9'd16,9'd116};
12'd739:{rom_a,rom_theta}<={9'd17,9'd116};
12'd740:{rom_a,rom_theta}<={9'd17,9'd117};
12'd741:{rom_a,rom_theta}<={9'd17,9'd117};
12'd742:{rom_a,rom_theta}<={9'd17,9'd117};
12'd743:{rom_a,rom_theta}<={9'd17,9'd117};
12'd744:{rom_a,rom_theta}<={9'd17,9'd117};
12'd745:{rom_a,rom_theta}<={9'd17,9'd117};
12'd746:{rom_a,rom_theta}<={9'd17,9'd117};
12'd747:{rom_a,rom_theta}<={9'd17,9'd118};
12'd748:{rom_a,rom_theta}<={9'd17,9'd118};
12'd749:{rom_a,rom_theta}<={9'd17,9'd118};
12'd750:{rom_a,rom_theta}<={9'd17,9'd118};
12'd751:{rom_a,rom_theta}<={9'd17,9'd118};
12'd752:{rom_a,rom_theta}<={9'd17,9'd118};
12'd753:{rom_a,rom_theta}<={9'd17,9'd119};
12'd754:{rom_a,rom_theta}<={9'd17,9'd119};
12'd755:{rom_a,rom_theta}<={9'd17,9'd119};
12'd756:{rom_a,rom_theta}<={9'd17,9'd119};
12'd757:{rom_a,rom_theta}<={9'd17,9'd119};
12'd758:{rom_a,rom_theta}<={9'd17,9'd119};
12'd759:{rom_a,rom_theta}<={9'd17,9'd119};
12'd760:{rom_a,rom_theta}<={9'd17,9'd120};
12'd761:{rom_a,rom_theta}<={9'd18,9'd120};
12'd762:{rom_a,rom_theta}<={9'd18,9'd120};
12'd763:{rom_a,rom_theta}<={9'd18,9'd120};
12'd764:{rom_a,rom_theta}<={9'd18,9'd120};
12'd765:{rom_a,rom_theta}<={9'd18,9'd120};
12'd766:{rom_a,rom_theta}<={9'd18,9'd121};
12'd767:{rom_a,rom_theta}<={9'd18,9'd121};
12'd768:{rom_a,rom_theta}<={9'd18,9'd121};
12'd769:{rom_a,rom_theta}<={9'd18,9'd121};
12'd770:{rom_a,rom_theta}<={9'd18,9'd121};
12'd771:{rom_a,rom_theta}<={9'd18,9'd121};
12'd772:{rom_a,rom_theta}<={9'd18,9'd121};
12'd773:{rom_a,rom_theta}<={9'd18,9'd122};
12'd774:{rom_a,rom_theta}<={9'd18,9'd122};
12'd775:{rom_a,rom_theta}<={9'd18,9'd122};
12'd776:{rom_a,rom_theta}<={9'd18,9'd122};
12'd777:{rom_a,rom_theta}<={9'd18,9'd122};
12'd778:{rom_a,rom_theta}<={9'd18,9'd122};
12'd779:{rom_a,rom_theta}<={9'd18,9'd123};
12'd780:{rom_a,rom_theta}<={9'd18,9'd123};
12'd781:{rom_a,rom_theta}<={9'd18,9'd123};
12'd782:{rom_a,rom_theta}<={9'd18,9'd123};
12'd783:{rom_a,rom_theta}<={9'd19,9'd123};
12'd784:{rom_a,rom_theta}<={9'd19,9'd123};
12'd785:{rom_a,rom_theta}<={9'd19,9'd123};
12'd786:{rom_a,rom_theta}<={9'd19,9'd124};
12'd787:{rom_a,rom_theta}<={9'd19,9'd124};
12'd788:{rom_a,rom_theta}<={9'd19,9'd124};
12'd789:{rom_a,rom_theta}<={9'd19,9'd124};
12'd790:{rom_a,rom_theta}<={9'd19,9'd124};
12'd791:{rom_a,rom_theta}<={9'd19,9'd124};
12'd792:{rom_a,rom_theta}<={9'd19,9'd125};
12'd793:{rom_a,rom_theta}<={9'd19,9'd125};
12'd794:{rom_a,rom_theta}<={9'd19,9'd125};
12'd795:{rom_a,rom_theta}<={9'd19,9'd125};
12'd796:{rom_a,rom_theta}<={9'd19,9'd125};
12'd797:{rom_a,rom_theta}<={9'd19,9'd125};
12'd798:{rom_a,rom_theta}<={9'd19,9'd125};
12'd799:{rom_a,rom_theta}<={9'd19,9'd126};
12'd800:{rom_a,rom_theta}<={9'd19,9'd126};
12'd801:{rom_a,rom_theta}<={9'd19,9'd126};
12'd802:{rom_a,rom_theta}<={9'd19,9'd126};
12'd803:{rom_a,rom_theta}<={9'd19,9'd126};
12'd804:{rom_a,rom_theta}<={9'd20,9'd126};
12'd805:{rom_a,rom_theta}<={9'd20,9'd127};
12'd806:{rom_a,rom_theta}<={9'd20,9'd127};
12'd807:{rom_a,rom_theta}<={9'd20,9'd127};
12'd808:{rom_a,rom_theta}<={9'd20,9'd127};
12'd809:{rom_a,rom_theta}<={9'd20,9'd127};
12'd810:{rom_a,rom_theta}<={9'd20,9'd127};
12'd811:{rom_a,rom_theta}<={9'd20,9'd127};
12'd812:{rom_a,rom_theta}<={9'd20,9'd128};
12'd813:{rom_a,rom_theta}<={9'd20,9'd128};
12'd814:{rom_a,rom_theta}<={9'd20,9'd128};
12'd815:{rom_a,rom_theta}<={9'd20,9'd128};
12'd816:{rom_a,rom_theta}<={9'd20,9'd128};
12'd817:{rom_a,rom_theta}<={9'd20,9'd128};
12'd818:{rom_a,rom_theta}<={9'd20,9'd128};
12'd819:{rom_a,rom_theta}<={9'd20,9'd129};
12'd820:{rom_a,rom_theta}<={9'd20,9'd129};
12'd821:{rom_a,rom_theta}<={9'd20,9'd129};
12'd822:{rom_a,rom_theta}<={9'd20,9'd129};
12'd823:{rom_a,rom_theta}<={9'd20,9'd129};
12'd824:{rom_a,rom_theta}<={9'd21,9'd129};
12'd825:{rom_a,rom_theta}<={9'd21,9'd130};
12'd826:{rom_a,rom_theta}<={9'd21,9'd130};
12'd827:{rom_a,rom_theta}<={9'd21,9'd130};
12'd828:{rom_a,rom_theta}<={9'd21,9'd130};
12'd829:{rom_a,rom_theta}<={9'd21,9'd130};
12'd830:{rom_a,rom_theta}<={9'd21,9'd130};
12'd831:{rom_a,rom_theta}<={9'd21,9'd130};
12'd832:{rom_a,rom_theta}<={9'd21,9'd131};
12'd833:{rom_a,rom_theta}<={9'd21,9'd131};
12'd834:{rom_a,rom_theta}<={9'd21,9'd131};
12'd835:{rom_a,rom_theta}<={9'd21,9'd131};
12'd836:{rom_a,rom_theta}<={9'd21,9'd131};
12'd837:{rom_a,rom_theta}<={9'd21,9'd131};
12'd838:{rom_a,rom_theta}<={9'd21,9'd132};
12'd839:{rom_a,rom_theta}<={9'd21,9'd132};
12'd840:{rom_a,rom_theta}<={9'd21,9'd132};
12'd841:{rom_a,rom_theta}<={9'd21,9'd132};
12'd842:{rom_a,rom_theta}<={9'd21,9'd132};
12'd843:{rom_a,rom_theta}<={9'd21,9'd132};
12'd844:{rom_a,rom_theta}<={9'd22,9'd132};
12'd845:{rom_a,rom_theta}<={9'd22,9'd133};
12'd846:{rom_a,rom_theta}<={9'd22,9'd133};
12'd847:{rom_a,rom_theta}<={9'd22,9'd133};
12'd848:{rom_a,rom_theta}<={9'd22,9'd133};
12'd849:{rom_a,rom_theta}<={9'd22,9'd133};
12'd850:{rom_a,rom_theta}<={9'd22,9'd133};
12'd851:{rom_a,rom_theta}<={9'd22,9'd134};
12'd852:{rom_a,rom_theta}<={9'd22,9'd134};
12'd853:{rom_a,rom_theta}<={9'd22,9'd134};
12'd854:{rom_a,rom_theta}<={9'd22,9'd134};
12'd855:{rom_a,rom_theta}<={9'd22,9'd134};
12'd856:{rom_a,rom_theta}<={9'd22,9'd134};
12'd857:{rom_a,rom_theta}<={9'd22,9'd134};
12'd858:{rom_a,rom_theta}<={9'd22,9'd135};
12'd859:{rom_a,rom_theta}<={9'd22,9'd135};
12'd860:{rom_a,rom_theta}<={9'd22,9'd135};
12'd861:{rom_a,rom_theta}<={9'd22,9'd135};
12'd862:{rom_a,rom_theta}<={9'd22,9'd135};
12'd863:{rom_a,rom_theta}<={9'd22,9'd135};
12'd864:{rom_a,rom_theta}<={9'd23,9'd136};
12'd865:{rom_a,rom_theta}<={9'd23,9'd136};
12'd866:{rom_a,rom_theta}<={9'd23,9'd136};
12'd867:{rom_a,rom_theta}<={9'd23,9'd136};
12'd868:{rom_a,rom_theta}<={9'd23,9'd136};
12'd869:{rom_a,rom_theta}<={9'd23,9'd136};
12'd870:{rom_a,rom_theta}<={9'd23,9'd136};
12'd871:{rom_a,rom_theta}<={9'd23,9'd137};
12'd872:{rom_a,rom_theta}<={9'd23,9'd137};
12'd873:{rom_a,rom_theta}<={9'd23,9'd137};
12'd874:{rom_a,rom_theta}<={9'd23,9'd137};
12'd875:{rom_a,rom_theta}<={9'd23,9'd137};
12'd876:{rom_a,rom_theta}<={9'd23,9'd137};
12'd877:{rom_a,rom_theta}<={9'd23,9'd138};
12'd878:{rom_a,rom_theta}<={9'd23,9'd138};
12'd879:{rom_a,rom_theta}<={9'd23,9'd138};
12'd880:{rom_a,rom_theta}<={9'd23,9'd138};
12'd881:{rom_a,rom_theta}<={9'd23,9'd138};
12'd882:{rom_a,rom_theta}<={9'd23,9'd138};
12'd883:{rom_a,rom_theta}<={9'd24,9'd138};
12'd884:{rom_a,rom_theta}<={9'd24,9'd139};
12'd885:{rom_a,rom_theta}<={9'd24,9'd139};
12'd886:{rom_a,rom_theta}<={9'd24,9'd139};
12'd887:{rom_a,rom_theta}<={9'd24,9'd139};
12'd888:{rom_a,rom_theta}<={9'd24,9'd139};
12'd889:{rom_a,rom_theta}<={9'd24,9'd139};
12'd890:{rom_a,rom_theta}<={9'd24,9'd139};
12'd891:{rom_a,rom_theta}<={9'd24,9'd140};
12'd892:{rom_a,rom_theta}<={9'd24,9'd140};
12'd893:{rom_a,rom_theta}<={9'd24,9'd140};
12'd894:{rom_a,rom_theta}<={9'd24,9'd140};
12'd895:{rom_a,rom_theta}<={9'd24,9'd140};
12'd896:{rom_a,rom_theta}<={9'd24,9'd140};
12'd897:{rom_a,rom_theta}<={9'd24,9'd141};
12'd898:{rom_a,rom_theta}<={9'd24,9'd141};
12'd899:{rom_a,rom_theta}<={9'd24,9'd141};
12'd900:{rom_a,rom_theta}<={9'd24,9'd141};
12'd901:{rom_a,rom_theta}<={9'd24,9'd141};
12'd902:{rom_a,rom_theta}<={9'd25,9'd141};
12'd903:{rom_a,rom_theta}<={9'd25,9'd141};
12'd904:{rom_a,rom_theta}<={9'd25,9'd142};
12'd905:{rom_a,rom_theta}<={9'd25,9'd142};
12'd906:{rom_a,rom_theta}<={9'd25,9'd142};
12'd907:{rom_a,rom_theta}<={9'd25,9'd142};
12'd908:{rom_a,rom_theta}<={9'd25,9'd142};
12'd909:{rom_a,rom_theta}<={9'd25,9'd142};
12'd910:{rom_a,rom_theta}<={9'd25,9'd143};
12'd911:{rom_a,rom_theta}<={9'd25,9'd143};
12'd912:{rom_a,rom_theta}<={9'd25,9'd143};
12'd913:{rom_a,rom_theta}<={9'd25,9'd143};
12'd914:{rom_a,rom_theta}<={9'd25,9'd143};
12'd915:{rom_a,rom_theta}<={9'd25,9'd143};
12'd916:{rom_a,rom_theta}<={9'd25,9'd143};
12'd917:{rom_a,rom_theta}<={9'd25,9'd144};
12'd918:{rom_a,rom_theta}<={9'd25,9'd144};
12'd919:{rom_a,rom_theta}<={9'd25,9'd144};
12'd920:{rom_a,rom_theta}<={9'd26,9'd144};
12'd921:{rom_a,rom_theta}<={9'd26,9'd144};
12'd922:{rom_a,rom_theta}<={9'd26,9'd144};
12'd923:{rom_a,rom_theta}<={9'd26,9'd144};
12'd924:{rom_a,rom_theta}<={9'd26,9'd145};
12'd925:{rom_a,rom_theta}<={9'd26,9'd145};
12'd926:{rom_a,rom_theta}<={9'd26,9'd145};
12'd927:{rom_a,rom_theta}<={9'd26,9'd145};
12'd928:{rom_a,rom_theta}<={9'd26,9'd145};
12'd929:{rom_a,rom_theta}<={9'd26,9'd145};
12'd930:{rom_a,rom_theta}<={9'd26,9'd146};
12'd931:{rom_a,rom_theta}<={9'd26,9'd146};
12'd932:{rom_a,rom_theta}<={9'd26,9'd146};
12'd933:{rom_a,rom_theta}<={9'd26,9'd146};
12'd934:{rom_a,rom_theta}<={9'd26,9'd146};
12'd935:{rom_a,rom_theta}<={9'd26,9'd146};
12'd936:{rom_a,rom_theta}<={9'd26,9'd146};
12'd937:{rom_a,rom_theta}<={9'd26,9'd147};
12'd938:{rom_a,rom_theta}<={9'd27,9'd147};
12'd939:{rom_a,rom_theta}<={9'd27,9'd147};
12'd940:{rom_a,rom_theta}<={9'd27,9'd147};
12'd941:{rom_a,rom_theta}<={9'd27,9'd147};
12'd942:{rom_a,rom_theta}<={9'd27,9'd147};
12'd943:{rom_a,rom_theta}<={9'd27,9'd148};
12'd944:{rom_a,rom_theta}<={9'd27,9'd148};
12'd945:{rom_a,rom_theta}<={9'd27,9'd148};
12'd946:{rom_a,rom_theta}<={9'd27,9'd148};
12'd947:{rom_a,rom_theta}<={9'd27,9'd148};
12'd948:{rom_a,rom_theta}<={9'd27,9'd148};
12'd949:{rom_a,rom_theta}<={9'd27,9'd148};
12'd950:{rom_a,rom_theta}<={9'd27,9'd149};
12'd951:{rom_a,rom_theta}<={9'd27,9'd149};
12'd952:{rom_a,rom_theta}<={9'd27,9'd149};
12'd953:{rom_a,rom_theta}<={9'd27,9'd149};
12'd954:{rom_a,rom_theta}<={9'd27,9'd149};
12'd955:{rom_a,rom_theta}<={9'd27,9'd149};
12'd956:{rom_a,rom_theta}<={9'd28,9'd149};
12'd957:{rom_a,rom_theta}<={9'd28,9'd150};
12'd958:{rom_a,rom_theta}<={9'd28,9'd150};
12'd959:{rom_a,rom_theta}<={9'd28,9'd150};
12'd960:{rom_a,rom_theta}<={9'd28,9'd150};
12'd961:{rom_a,rom_theta}<={9'd28,9'd150};
12'd962:{rom_a,rom_theta}<={9'd28,9'd150};
12'd963:{rom_a,rom_theta}<={9'd28,9'd151};
12'd964:{rom_a,rom_theta}<={9'd28,9'd151};
12'd965:{rom_a,rom_theta}<={9'd28,9'd151};
12'd966:{rom_a,rom_theta}<={9'd28,9'd151};
12'd967:{rom_a,rom_theta}<={9'd28,9'd151};
12'd968:{rom_a,rom_theta}<={9'd28,9'd151};
12'd969:{rom_a,rom_theta}<={9'd28,9'd151};
12'd970:{rom_a,rom_theta}<={9'd28,9'd152};
12'd971:{rom_a,rom_theta}<={9'd28,9'd152};
12'd972:{rom_a,rom_theta}<={9'd28,9'd152};
12'd973:{rom_a,rom_theta}<={9'd28,9'd152};
12'd974:{rom_a,rom_theta}<={9'd29,9'd152};
12'd975:{rom_a,rom_theta}<={9'd29,9'd152};
12'd976:{rom_a,rom_theta}<={9'd29,9'd152};
12'd977:{rom_a,rom_theta}<={9'd29,9'd153};
12'd978:{rom_a,rom_theta}<={9'd29,9'd153};
12'd979:{rom_a,rom_theta}<={9'd29,9'd153};
12'd980:{rom_a,rom_theta}<={9'd29,9'd153};
12'd981:{rom_a,rom_theta}<={9'd29,9'd153};
12'd982:{rom_a,rom_theta}<={9'd29,9'd153};
12'd983:{rom_a,rom_theta}<={9'd29,9'd154};
12'd984:{rom_a,rom_theta}<={9'd29,9'd154};
12'd985:{rom_a,rom_theta}<={9'd29,9'd154};
12'd986:{rom_a,rom_theta}<={9'd29,9'd154};
12'd987:{rom_a,rom_theta}<={9'd29,9'd154};
12'd988:{rom_a,rom_theta}<={9'd29,9'd154};
12'd989:{rom_a,rom_theta}<={9'd29,9'd154};
12'd990:{rom_a,rom_theta}<={9'd29,9'd155};
12'd991:{rom_a,rom_theta}<={9'd30,9'd155};
12'd992:{rom_a,rom_theta}<={9'd30,9'd155};
12'd993:{rom_a,rom_theta}<={9'd30,9'd155};
12'd994:{rom_a,rom_theta}<={9'd30,9'd155};
12'd995:{rom_a,rom_theta}<={9'd30,9'd155};
12'd996:{rom_a,rom_theta}<={9'd30,9'd156};
12'd997:{rom_a,rom_theta}<={9'd30,9'd156};
12'd998:{rom_a,rom_theta}<={9'd30,9'd156};
12'd999:{rom_a,rom_theta}<={9'd30,9'd156};
12'd1000:{rom_a,rom_theta}<={9'd30,9'd156};
12'd1001:{rom_a,rom_theta}<={9'd30,9'd156};
12'd1002:{rom_a,rom_theta}<={9'd30,9'd156};
12'd1003:{rom_a,rom_theta}<={9'd30,9'd157};
12'd1004:{rom_a,rom_theta}<={9'd30,9'd157};
12'd1005:{rom_a,rom_theta}<={9'd30,9'd157};
12'd1006:{rom_a,rom_theta}<={9'd30,9'd157};
12'd1007:{rom_a,rom_theta}<={9'd30,9'd157};
12'd1008:{rom_a,rom_theta}<={9'd31,9'd157};
12'd1009:{rom_a,rom_theta}<={9'd31,9'd157};
12'd1010:{rom_a,rom_theta}<={9'd31,9'd158};
12'd1011:{rom_a,rom_theta}<={9'd31,9'd158};
12'd1012:{rom_a,rom_theta}<={9'd31,9'd158};
12'd1013:{rom_a,rom_theta}<={9'd31,9'd158};
12'd1014:{rom_a,rom_theta}<={9'd31,9'd158};
12'd1015:{rom_a,rom_theta}<={9'd31,9'd158};
12'd1016:{rom_a,rom_theta}<={9'd31,9'd159};
12'd1017:{rom_a,rom_theta}<={9'd31,9'd159};
12'd1018:{rom_a,rom_theta}<={9'd31,9'd159};
12'd1019:{rom_a,rom_theta}<={9'd31,9'd159};
12'd1020:{rom_a,rom_theta}<={9'd31,9'd159};
12'd1021:{rom_a,rom_theta}<={9'd31,9'd159};
12'd1022:{rom_a,rom_theta}<={9'd31,9'd159};
12'd1023:{rom_a,rom_theta}<={9'd31,9'd160};
12'd1024:{rom_a,rom_theta}<={9'd32,9'd160};
12'd1025:{rom_a,rom_theta}<={9'd32,9'd160};
12'd1026:{rom_a,rom_theta}<={9'd32,9'd160};
12'd1027:{rom_a,rom_theta}<={9'd32,9'd160};
12'd1028:{rom_a,rom_theta}<={9'd32,9'd160};
12'd1029:{rom_a,rom_theta}<={9'd32,9'd160};
12'd1030:{rom_a,rom_theta}<={9'd32,9'd161};
12'd1031:{rom_a,rom_theta}<={9'd32,9'd161};
12'd1032:{rom_a,rom_theta}<={9'd32,9'd161};
12'd1033:{rom_a,rom_theta}<={9'd32,9'd161};
12'd1034:{rom_a,rom_theta}<={9'd32,9'd161};
12'd1035:{rom_a,rom_theta}<={9'd32,9'd161};
12'd1036:{rom_a,rom_theta}<={9'd32,9'd161};
12'd1037:{rom_a,rom_theta}<={9'd32,9'd162};
12'd1038:{rom_a,rom_theta}<={9'd32,9'd162};
12'd1039:{rom_a,rom_theta}<={9'd32,9'd162};
12'd1040:{rom_a,rom_theta}<={9'd32,9'd162};
12'd1041:{rom_a,rom_theta}<={9'd33,9'd162};
12'd1042:{rom_a,rom_theta}<={9'd33,9'd162};
12'd1043:{rom_a,rom_theta}<={9'd33,9'd163};
12'd1044:{rom_a,rom_theta}<={9'd33,9'd163};
12'd1045:{rom_a,rom_theta}<={9'd33,9'd163};
12'd1046:{rom_a,rom_theta}<={9'd33,9'd163};
12'd1047:{rom_a,rom_theta}<={9'd33,9'd163};
12'd1048:{rom_a,rom_theta}<={9'd33,9'd163};
12'd1049:{rom_a,rom_theta}<={9'd33,9'd163};
12'd1050:{rom_a,rom_theta}<={9'd33,9'd164};
12'd1051:{rom_a,rom_theta}<={9'd33,9'd164};
12'd1052:{rom_a,rom_theta}<={9'd33,9'd164};
12'd1053:{rom_a,rom_theta}<={9'd33,9'd164};
12'd1054:{rom_a,rom_theta}<={9'd33,9'd164};
12'd1055:{rom_a,rom_theta}<={9'd33,9'd164};
12'd1056:{rom_a,rom_theta}<={9'd33,9'd164};
12'd1057:{rom_a,rom_theta}<={9'd34,9'd165};
12'd1058:{rom_a,rom_theta}<={9'd34,9'd165};
12'd1059:{rom_a,rom_theta}<={9'd34,9'd165};
12'd1060:{rom_a,rom_theta}<={9'd34,9'd165};
12'd1061:{rom_a,rom_theta}<={9'd34,9'd165};
12'd1062:{rom_a,rom_theta}<={9'd34,9'd165};
12'd1063:{rom_a,rom_theta}<={9'd34,9'd166};
12'd1064:{rom_a,rom_theta}<={9'd34,9'd166};
12'd1065:{rom_a,rom_theta}<={9'd34,9'd166};
12'd1066:{rom_a,rom_theta}<={9'd34,9'd166};
12'd1067:{rom_a,rom_theta}<={9'd34,9'd166};
12'd1068:{rom_a,rom_theta}<={9'd34,9'd166};
12'd1069:{rom_a,rom_theta}<={9'd34,9'd166};
12'd1070:{rom_a,rom_theta}<={9'd34,9'd167};
12'd1071:{rom_a,rom_theta}<={9'd34,9'd167};
12'd1072:{rom_a,rom_theta}<={9'd34,9'd167};
12'd1073:{rom_a,rom_theta}<={9'd35,9'd167};
12'd1074:{rom_a,rom_theta}<={9'd35,9'd167};
12'd1075:{rom_a,rom_theta}<={9'd35,9'd167};
12'd1076:{rom_a,rom_theta}<={9'd35,9'd167};
12'd1077:{rom_a,rom_theta}<={9'd35,9'd168};
12'd1078:{rom_a,rom_theta}<={9'd35,9'd168};
12'd1079:{rom_a,rom_theta}<={9'd35,9'd168};
12'd1080:{rom_a,rom_theta}<={9'd35,9'd168};
12'd1081:{rom_a,rom_theta}<={9'd35,9'd168};
12'd1082:{rom_a,rom_theta}<={9'd35,9'd168};
12'd1083:{rom_a,rom_theta}<={9'd35,9'd169};
12'd1084:{rom_a,rom_theta}<={9'd35,9'd169};
12'd1085:{rom_a,rom_theta}<={9'd35,9'd169};
12'd1086:{rom_a,rom_theta}<={9'd35,9'd169};
12'd1087:{rom_a,rom_theta}<={9'd35,9'd169};
12'd1088:{rom_a,rom_theta}<={9'd36,9'd169};
12'd1089:{rom_a,rom_theta}<={9'd36,9'd169};
12'd1090:{rom_a,rom_theta}<={9'd36,9'd170};
12'd1091:{rom_a,rom_theta}<={9'd36,9'd170};
12'd1092:{rom_a,rom_theta}<={9'd36,9'd170};
12'd1093:{rom_a,rom_theta}<={9'd36,9'd170};
12'd1094:{rom_a,rom_theta}<={9'd36,9'd170};
12'd1095:{rom_a,rom_theta}<={9'd36,9'd170};
12'd1096:{rom_a,rom_theta}<={9'd36,9'd170};
12'd1097:{rom_a,rom_theta}<={9'd36,9'd171};
12'd1098:{rom_a,rom_theta}<={9'd36,9'd171};
12'd1099:{rom_a,rom_theta}<={9'd36,9'd171};
12'd1100:{rom_a,rom_theta}<={9'd36,9'd171};
12'd1101:{rom_a,rom_theta}<={9'd36,9'd171};
12'd1102:{rom_a,rom_theta}<={9'd36,9'd171};
12'd1103:{rom_a,rom_theta}<={9'd36,9'd171};
12'd1104:{rom_a,rom_theta}<={9'd37,9'd172};
12'd1105:{rom_a,rom_theta}<={9'd37,9'd172};
12'd1106:{rom_a,rom_theta}<={9'd37,9'd172};
12'd1107:{rom_a,rom_theta}<={9'd37,9'd172};
12'd1108:{rom_a,rom_theta}<={9'd37,9'd172};
12'd1109:{rom_a,rom_theta}<={9'd37,9'd172};
12'd1110:{rom_a,rom_theta}<={9'd37,9'd173};
12'd1111:{rom_a,rom_theta}<={9'd37,9'd173};
12'd1112:{rom_a,rom_theta}<={9'd37,9'd173};
12'd1113:{rom_a,rom_theta}<={9'd37,9'd173};
12'd1114:{rom_a,rom_theta}<={9'd37,9'd173};
12'd1115:{rom_a,rom_theta}<={9'd37,9'd173};
12'd1116:{rom_a,rom_theta}<={9'd37,9'd173};
12'd1117:{rom_a,rom_theta}<={9'd37,9'd174};
12'd1118:{rom_a,rom_theta}<={9'd37,9'd174};
12'd1119:{rom_a,rom_theta}<={9'd38,9'd174};
12'd1120:{rom_a,rom_theta}<={9'd38,9'd174};
12'd1121:{rom_a,rom_theta}<={9'd38,9'd174};
12'd1122:{rom_a,rom_theta}<={9'd38,9'd174};
12'd1123:{rom_a,rom_theta}<={9'd38,9'd174};
12'd1124:{rom_a,rom_theta}<={9'd38,9'd175};
12'd1125:{rom_a,rom_theta}<={9'd38,9'd175};
12'd1126:{rom_a,rom_theta}<={9'd38,9'd175};
12'd1127:{rom_a,rom_theta}<={9'd38,9'd175};
12'd1128:{rom_a,rom_theta}<={9'd38,9'd175};
12'd1129:{rom_a,rom_theta}<={9'd38,9'd175};
12'd1130:{rom_a,rom_theta}<={9'd38,9'd175};
12'd1131:{rom_a,rom_theta}<={9'd38,9'd176};
12'd1132:{rom_a,rom_theta}<={9'd38,9'd176};
12'd1133:{rom_a,rom_theta}<={9'd38,9'd176};
12'd1134:{rom_a,rom_theta}<={9'd39,9'd176};
12'd1135:{rom_a,rom_theta}<={9'd39,9'd176};
12'd1136:{rom_a,rom_theta}<={9'd39,9'd176};
12'd1137:{rom_a,rom_theta}<={9'd39,9'd177};
12'd1138:{rom_a,rom_theta}<={9'd39,9'd177};
12'd1139:{rom_a,rom_theta}<={9'd39,9'd177};
12'd1140:{rom_a,rom_theta}<={9'd39,9'd177};
12'd1141:{rom_a,rom_theta}<={9'd39,9'd177};
12'd1142:{rom_a,rom_theta}<={9'd39,9'd177};
12'd1143:{rom_a,rom_theta}<={9'd39,9'd177};
12'd1144:{rom_a,rom_theta}<={9'd39,9'd178};
12'd1145:{rom_a,rom_theta}<={9'd39,9'd178};
12'd1146:{rom_a,rom_theta}<={9'd39,9'd178};
12'd1147:{rom_a,rom_theta}<={9'd39,9'd178};
12'd1148:{rom_a,rom_theta}<={9'd39,9'd178};
12'd1149:{rom_a,rom_theta}<={9'd40,9'd178};
12'd1150:{rom_a,rom_theta}<={9'd40,9'd178};
12'd1151:{rom_a,rom_theta}<={9'd40,9'd179};
12'd1152:{rom_a,rom_theta}<={9'd40,9'd179};
12'd1153:{rom_a,rom_theta}<={9'd40,9'd179};
12'd1154:{rom_a,rom_theta}<={9'd40,9'd179};
12'd1155:{rom_a,rom_theta}<={9'd40,9'd179};
12'd1156:{rom_a,rom_theta}<={9'd40,9'd179};
12'd1157:{rom_a,rom_theta}<={9'd40,9'd179};
12'd1158:{rom_a,rom_theta}<={9'd40,9'd180};
12'd1159:{rom_a,rom_theta}<={9'd40,9'd180};
12'd1160:{rom_a,rom_theta}<={9'd40,9'd180};
12'd1161:{rom_a,rom_theta}<={9'd40,9'd180};
12'd1162:{rom_a,rom_theta}<={9'd40,9'd180};
12'd1163:{rom_a,rom_theta}<={9'd40,9'd180};
12'd1164:{rom_a,rom_theta}<={9'd41,9'd180};
12'd1165:{rom_a,rom_theta}<={9'd41,9'd181};
12'd1166:{rom_a,rom_theta}<={9'd41,9'd181};
12'd1167:{rom_a,rom_theta}<={9'd41,9'd181};
12'd1168:{rom_a,rom_theta}<={9'd41,9'd181};
12'd1169:{rom_a,rom_theta}<={9'd41,9'd181};
12'd1170:{rom_a,rom_theta}<={9'd41,9'd181};
12'd1171:{rom_a,rom_theta}<={9'd41,9'd182};
12'd1172:{rom_a,rom_theta}<={9'd41,9'd182};
12'd1173:{rom_a,rom_theta}<={9'd41,9'd182};
12'd1174:{rom_a,rom_theta}<={9'd41,9'd182};
12'd1175:{rom_a,rom_theta}<={9'd41,9'd182};
12'd1176:{rom_a,rom_theta}<={9'd41,9'd182};
12'd1177:{rom_a,rom_theta}<={9'd41,9'd182};
12'd1178:{rom_a,rom_theta}<={9'd42,9'd183};
12'd1179:{rom_a,rom_theta}<={9'd42,9'd183};
12'd1180:{rom_a,rom_theta}<={9'd42,9'd183};
12'd1181:{rom_a,rom_theta}<={9'd42,9'd183};
12'd1182:{rom_a,rom_theta}<={9'd42,9'd183};
12'd1183:{rom_a,rom_theta}<={9'd42,9'd183};
12'd1184:{rom_a,rom_theta}<={9'd42,9'd183};
12'd1185:{rom_a,rom_theta}<={9'd42,9'd184};
12'd1186:{rom_a,rom_theta}<={9'd42,9'd184};
12'd1187:{rom_a,rom_theta}<={9'd42,9'd184};
12'd1188:{rom_a,rom_theta}<={9'd42,9'd184};
12'd1189:{rom_a,rom_theta}<={9'd42,9'd184};
12'd1190:{rom_a,rom_theta}<={9'd42,9'd184};
12'd1191:{rom_a,rom_theta}<={9'd42,9'd184};
12'd1192:{rom_a,rom_theta}<={9'd42,9'd185};
12'd1193:{rom_a,rom_theta}<={9'd43,9'd185};
12'd1194:{rom_a,rom_theta}<={9'd43,9'd185};
12'd1195:{rom_a,rom_theta}<={9'd43,9'd185};
12'd1196:{rom_a,rom_theta}<={9'd43,9'd185};
12'd1197:{rom_a,rom_theta}<={9'd43,9'd185};
12'd1198:{rom_a,rom_theta}<={9'd43,9'd185};
12'd1199:{rom_a,rom_theta}<={9'd43,9'd186};
12'd1200:{rom_a,rom_theta}<={9'd43,9'd186};
12'd1201:{rom_a,rom_theta}<={9'd43,9'd186};
12'd1202:{rom_a,rom_theta}<={9'd43,9'd186};
12'd1203:{rom_a,rom_theta}<={9'd43,9'd186};
12'd1204:{rom_a,rom_theta}<={9'd43,9'd186};
12'd1205:{rom_a,rom_theta}<={9'd43,9'd187};
12'd1206:{rom_a,rom_theta}<={9'd43,9'd187};
12'd1207:{rom_a,rom_theta}<={9'd44,9'd187};
12'd1208:{rom_a,rom_theta}<={9'd44,9'd187};
12'd1209:{rom_a,rom_theta}<={9'd44,9'd187};
12'd1210:{rom_a,rom_theta}<={9'd44,9'd187};
12'd1211:{rom_a,rom_theta}<={9'd44,9'd187};
12'd1212:{rom_a,rom_theta}<={9'd44,9'd188};
12'd1213:{rom_a,rom_theta}<={9'd44,9'd188};
12'd1214:{rom_a,rom_theta}<={9'd44,9'd188};
12'd1215:{rom_a,rom_theta}<={9'd44,9'd188};
12'd1216:{rom_a,rom_theta}<={9'd44,9'd188};
12'd1217:{rom_a,rom_theta}<={9'd44,9'd188};
12'd1218:{rom_a,rom_theta}<={9'd44,9'd188};
12'd1219:{rom_a,rom_theta}<={9'd44,9'd189};
12'd1220:{rom_a,rom_theta}<={9'd44,9'd189};
12'd1221:{rom_a,rom_theta}<={9'd45,9'd189};
12'd1222:{rom_a,rom_theta}<={9'd45,9'd189};
12'd1223:{rom_a,rom_theta}<={9'd45,9'd189};
12'd1224:{rom_a,rom_theta}<={9'd45,9'd189};
12'd1225:{rom_a,rom_theta}<={9'd45,9'd189};
12'd1226:{rom_a,rom_theta}<={9'd45,9'd190};
12'd1227:{rom_a,rom_theta}<={9'd45,9'd190};
12'd1228:{rom_a,rom_theta}<={9'd45,9'd190};
12'd1229:{rom_a,rom_theta}<={9'd45,9'd190};
12'd1230:{rom_a,rom_theta}<={9'd45,9'd190};
12'd1231:{rom_a,rom_theta}<={9'd45,9'd190};
12'd1232:{rom_a,rom_theta}<={9'd45,9'd190};
12'd1233:{rom_a,rom_theta}<={9'd45,9'd191};
12'd1234:{rom_a,rom_theta}<={9'd45,9'd191};
12'd1235:{rom_a,rom_theta}<={9'd46,9'd191};
12'd1236:{rom_a,rom_theta}<={9'd46,9'd191};
12'd1237:{rom_a,rom_theta}<={9'd46,9'd191};
12'd1238:{rom_a,rom_theta}<={9'd46,9'd191};
12'd1239:{rom_a,rom_theta}<={9'd46,9'd191};
12'd1240:{rom_a,rom_theta}<={9'd46,9'd192};
12'd1241:{rom_a,rom_theta}<={9'd46,9'd192};
12'd1242:{rom_a,rom_theta}<={9'd46,9'd192};
12'd1243:{rom_a,rom_theta}<={9'd46,9'd192};
12'd1244:{rom_a,rom_theta}<={9'd46,9'd192};
12'd1245:{rom_a,rom_theta}<={9'd46,9'd192};
12'd1246:{rom_a,rom_theta}<={9'd46,9'd193};
12'd1247:{rom_a,rom_theta}<={9'd46,9'd193};
12'd1248:{rom_a,rom_theta}<={9'd46,9'd193};
12'd1249:{rom_a,rom_theta}<={9'd47,9'd193};
12'd1250:{rom_a,rom_theta}<={9'd47,9'd193};
12'd1251:{rom_a,rom_theta}<={9'd47,9'd193};
12'd1252:{rom_a,rom_theta}<={9'd47,9'd193};
12'd1253:{rom_a,rom_theta}<={9'd47,9'd194};
12'd1254:{rom_a,rom_theta}<={9'd47,9'd194};
12'd1255:{rom_a,rom_theta}<={9'd47,9'd194};
12'd1256:{rom_a,rom_theta}<={9'd47,9'd194};
12'd1257:{rom_a,rom_theta}<={9'd47,9'd194};
12'd1258:{rom_a,rom_theta}<={9'd47,9'd194};
12'd1259:{rom_a,rom_theta}<={9'd47,9'd194};
12'd1260:{rom_a,rom_theta}<={9'd47,9'd195};
12'd1261:{rom_a,rom_theta}<={9'd47,9'd195};
12'd1262:{rom_a,rom_theta}<={9'd48,9'd195};
12'd1263:{rom_a,rom_theta}<={9'd48,9'd195};
12'd1264:{rom_a,rom_theta}<={9'd48,9'd195};
12'd1265:{rom_a,rom_theta}<={9'd48,9'd195};
12'd1266:{rom_a,rom_theta}<={9'd48,9'd195};
12'd1267:{rom_a,rom_theta}<={9'd48,9'd196};
12'd1268:{rom_a,rom_theta}<={9'd48,9'd196};
12'd1269:{rom_a,rom_theta}<={9'd48,9'd196};
12'd1270:{rom_a,rom_theta}<={9'd48,9'd196};
12'd1271:{rom_a,rom_theta}<={9'd48,9'd196};
12'd1272:{rom_a,rom_theta}<={9'd48,9'd196};
12'd1273:{rom_a,rom_theta}<={9'd48,9'd196};
12'd1274:{rom_a,rom_theta}<={9'd48,9'd197};
12'd1275:{rom_a,rom_theta}<={9'd48,9'd197};
12'd1276:{rom_a,rom_theta}<={9'd49,9'd197};
12'd1277:{rom_a,rom_theta}<={9'd49,9'd197};
12'd1278:{rom_a,rom_theta}<={9'd49,9'd197};
12'd1279:{rom_a,rom_theta}<={9'd49,9'd197};
12'd1280:{rom_a,rom_theta}<={9'd49,9'd197};
12'd1281:{rom_a,rom_theta}<={9'd49,9'd198};
12'd1282:{rom_a,rom_theta}<={9'd49,9'd198};
12'd1283:{rom_a,rom_theta}<={9'd49,9'd198};
12'd1284:{rom_a,rom_theta}<={9'd49,9'd198};
12'd1285:{rom_a,rom_theta}<={9'd49,9'd198};
12'd1286:{rom_a,rom_theta}<={9'd49,9'd198};
12'd1287:{rom_a,rom_theta}<={9'd49,9'd198};
12'd1288:{rom_a,rom_theta}<={9'd49,9'd199};
12'd1289:{rom_a,rom_theta}<={9'd50,9'd199};
12'd1290:{rom_a,rom_theta}<={9'd50,9'd199};
12'd1291:{rom_a,rom_theta}<={9'd50,9'd199};
12'd1292:{rom_a,rom_theta}<={9'd50,9'd199};
12'd1293:{rom_a,rom_theta}<={9'd50,9'd199};
12'd1294:{rom_a,rom_theta}<={9'd50,9'd199};
12'd1295:{rom_a,rom_theta}<={9'd50,9'd200};
12'd1296:{rom_a,rom_theta}<={9'd50,9'd200};
12'd1297:{rom_a,rom_theta}<={9'd50,9'd200};
12'd1298:{rom_a,rom_theta}<={9'd50,9'd200};
12'd1299:{rom_a,rom_theta}<={9'd50,9'd200};
12'd1300:{rom_a,rom_theta}<={9'd50,9'd200};
12'd1301:{rom_a,rom_theta}<={9'd50,9'd200};
12'd1302:{rom_a,rom_theta}<={9'd50,9'd201};
12'd1303:{rom_a,rom_theta}<={9'd51,9'd201};
12'd1304:{rom_a,rom_theta}<={9'd51,9'd201};
12'd1305:{rom_a,rom_theta}<={9'd51,9'd201};
12'd1306:{rom_a,rom_theta}<={9'd51,9'd201};
12'd1307:{rom_a,rom_theta}<={9'd51,9'd201};
12'd1308:{rom_a,rom_theta}<={9'd51,9'd202};
12'd1309:{rom_a,rom_theta}<={9'd51,9'd202};
12'd1310:{rom_a,rom_theta}<={9'd51,9'd202};
12'd1311:{rom_a,rom_theta}<={9'd51,9'd202};
12'd1312:{rom_a,rom_theta}<={9'd51,9'd202};
12'd1313:{rom_a,rom_theta}<={9'd51,9'd202};
12'd1314:{rom_a,rom_theta}<={9'd51,9'd202};
12'd1315:{rom_a,rom_theta}<={9'd51,9'd203};
12'd1316:{rom_a,rom_theta}<={9'd52,9'd203};
12'd1317:{rom_a,rom_theta}<={9'd52,9'd203};
12'd1318:{rom_a,rom_theta}<={9'd52,9'd203};
12'd1319:{rom_a,rom_theta}<={9'd52,9'd203};
12'd1320:{rom_a,rom_theta}<={9'd52,9'd203};
12'd1321:{rom_a,rom_theta}<={9'd52,9'd203};
12'd1322:{rom_a,rom_theta}<={9'd52,9'd204};
12'd1323:{rom_a,rom_theta}<={9'd52,9'd204};
12'd1324:{rom_a,rom_theta}<={9'd52,9'd204};
12'd1325:{rom_a,rom_theta}<={9'd52,9'd204};
12'd1326:{rom_a,rom_theta}<={9'd52,9'd204};
12'd1327:{rom_a,rom_theta}<={9'd52,9'd204};
12'd1328:{rom_a,rom_theta}<={9'd52,9'd204};
12'd1329:{rom_a,rom_theta}<={9'd53,9'd205};
12'd1330:{rom_a,rom_theta}<={9'd53,9'd205};
12'd1331:{rom_a,rom_theta}<={9'd53,9'd205};
12'd1332:{rom_a,rom_theta}<={9'd53,9'd205};
12'd1333:{rom_a,rom_theta}<={9'd53,9'd205};
12'd1334:{rom_a,rom_theta}<={9'd53,9'd205};
12'd1335:{rom_a,rom_theta}<={9'd53,9'd205};
12'd1336:{rom_a,rom_theta}<={9'd53,9'd206};
12'd1337:{rom_a,rom_theta}<={9'd53,9'd206};
12'd1338:{rom_a,rom_theta}<={9'd53,9'd206};
12'd1339:{rom_a,rom_theta}<={9'd53,9'd206};
12'd1340:{rom_a,rom_theta}<={9'd53,9'd206};
12'd1341:{rom_a,rom_theta}<={9'd53,9'd206};
12'd1342:{rom_a,rom_theta}<={9'd54,9'd206};
12'd1343:{rom_a,rom_theta}<={9'd54,9'd207};
12'd1344:{rom_a,rom_theta}<={9'd54,9'd207};
12'd1345:{rom_a,rom_theta}<={9'd54,9'd207};
12'd1346:{rom_a,rom_theta}<={9'd54,9'd207};
12'd1347:{rom_a,rom_theta}<={9'd54,9'd207};
12'd1348:{rom_a,rom_theta}<={9'd54,9'd207};
12'd1349:{rom_a,rom_theta}<={9'd54,9'd207};
12'd1350:{rom_a,rom_theta}<={9'd54,9'd208};
12'd1351:{rom_a,rom_theta}<={9'd54,9'd208};
12'd1352:{rom_a,rom_theta}<={9'd54,9'd208};
12'd1353:{rom_a,rom_theta}<={9'd54,9'd208};
12'd1354:{rom_a,rom_theta}<={9'd54,9'd208};
12'd1355:{rom_a,rom_theta}<={9'd55,9'd208};
12'd1356:{rom_a,rom_theta}<={9'd55,9'd208};
12'd1357:{rom_a,rom_theta}<={9'd55,9'd209};
12'd1358:{rom_a,rom_theta}<={9'd55,9'd209};
12'd1359:{rom_a,rom_theta}<={9'd55,9'd209};
12'd1360:{rom_a,rom_theta}<={9'd55,9'd209};
12'd1361:{rom_a,rom_theta}<={9'd55,9'd209};
12'd1362:{rom_a,rom_theta}<={9'd55,9'd209};
12'd1363:{rom_a,rom_theta}<={9'd55,9'd209};
12'd1364:{rom_a,rom_theta}<={9'd55,9'd210};
12'd1365:{rom_a,rom_theta}<={9'd55,9'd210};
12'd1366:{rom_a,rom_theta}<={9'd55,9'd210};
12'd1367:{rom_a,rom_theta}<={9'd56,9'd210};
12'd1368:{rom_a,rom_theta}<={9'd56,9'd210};
12'd1369:{rom_a,rom_theta}<={9'd56,9'd210};
12'd1370:{rom_a,rom_theta}<={9'd56,9'd210};
12'd1371:{rom_a,rom_theta}<={9'd56,9'd211};
12'd1372:{rom_a,rom_theta}<={9'd56,9'd211};
12'd1373:{rom_a,rom_theta}<={9'd56,9'd211};
12'd1374:{rom_a,rom_theta}<={9'd56,9'd211};
12'd1375:{rom_a,rom_theta}<={9'd56,9'd211};
12'd1376:{rom_a,rom_theta}<={9'd56,9'd211};
12'd1377:{rom_a,rom_theta}<={9'd56,9'd211};
12'd1378:{rom_a,rom_theta}<={9'd56,9'd212};
12'd1379:{rom_a,rom_theta}<={9'd56,9'd212};
12'd1380:{rom_a,rom_theta}<={9'd57,9'd212};
12'd1381:{rom_a,rom_theta}<={9'd57,9'd212};
12'd1382:{rom_a,rom_theta}<={9'd57,9'd212};
12'd1383:{rom_a,rom_theta}<={9'd57,9'd212};
12'd1384:{rom_a,rom_theta}<={9'd57,9'd212};
12'd1385:{rom_a,rom_theta}<={9'd57,9'd213};
12'd1386:{rom_a,rom_theta}<={9'd57,9'd213};
12'd1387:{rom_a,rom_theta}<={9'd57,9'd213};
12'd1388:{rom_a,rom_theta}<={9'd57,9'd213};
12'd1389:{rom_a,rom_theta}<={9'd57,9'd213};
12'd1390:{rom_a,rom_theta}<={9'd57,9'd213};
12'd1391:{rom_a,rom_theta}<={9'd57,9'd213};
12'd1392:{rom_a,rom_theta}<={9'd58,9'd214};
12'd1393:{rom_a,rom_theta}<={9'd58,9'd214};
12'd1394:{rom_a,rom_theta}<={9'd58,9'd214};
12'd1395:{rom_a,rom_theta}<={9'd58,9'd214};
12'd1396:{rom_a,rom_theta}<={9'd58,9'd214};
12'd1397:{rom_a,rom_theta}<={9'd58,9'd214};
12'd1398:{rom_a,rom_theta}<={9'd58,9'd214};
12'd1399:{rom_a,rom_theta}<={9'd58,9'd215};
12'd1400:{rom_a,rom_theta}<={9'd58,9'd215};
12'd1401:{rom_a,rom_theta}<={9'd58,9'd215};
12'd1402:{rom_a,rom_theta}<={9'd58,9'd215};
12'd1403:{rom_a,rom_theta}<={9'd58,9'd215};
12'd1404:{rom_a,rom_theta}<={9'd58,9'd215};
12'd1405:{rom_a,rom_theta}<={9'd59,9'd215};
12'd1406:{rom_a,rom_theta}<={9'd59,9'd216};
12'd1407:{rom_a,rom_theta}<={9'd59,9'd216};
12'd1408:{rom_a,rom_theta}<={9'd59,9'd216};
12'd1409:{rom_a,rom_theta}<={9'd59,9'd216};
12'd1410:{rom_a,rom_theta}<={9'd59,9'd216};
12'd1411:{rom_a,rom_theta}<={9'd59,9'd216};
12'd1412:{rom_a,rom_theta}<={9'd59,9'd216};
12'd1413:{rom_a,rom_theta}<={9'd59,9'd217};
12'd1414:{rom_a,rom_theta}<={9'd59,9'd217};
12'd1415:{rom_a,rom_theta}<={9'd59,9'd217};
12'd1416:{rom_a,rom_theta}<={9'd59,9'd217};
12'd1417:{rom_a,rom_theta}<={9'd60,9'd217};
12'd1418:{rom_a,rom_theta}<={9'd60,9'd217};
12'd1419:{rom_a,rom_theta}<={9'd60,9'd217};
12'd1420:{rom_a,rom_theta}<={9'd60,9'd218};
12'd1421:{rom_a,rom_theta}<={9'd60,9'd218};
12'd1422:{rom_a,rom_theta}<={9'd60,9'd218};
12'd1423:{rom_a,rom_theta}<={9'd60,9'd218};
12'd1424:{rom_a,rom_theta}<={9'd60,9'd218};
12'd1425:{rom_a,rom_theta}<={9'd60,9'd218};
12'd1426:{rom_a,rom_theta}<={9'd60,9'd218};
12'd1427:{rom_a,rom_theta}<={9'd60,9'd219};
12'd1428:{rom_a,rom_theta}<={9'd60,9'd219};
12'd1429:{rom_a,rom_theta}<={9'd61,9'd219};
12'd1430:{rom_a,rom_theta}<={9'd61,9'd219};
12'd1431:{rom_a,rom_theta}<={9'd61,9'd219};
12'd1432:{rom_a,rom_theta}<={9'd61,9'd219};
12'd1433:{rom_a,rom_theta}<={9'd61,9'd219};
12'd1434:{rom_a,rom_theta}<={9'd61,9'd220};
12'd1435:{rom_a,rom_theta}<={9'd61,9'd220};
12'd1436:{rom_a,rom_theta}<={9'd61,9'd220};
12'd1437:{rom_a,rom_theta}<={9'd61,9'd220};
12'd1438:{rom_a,rom_theta}<={9'd61,9'd220};
12'd1439:{rom_a,rom_theta}<={9'd61,9'd220};
12'd1440:{rom_a,rom_theta}<={9'd61,9'd220};
12'd1441:{rom_a,rom_theta}<={9'd62,9'd221};
12'd1442:{rom_a,rom_theta}<={9'd62,9'd221};
12'd1443:{rom_a,rom_theta}<={9'd62,9'd221};
12'd1444:{rom_a,rom_theta}<={9'd62,9'd221};
12'd1445:{rom_a,rom_theta}<={9'd62,9'd221};
12'd1446:{rom_a,rom_theta}<={9'd62,9'd221};
12'd1447:{rom_a,rom_theta}<={9'd62,9'd221};
12'd1448:{rom_a,rom_theta}<={9'd62,9'd222};
12'd1449:{rom_a,rom_theta}<={9'd62,9'd222};
12'd1450:{rom_a,rom_theta}<={9'd62,9'd222};
12'd1451:{rom_a,rom_theta}<={9'd62,9'd222};
12'd1452:{rom_a,rom_theta}<={9'd62,9'd222};
12'd1453:{rom_a,rom_theta}<={9'd63,9'd222};
12'd1454:{rom_a,rom_theta}<={9'd63,9'd222};
12'd1455:{rom_a,rom_theta}<={9'd63,9'd223};
12'd1456:{rom_a,rom_theta}<={9'd63,9'd223};
12'd1457:{rom_a,rom_theta}<={9'd63,9'd223};
12'd1458:{rom_a,rom_theta}<={9'd63,9'd223};
12'd1459:{rom_a,rom_theta}<={9'd63,9'd223};
12'd1460:{rom_a,rom_theta}<={9'd63,9'd223};
12'd1461:{rom_a,rom_theta}<={9'd63,9'd223};
12'd1462:{rom_a,rom_theta}<={9'd63,9'd223};
12'd1463:{rom_a,rom_theta}<={9'd63,9'd224};
12'd1464:{rom_a,rom_theta}<={9'd63,9'd224};
12'd1465:{rom_a,rom_theta}<={9'd64,9'd224};
12'd1466:{rom_a,rom_theta}<={9'd64,9'd224};
12'd1467:{rom_a,rom_theta}<={9'd64,9'd224};
12'd1468:{rom_a,rom_theta}<={9'd64,9'd224};
12'd1469:{rom_a,rom_theta}<={9'd64,9'd224};
12'd1470:{rom_a,rom_theta}<={9'd64,9'd225};
12'd1471:{rom_a,rom_theta}<={9'd64,9'd225};
12'd1472:{rom_a,rom_theta}<={9'd64,9'd225};
12'd1473:{rom_a,rom_theta}<={9'd64,9'd225};
12'd1474:{rom_a,rom_theta}<={9'd64,9'd225};
12'd1475:{rom_a,rom_theta}<={9'd64,9'd225};
12'd1476:{rom_a,rom_theta}<={9'd64,9'd225};
12'd1477:{rom_a,rom_theta}<={9'd65,9'd226};
12'd1478:{rom_a,rom_theta}<={9'd65,9'd226};
12'd1479:{rom_a,rom_theta}<={9'd65,9'd226};
12'd1480:{rom_a,rom_theta}<={9'd65,9'd226};
12'd1481:{rom_a,rom_theta}<={9'd65,9'd226};
12'd1482:{rom_a,rom_theta}<={9'd65,9'd226};
12'd1483:{rom_a,rom_theta}<={9'd65,9'd226};
12'd1484:{rom_a,rom_theta}<={9'd65,9'd227};
12'd1485:{rom_a,rom_theta}<={9'd65,9'd227};
12'd1486:{rom_a,rom_theta}<={9'd65,9'd227};
12'd1487:{rom_a,rom_theta}<={9'd65,9'd227};
12'd1488:{rom_a,rom_theta}<={9'd65,9'd227};
12'd1489:{rom_a,rom_theta}<={9'd66,9'd227};
12'd1490:{rom_a,rom_theta}<={9'd66,9'd227};
12'd1491:{rom_a,rom_theta}<={9'd66,9'd228};
12'd1492:{rom_a,rom_theta}<={9'd66,9'd228};
12'd1493:{rom_a,rom_theta}<={9'd66,9'd228};
12'd1494:{rom_a,rom_theta}<={9'd66,9'd228};
12'd1495:{rom_a,rom_theta}<={9'd66,9'd228};
12'd1496:{rom_a,rom_theta}<={9'd66,9'd228};
12'd1497:{rom_a,rom_theta}<={9'd66,9'd228};
12'd1498:{rom_a,rom_theta}<={9'd66,9'd229};
12'd1499:{rom_a,rom_theta}<={9'd66,9'd229};
12'd1500:{rom_a,rom_theta}<={9'd67,9'd229};
12'd1501:{rom_a,rom_theta}<={9'd67,9'd229};
12'd1502:{rom_a,rom_theta}<={9'd67,9'd229};
12'd1503:{rom_a,rom_theta}<={9'd67,9'd229};
12'd1504:{rom_a,rom_theta}<={9'd67,9'd229};
12'd1505:{rom_a,rom_theta}<={9'd67,9'd230};
12'd1506:{rom_a,rom_theta}<={9'd67,9'd230};
12'd1507:{rom_a,rom_theta}<={9'd67,9'd230};
12'd1508:{rom_a,rom_theta}<={9'd67,9'd230};
12'd1509:{rom_a,rom_theta}<={9'd67,9'd230};
12'd1510:{rom_a,rom_theta}<={9'd67,9'd230};
12'd1511:{rom_a,rom_theta}<={9'd67,9'd230};
12'd1512:{rom_a,rom_theta}<={9'd68,9'd231};
12'd1513:{rom_a,rom_theta}<={9'd68,9'd231};
12'd1514:{rom_a,rom_theta}<={9'd68,9'd231};
12'd1515:{rom_a,rom_theta}<={9'd68,9'd231};
12'd1516:{rom_a,rom_theta}<={9'd68,9'd231};
12'd1517:{rom_a,rom_theta}<={9'd68,9'd231};
12'd1518:{rom_a,rom_theta}<={9'd68,9'd231};
12'd1519:{rom_a,rom_theta}<={9'd68,9'd232};
12'd1520:{rom_a,rom_theta}<={9'd68,9'd232};
12'd1521:{rom_a,rom_theta}<={9'd68,9'd232};
12'd1522:{rom_a,rom_theta}<={9'd68,9'd232};
12'd1523:{rom_a,rom_theta}<={9'd68,9'd232};
12'd1524:{rom_a,rom_theta}<={9'd69,9'd232};
12'd1525:{rom_a,rom_theta}<={9'd69,9'd232};
12'd1526:{rom_a,rom_theta}<={9'd69,9'd232};
12'd1527:{rom_a,rom_theta}<={9'd69,9'd233};
12'd1528:{rom_a,rom_theta}<={9'd69,9'd233};
12'd1529:{rom_a,rom_theta}<={9'd69,9'd233};
12'd1530:{rom_a,rom_theta}<={9'd69,9'd233};
12'd1531:{rom_a,rom_theta}<={9'd69,9'd233};
12'd1532:{rom_a,rom_theta}<={9'd69,9'd233};
12'd1533:{rom_a,rom_theta}<={9'd69,9'd233};
12'd1534:{rom_a,rom_theta}<={9'd69,9'd234};
12'd1535:{rom_a,rom_theta}<={9'd70,9'd234};
12'd1536:{rom_a,rom_theta}<={9'd70,9'd234};
12'd1537:{rom_a,rom_theta}<={9'd70,9'd234};
12'd1538:{rom_a,rom_theta}<={9'd70,9'd234};
12'd1539:{rom_a,rom_theta}<={9'd70,9'd234};
12'd1540:{rom_a,rom_theta}<={9'd70,9'd234};
12'd1541:{rom_a,rom_theta}<={9'd70,9'd235};
12'd1542:{rom_a,rom_theta}<={9'd70,9'd235};
12'd1543:{rom_a,rom_theta}<={9'd70,9'd235};
12'd1544:{rom_a,rom_theta}<={9'd70,9'd235};
12'd1545:{rom_a,rom_theta}<={9'd70,9'd235};
12'd1546:{rom_a,rom_theta}<={9'd71,9'd235};
12'd1547:{rom_a,rom_theta}<={9'd71,9'd235};
12'd1548:{rom_a,rom_theta}<={9'd71,9'd236};
12'd1549:{rom_a,rom_theta}<={9'd71,9'd236};
12'd1550:{rom_a,rom_theta}<={9'd71,9'd236};
12'd1551:{rom_a,rom_theta}<={9'd71,9'd236};
12'd1552:{rom_a,rom_theta}<={9'd71,9'd236};
12'd1553:{rom_a,rom_theta}<={9'd71,9'd236};
12'd1554:{rom_a,rom_theta}<={9'd71,9'd236};
12'd1555:{rom_a,rom_theta}<={9'd71,9'd237};
12'd1556:{rom_a,rom_theta}<={9'd71,9'd237};
12'd1557:{rom_a,rom_theta}<={9'd71,9'd237};
12'd1558:{rom_a,rom_theta}<={9'd72,9'd237};
12'd1559:{rom_a,rom_theta}<={9'd72,9'd237};
12'd1560:{rom_a,rom_theta}<={9'd72,9'd237};
12'd1561:{rom_a,rom_theta}<={9'd72,9'd237};
12'd1562:{rom_a,rom_theta}<={9'd72,9'd238};
12'd1563:{rom_a,rom_theta}<={9'd72,9'd238};
12'd1564:{rom_a,rom_theta}<={9'd72,9'd238};
12'd1565:{rom_a,rom_theta}<={9'd72,9'd238};
12'd1566:{rom_a,rom_theta}<={9'd72,9'd238};
12'd1567:{rom_a,rom_theta}<={9'd72,9'd238};
12'd1568:{rom_a,rom_theta}<={9'd72,9'd238};
12'd1569:{rom_a,rom_theta}<={9'd73,9'd238};
12'd1570:{rom_a,rom_theta}<={9'd73,9'd239};
12'd1571:{rom_a,rom_theta}<={9'd73,9'd239};
12'd1572:{rom_a,rom_theta}<={9'd73,9'd239};
12'd1573:{rom_a,rom_theta}<={9'd73,9'd239};
12'd1574:{rom_a,rom_theta}<={9'd73,9'd239};
12'd1575:{rom_a,rom_theta}<={9'd73,9'd239};
12'd1576:{rom_a,rom_theta}<={9'd73,9'd239};
12'd1577:{rom_a,rom_theta}<={9'd73,9'd240};
12'd1578:{rom_a,rom_theta}<={9'd73,9'd240};
12'd1579:{rom_a,rom_theta}<={9'd73,9'd240};
12'd1580:{rom_a,rom_theta}<={9'd74,9'd240};
12'd1581:{rom_a,rom_theta}<={9'd74,9'd240};
12'd1582:{rom_a,rom_theta}<={9'd74,9'd240};
12'd1583:{rom_a,rom_theta}<={9'd74,9'd240};
12'd1584:{rom_a,rom_theta}<={9'd74,9'd241};
12'd1585:{rom_a,rom_theta}<={9'd74,9'd241};
12'd1586:{rom_a,rom_theta}<={9'd74,9'd241};
12'd1587:{rom_a,rom_theta}<={9'd74,9'd241};
12'd1588:{rom_a,rom_theta}<={9'd74,9'd241};
12'd1589:{rom_a,rom_theta}<={9'd74,9'd241};
12'd1590:{rom_a,rom_theta}<={9'd74,9'd241};
12'd1591:{rom_a,rom_theta}<={9'd75,9'd242};
12'd1592:{rom_a,rom_theta}<={9'd75,9'd242};
12'd1593:{rom_a,rom_theta}<={9'd75,9'd242};
12'd1594:{rom_a,rom_theta}<={9'd75,9'd242};
12'd1595:{rom_a,rom_theta}<={9'd75,9'd242};
12'd1596:{rom_a,rom_theta}<={9'd75,9'd242};
12'd1597:{rom_a,rom_theta}<={9'd75,9'd242};
12'd1598:{rom_a,rom_theta}<={9'd75,9'd242};
12'd1599:{rom_a,rom_theta}<={9'd75,9'd243};
12'd1600:{rom_a,rom_theta}<={9'd75,9'd243};
12'd1601:{rom_a,rom_theta}<={9'd75,9'd243};
12'd1602:{rom_a,rom_theta}<={9'd76,9'd243};
12'd1603:{rom_a,rom_theta}<={9'd76,9'd243};
12'd1604:{rom_a,rom_theta}<={9'd76,9'd243};
12'd1605:{rom_a,rom_theta}<={9'd76,9'd243};
12'd1606:{rom_a,rom_theta}<={9'd76,9'd244};
12'd1607:{rom_a,rom_theta}<={9'd76,9'd244};
12'd1608:{rom_a,rom_theta}<={9'd76,9'd244};
12'd1609:{rom_a,rom_theta}<={9'd76,9'd244};
12'd1610:{rom_a,rom_theta}<={9'd76,9'd244};
12'd1611:{rom_a,rom_theta}<={9'd76,9'd244};
12'd1612:{rom_a,rom_theta}<={9'd76,9'd244};
12'd1613:{rom_a,rom_theta}<={9'd77,9'd245};
12'd1614:{rom_a,rom_theta}<={9'd77,9'd245};
12'd1615:{rom_a,rom_theta}<={9'd77,9'd245};
12'd1616:{rom_a,rom_theta}<={9'd77,9'd245};
12'd1617:{rom_a,rom_theta}<={9'd77,9'd245};
12'd1618:{rom_a,rom_theta}<={9'd77,9'd245};
12'd1619:{rom_a,rom_theta}<={9'd77,9'd245};
12'd1620:{rom_a,rom_theta}<={9'd77,9'd246};
12'd1621:{rom_a,rom_theta}<={9'd77,9'd246};
12'd1622:{rom_a,rom_theta}<={9'd77,9'd246};
12'd1623:{rom_a,rom_theta}<={9'd77,9'd246};
12'd1624:{rom_a,rom_theta}<={9'd78,9'd246};
12'd1625:{rom_a,rom_theta}<={9'd78,9'd246};
12'd1626:{rom_a,rom_theta}<={9'd78,9'd246};
12'd1627:{rom_a,rom_theta}<={9'd78,9'd246};
12'd1628:{rom_a,rom_theta}<={9'd78,9'd247};
12'd1629:{rom_a,rom_theta}<={9'd78,9'd247};
12'd1630:{rom_a,rom_theta}<={9'd78,9'd247};
12'd1631:{rom_a,rom_theta}<={9'd78,9'd247};
12'd1632:{rom_a,rom_theta}<={9'd78,9'd247};
12'd1633:{rom_a,rom_theta}<={9'd78,9'd247};
12'd1634:{rom_a,rom_theta}<={9'd78,9'd247};
12'd1635:{rom_a,rom_theta}<={9'd79,9'd248};
12'd1636:{rom_a,rom_theta}<={9'd79,9'd248};
12'd1637:{rom_a,rom_theta}<={9'd79,9'd248};
12'd1638:{rom_a,rom_theta}<={9'd79,9'd248};
12'd1639:{rom_a,rom_theta}<={9'd79,9'd248};
12'd1640:{rom_a,rom_theta}<={9'd79,9'd248};
12'd1641:{rom_a,rom_theta}<={9'd79,9'd248};
12'd1642:{rom_a,rom_theta}<={9'd79,9'd249};
12'd1643:{rom_a,rom_theta}<={9'd79,9'd249};
12'd1644:{rom_a,rom_theta}<={9'd79,9'd249};
12'd1645:{rom_a,rom_theta}<={9'd79,9'd249};
12'd1646:{rom_a,rom_theta}<={9'd80,9'd249};
12'd1647:{rom_a,rom_theta}<={9'd80,9'd249};
12'd1648:{rom_a,rom_theta}<={9'd80,9'd249};
12'd1649:{rom_a,rom_theta}<={9'd80,9'd250};
12'd1650:{rom_a,rom_theta}<={9'd80,9'd250};
12'd1651:{rom_a,rom_theta}<={9'd80,9'd250};
12'd1652:{rom_a,rom_theta}<={9'd80,9'd250};
12'd1653:{rom_a,rom_theta}<={9'd80,9'd250};
12'd1654:{rom_a,rom_theta}<={9'd80,9'd250};
12'd1655:{rom_a,rom_theta}<={9'd80,9'd250};
12'd1656:{rom_a,rom_theta}<={9'd81,9'd250};
12'd1657:{rom_a,rom_theta}<={9'd81,9'd251};
12'd1658:{rom_a,rom_theta}<={9'd81,9'd251};
12'd1659:{rom_a,rom_theta}<={9'd81,9'd251};
12'd1660:{rom_a,rom_theta}<={9'd81,9'd251};
12'd1661:{rom_a,rom_theta}<={9'd81,9'd251};
12'd1662:{rom_a,rom_theta}<={9'd81,9'd251};
12'd1663:{rom_a,rom_theta}<={9'd81,9'd251};
12'd1664:{rom_a,rom_theta}<={9'd81,9'd252};
12'd1665:{rom_a,rom_theta}<={9'd81,9'd252};
12'd1666:{rom_a,rom_theta}<={9'd81,9'd252};
12'd1667:{rom_a,rom_theta}<={9'd82,9'd252};
12'd1668:{rom_a,rom_theta}<={9'd82,9'd252};
12'd1669:{rom_a,rom_theta}<={9'd82,9'd252};
12'd1670:{rom_a,rom_theta}<={9'd82,9'd252};
12'd1671:{rom_a,rom_theta}<={9'd82,9'd253};
12'd1672:{rom_a,rom_theta}<={9'd82,9'd253};
12'd1673:{rom_a,rom_theta}<={9'd82,9'd253};
12'd1674:{rom_a,rom_theta}<={9'd82,9'd253};
12'd1675:{rom_a,rom_theta}<={9'd82,9'd253};
12'd1676:{rom_a,rom_theta}<={9'd82,9'd253};
12'd1677:{rom_a,rom_theta}<={9'd83,9'd253};
12'd1678:{rom_a,rom_theta}<={9'd83,9'd253};
12'd1679:{rom_a,rom_theta}<={9'd83,9'd254};
12'd1680:{rom_a,rom_theta}<={9'd83,9'd254};
12'd1681:{rom_a,rom_theta}<={9'd83,9'd254};
12'd1682:{rom_a,rom_theta}<={9'd83,9'd254};
12'd1683:{rom_a,rom_theta}<={9'd83,9'd254};
12'd1684:{rom_a,rom_theta}<={9'd83,9'd254};
12'd1685:{rom_a,rom_theta}<={9'd83,9'd254};
12'd1686:{rom_a,rom_theta}<={9'd83,9'd255};
12'd1687:{rom_a,rom_theta}<={9'd83,9'd255};
12'd1688:{rom_a,rom_theta}<={9'd84,9'd255};
12'd1689:{rom_a,rom_theta}<={9'd84,9'd255};
12'd1690:{rom_a,rom_theta}<={9'd84,9'd255};
12'd1691:{rom_a,rom_theta}<={9'd84,9'd255};
12'd1692:{rom_a,rom_theta}<={9'd84,9'd255};
12'd1693:{rom_a,rom_theta}<={9'd84,9'd256};
12'd1694:{rom_a,rom_theta}<={9'd84,9'd256};
12'd1695:{rom_a,rom_theta}<={9'd84,9'd256};
12'd1696:{rom_a,rom_theta}<={9'd84,9'd256};
12'd1697:{rom_a,rom_theta}<={9'd84,9'd256};
12'd1698:{rom_a,rom_theta}<={9'd85,9'd256};
12'd1699:{rom_a,rom_theta}<={9'd85,9'd256};
12'd1700:{rom_a,rom_theta}<={9'd85,9'd256};
12'd1701:{rom_a,rom_theta}<={9'd85,9'd257};
12'd1702:{rom_a,rom_theta}<={9'd85,9'd257};
12'd1703:{rom_a,rom_theta}<={9'd85,9'd257};
12'd1704:{rom_a,rom_theta}<={9'd85,9'd257};
12'd1705:{rom_a,rom_theta}<={9'd85,9'd257};
12'd1706:{rom_a,rom_theta}<={9'd85,9'd257};
12'd1707:{rom_a,rom_theta}<={9'd85,9'd257};
12'd1708:{rom_a,rom_theta}<={9'd85,9'd258};
12'd1709:{rom_a,rom_theta}<={9'd86,9'd258};
12'd1710:{rom_a,rom_theta}<={9'd86,9'd258};
12'd1711:{rom_a,rom_theta}<={9'd86,9'd258};
12'd1712:{rom_a,rom_theta}<={9'd86,9'd258};
12'd1713:{rom_a,rom_theta}<={9'd86,9'd258};
12'd1714:{rom_a,rom_theta}<={9'd86,9'd258};
12'd1715:{rom_a,rom_theta}<={9'd86,9'd258};
12'd1716:{rom_a,rom_theta}<={9'd86,9'd259};
12'd1717:{rom_a,rom_theta}<={9'd86,9'd259};
12'd1718:{rom_a,rom_theta}<={9'd86,9'd259};
12'd1719:{rom_a,rom_theta}<={9'd87,9'd259};
12'd1720:{rom_a,rom_theta}<={9'd87,9'd259};
12'd1721:{rom_a,rom_theta}<={9'd87,9'd259};
12'd1722:{rom_a,rom_theta}<={9'd87,9'd259};
12'd1723:{rom_a,rom_theta}<={9'd87,9'd260};
12'd1724:{rom_a,rom_theta}<={9'd87,9'd260};
12'd1725:{rom_a,rom_theta}<={9'd87,9'd260};
12'd1726:{rom_a,rom_theta}<={9'd87,9'd260};
12'd1727:{rom_a,rom_theta}<={9'd87,9'd260};
12'd1728:{rom_a,rom_theta}<={9'd87,9'd260};
12'd1729:{rom_a,rom_theta}<={9'd87,9'd260};
12'd1730:{rom_a,rom_theta}<={9'd88,9'd261};
12'd1731:{rom_a,rom_theta}<={9'd88,9'd261};
12'd1732:{rom_a,rom_theta}<={9'd88,9'd261};
12'd1733:{rom_a,rom_theta}<={9'd88,9'd261};
12'd1734:{rom_a,rom_theta}<={9'd88,9'd261};
12'd1735:{rom_a,rom_theta}<={9'd88,9'd261};
12'd1736:{rom_a,rom_theta}<={9'd88,9'd261};
12'd1737:{rom_a,rom_theta}<={9'd88,9'd261};
12'd1738:{rom_a,rom_theta}<={9'd88,9'd262};
12'd1739:{rom_a,rom_theta}<={9'd88,9'd262};
12'd1740:{rom_a,rom_theta}<={9'd89,9'd262};
12'd1741:{rom_a,rom_theta}<={9'd89,9'd262};
12'd1742:{rom_a,rom_theta}<={9'd89,9'd262};
12'd1743:{rom_a,rom_theta}<={9'd89,9'd262};
12'd1744:{rom_a,rom_theta}<={9'd89,9'd262};
12'd1745:{rom_a,rom_theta}<={9'd89,9'd263};
12'd1746:{rom_a,rom_theta}<={9'd89,9'd263};
12'd1747:{rom_a,rom_theta}<={9'd89,9'd263};
12'd1748:{rom_a,rom_theta}<={9'd89,9'd263};
12'd1749:{rom_a,rom_theta}<={9'd89,9'd263};
12'd1750:{rom_a,rom_theta}<={9'd90,9'd263};
12'd1751:{rom_a,rom_theta}<={9'd90,9'd263};
12'd1752:{rom_a,rom_theta}<={9'd90,9'd263};
12'd1753:{rom_a,rom_theta}<={9'd90,9'd264};
12'd1754:{rom_a,rom_theta}<={9'd90,9'd264};
12'd1755:{rom_a,rom_theta}<={9'd90,9'd264};
12'd1756:{rom_a,rom_theta}<={9'd90,9'd264};
12'd1757:{rom_a,rom_theta}<={9'd90,9'd264};
12'd1758:{rom_a,rom_theta}<={9'd90,9'd264};
12'd1759:{rom_a,rom_theta}<={9'd90,9'd264};
12'd1760:{rom_a,rom_theta}<={9'd91,9'd265};
12'd1761:{rom_a,rom_theta}<={9'd91,9'd265};
12'd1762:{rom_a,rom_theta}<={9'd91,9'd265};
12'd1763:{rom_a,rom_theta}<={9'd91,9'd265};
12'd1764:{rom_a,rom_theta}<={9'd91,9'd265};
12'd1765:{rom_a,rom_theta}<={9'd91,9'd265};
12'd1766:{rom_a,rom_theta}<={9'd91,9'd265};
12'd1767:{rom_a,rom_theta}<={9'd91,9'd266};
12'd1768:{rom_a,rom_theta}<={9'd91,9'd266};
12'd1769:{rom_a,rom_theta}<={9'd91,9'd266};
12'd1770:{rom_a,rom_theta}<={9'd92,9'd266};
12'd1771:{rom_a,rom_theta}<={9'd92,9'd266};
12'd1772:{rom_a,rom_theta}<={9'd92,9'd266};
12'd1773:{rom_a,rom_theta}<={9'd92,9'd266};
12'd1774:{rom_a,rom_theta}<={9'd92,9'd266};
12'd1775:{rom_a,rom_theta}<={9'd92,9'd267};
12'd1776:{rom_a,rom_theta}<={9'd92,9'd267};
12'd1777:{rom_a,rom_theta}<={9'd92,9'd267};
12'd1778:{rom_a,rom_theta}<={9'd92,9'd267};
12'd1779:{rom_a,rom_theta}<={9'd92,9'd267};
12'd1780:{rom_a,rom_theta}<={9'd93,9'd267};
12'd1781:{rom_a,rom_theta}<={9'd93,9'd267};
12'd1782:{rom_a,rom_theta}<={9'd93,9'd268};
12'd1783:{rom_a,rom_theta}<={9'd93,9'd268};
12'd1784:{rom_a,rom_theta}<={9'd93,9'd268};
12'd1785:{rom_a,rom_theta}<={9'd93,9'd268};
12'd1786:{rom_a,rom_theta}<={9'd93,9'd268};
12'd1787:{rom_a,rom_theta}<={9'd93,9'd268};
12'd1788:{rom_a,rom_theta}<={9'd93,9'd268};
12'd1789:{rom_a,rom_theta}<={9'd93,9'd268};
12'd1790:{rom_a,rom_theta}<={9'd94,9'd269};
12'd1791:{rom_a,rom_theta}<={9'd94,9'd269};
12'd1792:{rom_a,rom_theta}<={9'd94,9'd269};
12'd1793:{rom_a,rom_theta}<={9'd94,9'd269};
12'd1794:{rom_a,rom_theta}<={9'd94,9'd269};
12'd1795:{rom_a,rom_theta}<={9'd94,9'd269};
12'd1796:{rom_a,rom_theta}<={9'd94,9'd269};
12'd1797:{rom_a,rom_theta}<={9'd94,9'd270};
12'd1798:{rom_a,rom_theta}<={9'd94,9'd270};
12'd1799:{rom_a,rom_theta}<={9'd94,9'd270};
12'd1800:{rom_a,rom_theta}<={9'd95,9'd270};
12'd1801:{rom_a,rom_theta}<={9'd95,9'd270};
12'd1802:{rom_a,rom_theta}<={9'd95,9'd270};
12'd1803:{rom_a,rom_theta}<={9'd95,9'd270};
12'd1804:{rom_a,rom_theta}<={9'd95,9'd270};
12'd1805:{rom_a,rom_theta}<={9'd95,9'd271};
12'd1806:{rom_a,rom_theta}<={9'd95,9'd271};
12'd1807:{rom_a,rom_theta}<={9'd95,9'd271};
12'd1808:{rom_a,rom_theta}<={9'd95,9'd271};
12'd1809:{rom_a,rom_theta}<={9'd95,9'd271};
12'd1810:{rom_a,rom_theta}<={9'd96,9'd271};
12'd1811:{rom_a,rom_theta}<={9'd96,9'd271};
12'd1812:{rom_a,rom_theta}<={9'd96,9'd272};
12'd1813:{rom_a,rom_theta}<={9'd96,9'd272};
12'd1814:{rom_a,rom_theta}<={9'd96,9'd272};
12'd1815:{rom_a,rom_theta}<={9'd96,9'd272};
12'd1816:{rom_a,rom_theta}<={9'd96,9'd272};
12'd1817:{rom_a,rom_theta}<={9'd96,9'd272};
12'd1818:{rom_a,rom_theta}<={9'd96,9'd272};
12'd1819:{rom_a,rom_theta}<={9'd96,9'd272};
12'd1820:{rom_a,rom_theta}<={9'd97,9'd273};
12'd1821:{rom_a,rom_theta}<={9'd97,9'd273};
12'd1822:{rom_a,rom_theta}<={9'd97,9'd273};
12'd1823:{rom_a,rom_theta}<={9'd97,9'd273};
12'd1824:{rom_a,rom_theta}<={9'd97,9'd273};
12'd1825:{rom_a,rom_theta}<={9'd97,9'd273};
12'd1826:{rom_a,rom_theta}<={9'd97,9'd273};
12'd1827:{rom_a,rom_theta}<={9'd97,9'd274};
12'd1828:{rom_a,rom_theta}<={9'd97,9'd274};
12'd1829:{rom_a,rom_theta}<={9'd97,9'd274};
12'd1830:{rom_a,rom_theta}<={9'd98,9'd274};
12'd1831:{rom_a,rom_theta}<={9'd98,9'd274};
12'd1832:{rom_a,rom_theta}<={9'd98,9'd274};
12'd1833:{rom_a,rom_theta}<={9'd98,9'd274};
12'd1834:{rom_a,rom_theta}<={9'd98,9'd274};
12'd1835:{rom_a,rom_theta}<={9'd98,9'd275};
12'd1836:{rom_a,rom_theta}<={9'd98,9'd275};
12'd1837:{rom_a,rom_theta}<={9'd98,9'd275};
12'd1838:{rom_a,rom_theta}<={9'd98,9'd275};
12'd1839:{rom_a,rom_theta}<={9'd98,9'd275};
12'd1840:{rom_a,rom_theta}<={9'd99,9'd275};
12'd1841:{rom_a,rom_theta}<={9'd99,9'd275};
12'd1842:{rom_a,rom_theta}<={9'd99,9'd275};
12'd1843:{rom_a,rom_theta}<={9'd99,9'd276};
12'd1844:{rom_a,rom_theta}<={9'd99,9'd276};
12'd1845:{rom_a,rom_theta}<={9'd99,9'd276};
12'd1846:{rom_a,rom_theta}<={9'd99,9'd276};
12'd1847:{rom_a,rom_theta}<={9'd99,9'd276};
12'd1848:{rom_a,rom_theta}<={9'd99,9'd276};
12'd1849:{rom_a,rom_theta}<={9'd99,9'd276};
12'd1850:{rom_a,rom_theta}<={9'd100,9'd277};
12'd1851:{rom_a,rom_theta}<={9'd100,9'd277};
12'd1852:{rom_a,rom_theta}<={9'd100,9'd277};
12'd1853:{rom_a,rom_theta}<={9'd100,9'd277};
12'd1854:{rom_a,rom_theta}<={9'd100,9'd277};
12'd1855:{rom_a,rom_theta}<={9'd100,9'd277};
12'd1856:{rom_a,rom_theta}<={9'd100,9'd277};
12'd1857:{rom_a,rom_theta}<={9'd100,9'd277};
12'd1858:{rom_a,rom_theta}<={9'd100,9'd278};
12'd1859:{rom_a,rom_theta}<={9'd101,9'd278};
12'd1860:{rom_a,rom_theta}<={9'd101,9'd278};
12'd1861:{rom_a,rom_theta}<={9'd101,9'd278};
12'd1862:{rom_a,rom_theta}<={9'd101,9'd278};
12'd1863:{rom_a,rom_theta}<={9'd101,9'd278};
12'd1864:{rom_a,rom_theta}<={9'd101,9'd278};
12'd1865:{rom_a,rom_theta}<={9'd101,9'd279};
12'd1866:{rom_a,rom_theta}<={9'd101,9'd279};
12'd1867:{rom_a,rom_theta}<={9'd101,9'd279};
12'd1868:{rom_a,rom_theta}<={9'd101,9'd279};
12'd1869:{rom_a,rom_theta}<={9'd102,9'd279};
12'd1870:{rom_a,rom_theta}<={9'd102,9'd279};
12'd1871:{rom_a,rom_theta}<={9'd102,9'd279};
12'd1872:{rom_a,rom_theta}<={9'd102,9'd279};
12'd1873:{rom_a,rom_theta}<={9'd102,9'd280};
12'd1874:{rom_a,rom_theta}<={9'd102,9'd280};
12'd1875:{rom_a,rom_theta}<={9'd102,9'd280};
12'd1876:{rom_a,rom_theta}<={9'd102,9'd280};
12'd1877:{rom_a,rom_theta}<={9'd102,9'd280};
12'd1878:{rom_a,rom_theta}<={9'd103,9'd280};
12'd1879:{rom_a,rom_theta}<={9'd103,9'd280};
12'd1880:{rom_a,rom_theta}<={9'd103,9'd281};
12'd1881:{rom_a,rom_theta}<={9'd103,9'd281};
12'd1882:{rom_a,rom_theta}<={9'd103,9'd281};
12'd1883:{rom_a,rom_theta}<={9'd103,9'd281};
12'd1884:{rom_a,rom_theta}<={9'd103,9'd281};
12'd1885:{rom_a,rom_theta}<={9'd103,9'd281};
12'd1886:{rom_a,rom_theta}<={9'd103,9'd281};
12'd1887:{rom_a,rom_theta}<={9'd103,9'd281};
12'd1888:{rom_a,rom_theta}<={9'd104,9'd282};
12'd1889:{rom_a,rom_theta}<={9'd104,9'd282};
12'd1890:{rom_a,rom_theta}<={9'd104,9'd282};
12'd1891:{rom_a,rom_theta}<={9'd104,9'd282};
12'd1892:{rom_a,rom_theta}<={9'd104,9'd282};
12'd1893:{rom_a,rom_theta}<={9'd104,9'd282};
12'd1894:{rom_a,rom_theta}<={9'd104,9'd282};
12'd1895:{rom_a,rom_theta}<={9'd104,9'd282};
12'd1896:{rom_a,rom_theta}<={9'd104,9'd283};
12'd1897:{rom_a,rom_theta}<={9'd104,9'd283};
12'd1898:{rom_a,rom_theta}<={9'd105,9'd283};
12'd1899:{rom_a,rom_theta}<={9'd105,9'd283};
12'd1900:{rom_a,rom_theta}<={9'd105,9'd283};
12'd1901:{rom_a,rom_theta}<={9'd105,9'd283};
12'd1902:{rom_a,rom_theta}<={9'd105,9'd283};
12'd1903:{rom_a,rom_theta}<={9'd105,9'd284};
12'd1904:{rom_a,rom_theta}<={9'd105,9'd284};
12'd1905:{rom_a,rom_theta}<={9'd105,9'd284};
12'd1906:{rom_a,rom_theta}<={9'd105,9'd284};
12'd1907:{rom_a,rom_theta}<={9'd106,9'd284};
12'd1908:{rom_a,rom_theta}<={9'd106,9'd284};
12'd1909:{rom_a,rom_theta}<={9'd106,9'd284};
12'd1910:{rom_a,rom_theta}<={9'd106,9'd284};
12'd1911:{rom_a,rom_theta}<={9'd106,9'd285};
12'd1912:{rom_a,rom_theta}<={9'd106,9'd285};
12'd1913:{rom_a,rom_theta}<={9'd106,9'd285};
12'd1914:{rom_a,rom_theta}<={9'd106,9'd285};
12'd1915:{rom_a,rom_theta}<={9'd106,9'd285};
12'd1916:{rom_a,rom_theta}<={9'd106,9'd285};
12'd1917:{rom_a,rom_theta}<={9'd107,9'd285};
12'd1918:{rom_a,rom_theta}<={9'd107,9'd285};
12'd1919:{rom_a,rom_theta}<={9'd107,9'd286};
12'd1920:{rom_a,rom_theta}<={9'd107,9'd286};
12'd1921:{rom_a,rom_theta}<={9'd107,9'd286};
12'd1922:{rom_a,rom_theta}<={9'd107,9'd286};
12'd1923:{rom_a,rom_theta}<={9'd107,9'd286};
12'd1924:{rom_a,rom_theta}<={9'd107,9'd286};
12'd1925:{rom_a,rom_theta}<={9'd107,9'd286};
12'd1926:{rom_a,rom_theta}<={9'd108,9'd287};
12'd1927:{rom_a,rom_theta}<={9'd108,9'd287};
12'd1928:{rom_a,rom_theta}<={9'd108,9'd287};
12'd1929:{rom_a,rom_theta}<={9'd108,9'd287};
12'd1930:{rom_a,rom_theta}<={9'd108,9'd287};
12'd1931:{rom_a,rom_theta}<={9'd108,9'd287};
12'd1932:{rom_a,rom_theta}<={9'd108,9'd287};
12'd1933:{rom_a,rom_theta}<={9'd108,9'd287};
12'd1934:{rom_a,rom_theta}<={9'd108,9'd288};
12'd1935:{rom_a,rom_theta}<={9'd109,9'd288};
12'd1936:{rom_a,rom_theta}<={9'd109,9'd288};
12'd1937:{rom_a,rom_theta}<={9'd109,9'd288};
12'd1938:{rom_a,rom_theta}<={9'd109,9'd288};
12'd1939:{rom_a,rom_theta}<={9'd109,9'd288};
12'd1940:{rom_a,rom_theta}<={9'd109,9'd288};
12'd1941:{rom_a,rom_theta}<={9'd109,9'd288};
12'd1942:{rom_a,rom_theta}<={9'd109,9'd289};
12'd1943:{rom_a,rom_theta}<={9'd109,9'd289};
12'd1944:{rom_a,rom_theta}<={9'd109,9'd289};
12'd1945:{rom_a,rom_theta}<={9'd110,9'd289};
12'd1946:{rom_a,rom_theta}<={9'd110,9'd289};
12'd1947:{rom_a,rom_theta}<={9'd110,9'd289};
12'd1948:{rom_a,rom_theta}<={9'd110,9'd289};
12'd1949:{rom_a,rom_theta}<={9'd110,9'd290};
12'd1950:{rom_a,rom_theta}<={9'd110,9'd290};
12'd1951:{rom_a,rom_theta}<={9'd110,9'd290};
12'd1952:{rom_a,rom_theta}<={9'd110,9'd290};
12'd1953:{rom_a,rom_theta}<={9'd110,9'd290};
12'd1954:{rom_a,rom_theta}<={9'd111,9'd290};
12'd1955:{rom_a,rom_theta}<={9'd111,9'd290};
12'd1956:{rom_a,rom_theta}<={9'd111,9'd290};
12'd1957:{rom_a,rom_theta}<={9'd111,9'd291};
12'd1958:{rom_a,rom_theta}<={9'd111,9'd291};
12'd1959:{rom_a,rom_theta}<={9'd111,9'd291};
12'd1960:{rom_a,rom_theta}<={9'd111,9'd291};
12'd1961:{rom_a,rom_theta}<={9'd111,9'd291};
12'd1962:{rom_a,rom_theta}<={9'd111,9'd291};
12'd1963:{rom_a,rom_theta}<={9'd112,9'd291};
12'd1964:{rom_a,rom_theta}<={9'd112,9'd291};
12'd1965:{rom_a,rom_theta}<={9'd112,9'd292};
12'd1966:{rom_a,rom_theta}<={9'd112,9'd292};
12'd1967:{rom_a,rom_theta}<={9'd112,9'd292};
12'd1968:{rom_a,rom_theta}<={9'd112,9'd292};
12'd1969:{rom_a,rom_theta}<={9'd112,9'd292};
12'd1970:{rom_a,rom_theta}<={9'd112,9'd292};
12'd1971:{rom_a,rom_theta}<={9'd112,9'd292};
12'd1972:{rom_a,rom_theta}<={9'd112,9'd293};
12'd1973:{rom_a,rom_theta}<={9'd113,9'd293};
12'd1974:{rom_a,rom_theta}<={9'd113,9'd293};
12'd1975:{rom_a,rom_theta}<={9'd113,9'd293};
12'd1976:{rom_a,rom_theta}<={9'd113,9'd293};
12'd1977:{rom_a,rom_theta}<={9'd113,9'd293};
12'd1978:{rom_a,rom_theta}<={9'd113,9'd293};
12'd1979:{rom_a,rom_theta}<={9'd113,9'd293};
12'd1980:{rom_a,rom_theta}<={9'd113,9'd294};
12'd1981:{rom_a,rom_theta}<={9'd113,9'd294};
12'd1982:{rom_a,rom_theta}<={9'd114,9'd294};
12'd1983:{rom_a,rom_theta}<={9'd114,9'd294};
12'd1984:{rom_a,rom_theta}<={9'd114,9'd294};
12'd1985:{rom_a,rom_theta}<={9'd114,9'd294};
12'd1986:{rom_a,rom_theta}<={9'd114,9'd294};
12'd1987:{rom_a,rom_theta}<={9'd114,9'd294};
12'd1988:{rom_a,rom_theta}<={9'd114,9'd295};
12'd1989:{rom_a,rom_theta}<={9'd114,9'd295};
12'd1990:{rom_a,rom_theta}<={9'd114,9'd295};
12'd1991:{rom_a,rom_theta}<={9'd115,9'd295};
12'd1992:{rom_a,rom_theta}<={9'd115,9'd295};
12'd1993:{rom_a,rom_theta}<={9'd115,9'd295};
12'd1994:{rom_a,rom_theta}<={9'd115,9'd295};
12'd1995:{rom_a,rom_theta}<={9'd115,9'd295};
12'd1996:{rom_a,rom_theta}<={9'd115,9'd296};
12'd1997:{rom_a,rom_theta}<={9'd115,9'd296};
12'd1998:{rom_a,rom_theta}<={9'd115,9'd296};
12'd1999:{rom_a,rom_theta}<={9'd115,9'd296};
12'd2000:{rom_a,rom_theta}<={9'd116,9'd296};
12'd2001:{rom_a,rom_theta}<={9'd116,9'd296};
12'd2002:{rom_a,rom_theta}<={9'd116,9'd296};
12'd2003:{rom_a,rom_theta}<={9'd116,9'd296};
12'd2004:{rom_a,rom_theta}<={9'd116,9'd297};
12'd2005:{rom_a,rom_theta}<={9'd116,9'd297};
12'd2006:{rom_a,rom_theta}<={9'd116,9'd297};
12'd2007:{rom_a,rom_theta}<={9'd116,9'd297};
12'd2008:{rom_a,rom_theta}<={9'd116,9'd297};
12'd2009:{rom_a,rom_theta}<={9'd117,9'd297};
12'd2010:{rom_a,rom_theta}<={9'd117,9'd297};
12'd2011:{rom_a,rom_theta}<={9'd117,9'd298};
12'd2012:{rom_a,rom_theta}<={9'd117,9'd298};
12'd2013:{rom_a,rom_theta}<={9'd117,9'd298};
12'd2014:{rom_a,rom_theta}<={9'd117,9'd298};
12'd2015:{rom_a,rom_theta}<={9'd117,9'd298};
12'd2016:{rom_a,rom_theta}<={9'd117,9'd298};
12'd2017:{rom_a,rom_theta}<={9'd117,9'd298};
12'd2018:{rom_a,rom_theta}<={9'd118,9'd298};
12'd2019:{rom_a,rom_theta}<={9'd118,9'd299};
12'd2020:{rom_a,rom_theta}<={9'd118,9'd299};
12'd2021:{rom_a,rom_theta}<={9'd118,9'd299};
12'd2022:{rom_a,rom_theta}<={9'd118,9'd299};
12'd2023:{rom_a,rom_theta}<={9'd118,9'd299};
12'd2024:{rom_a,rom_theta}<={9'd118,9'd299};
12'd2025:{rom_a,rom_theta}<={9'd118,9'd299};
12'd2026:{rom_a,rom_theta}<={9'd118,9'd299};
12'd2027:{rom_a,rom_theta}<={9'd119,9'd300};
12'd2028:{rom_a,rom_theta}<={9'd119,9'd300};
12'd2029:{rom_a,rom_theta}<={9'd119,9'd300};
12'd2030:{rom_a,rom_theta}<={9'd119,9'd300};
12'd2031:{rom_a,rom_theta}<={9'd119,9'd300};
12'd2032:{rom_a,rom_theta}<={9'd119,9'd300};
12'd2033:{rom_a,rom_theta}<={9'd119,9'd300};
12'd2034:{rom_a,rom_theta}<={9'd119,9'd300};
12'd2035:{rom_a,rom_theta}<={9'd119,9'd301};
12'd2036:{rom_a,rom_theta}<={9'd120,9'd301};
12'd2037:{rom_a,rom_theta}<={9'd120,9'd301};
12'd2038:{rom_a,rom_theta}<={9'd120,9'd301};
12'd2039:{rom_a,rom_theta}<={9'd120,9'd301};
12'd2040:{rom_a,rom_theta}<={9'd120,9'd301};
12'd2041:{rom_a,rom_theta}<={9'd120,9'd301};
12'd2042:{rom_a,rom_theta}<={9'd120,9'd301};
12'd2043:{rom_a,rom_theta}<={9'd120,9'd302};
12'd2044:{rom_a,rom_theta}<={9'd120,9'd302};
12'd2045:{rom_a,rom_theta}<={9'd121,9'd302};
12'd2046:{rom_a,rom_theta}<={9'd121,9'd302};
12'd2047:{rom_a,rom_theta}<={9'd121,9'd302};
12'd2048:{rom_a,rom_theta}<={9'd121,9'd302};
12'd2049:{rom_a,rom_theta}<={9'd121,9'd302};
12'd2050:{rom_a,rom_theta}<={9'd121,9'd303};
12'd2051:{rom_a,rom_theta}<={9'd121,9'd303};
12'd2052:{rom_a,rom_theta}<={9'd121,9'd303};
12'd2053:{rom_a,rom_theta}<={9'd121,9'd303};
12'd2054:{rom_a,rom_theta}<={9'd122,9'd303};
12'd2055:{rom_a,rom_theta}<={9'd122,9'd303};
12'd2056:{rom_a,rom_theta}<={9'd122,9'd303};
12'd2057:{rom_a,rom_theta}<={9'd122,9'd303};
12'd2058:{rom_a,rom_theta}<={9'd122,9'd304};
12'd2059:{rom_a,rom_theta}<={9'd122,9'd304};
12'd2060:{rom_a,rom_theta}<={9'd122,9'd304};
12'd2061:{rom_a,rom_theta}<={9'd122,9'd304};
12'd2062:{rom_a,rom_theta}<={9'd122,9'd304};
12'd2063:{rom_a,rom_theta}<={9'd123,9'd304};
12'd2064:{rom_a,rom_theta}<={9'd123,9'd304};
12'd2065:{rom_a,rom_theta}<={9'd123,9'd304};
12'd2066:{rom_a,rom_theta}<={9'd123,9'd305};
12'd2067:{rom_a,rom_theta}<={9'd123,9'd305};
12'd2068:{rom_a,rom_theta}<={9'd123,9'd305};
12'd2069:{rom_a,rom_theta}<={9'd123,9'd305};
12'd2070:{rom_a,rom_theta}<={9'd123,9'd305};
12'd2071:{rom_a,rom_theta}<={9'd123,9'd305};
12'd2072:{rom_a,rom_theta}<={9'd124,9'd305};
12'd2073:{rom_a,rom_theta}<={9'd124,9'd305};
12'd2074:{rom_a,rom_theta}<={9'd124,9'd306};
12'd2075:{rom_a,rom_theta}<={9'd124,9'd306};
12'd2076:{rom_a,rom_theta}<={9'd124,9'd306};
12'd2077:{rom_a,rom_theta}<={9'd124,9'd306};
12'd2078:{rom_a,rom_theta}<={9'd124,9'd306};
12'd2079:{rom_a,rom_theta}<={9'd124,9'd306};
12'd2080:{rom_a,rom_theta}<={9'd124,9'd306};
12'd2081:{rom_a,rom_theta}<={9'd125,9'd306};
12'd2082:{rom_a,rom_theta}<={9'd125,9'd307};
12'd2083:{rom_a,rom_theta}<={9'd125,9'd307};
12'd2084:{rom_a,rom_theta}<={9'd125,9'd307};
12'd2085:{rom_a,rom_theta}<={9'd125,9'd307};
12'd2086:{rom_a,rom_theta}<={9'd125,9'd307};
12'd2087:{rom_a,rom_theta}<={9'd125,9'd307};
12'd2088:{rom_a,rom_theta}<={9'd125,9'd307};
12'd2089:{rom_a,rom_theta}<={9'd125,9'd307};
12'd2090:{rom_a,rom_theta}<={9'd126,9'd308};
12'd2091:{rom_a,rom_theta}<={9'd126,9'd308};
12'd2092:{rom_a,rom_theta}<={9'd126,9'd308};
12'd2093:{rom_a,rom_theta}<={9'd126,9'd308};
12'd2094:{rom_a,rom_theta}<={9'd126,9'd308};
12'd2095:{rom_a,rom_theta}<={9'd126,9'd308};
12'd2096:{rom_a,rom_theta}<={9'd126,9'd308};
12'd2097:{rom_a,rom_theta}<={9'd126,9'd308};
12'd2098:{rom_a,rom_theta}<={9'd127,9'd309};
12'd2099:{rom_a,rom_theta}<={9'd127,9'd309};
12'd2100:{rom_a,rom_theta}<={9'd127,9'd309};
12'd2101:{rom_a,rom_theta}<={9'd127,9'd309};
12'd2102:{rom_a,rom_theta}<={9'd127,9'd309};
12'd2103:{rom_a,rom_theta}<={9'd127,9'd309};
12'd2104:{rom_a,rom_theta}<={9'd127,9'd309};
12'd2105:{rom_a,rom_theta}<={9'd127,9'd309};
12'd2106:{rom_a,rom_theta}<={9'd127,9'd310};
12'd2107:{rom_a,rom_theta}<={9'd128,9'd310};
12'd2108:{rom_a,rom_theta}<={9'd128,9'd310};
12'd2109:{rom_a,rom_theta}<={9'd128,9'd310};
12'd2110:{rom_a,rom_theta}<={9'd128,9'd310};
12'd2111:{rom_a,rom_theta}<={9'd128,9'd310};
12'd2112:{rom_a,rom_theta}<={9'd128,9'd310};
12'd2113:{rom_a,rom_theta}<={9'd128,9'd310};
12'd2114:{rom_a,rom_theta}<={9'd128,9'd311};
12'd2115:{rom_a,rom_theta}<={9'd128,9'd311};
12'd2116:{rom_a,rom_theta}<={9'd129,9'd311};
12'd2117:{rom_a,rom_theta}<={9'd129,9'd311};
12'd2118:{rom_a,rom_theta}<={9'd129,9'd311};
12'd2119:{rom_a,rom_theta}<={9'd129,9'd311};
12'd2120:{rom_a,rom_theta}<={9'd129,9'd311};
12'd2121:{rom_a,rom_theta}<={9'd129,9'd311};
12'd2122:{rom_a,rom_theta}<={9'd129,9'd312};
12'd2123:{rom_a,rom_theta}<={9'd129,9'd312};
12'd2124:{rom_a,rom_theta}<={9'd129,9'd312};
12'd2125:{rom_a,rom_theta}<={9'd130,9'd312};
12'd2126:{rom_a,rom_theta}<={9'd130,9'd312};
12'd2127:{rom_a,rom_theta}<={9'd130,9'd312};
12'd2128:{rom_a,rom_theta}<={9'd130,9'd312};
12'd2129:{rom_a,rom_theta}<={9'd130,9'd312};
12'd2130:{rom_a,rom_theta}<={9'd130,9'd313};
12'd2131:{rom_a,rom_theta}<={9'd130,9'd313};
12'd2132:{rom_a,rom_theta}<={9'd130,9'd313};
12'd2133:{rom_a,rom_theta}<={9'd131,9'd313};
12'd2134:{rom_a,rom_theta}<={9'd131,9'd313};
12'd2135:{rom_a,rom_theta}<={9'd131,9'd313};
12'd2136:{rom_a,rom_theta}<={9'd131,9'd313};
12'd2137:{rom_a,rom_theta}<={9'd131,9'd313};
12'd2138:{rom_a,rom_theta}<={9'd131,9'd314};
12'd2139:{rom_a,rom_theta}<={9'd131,9'd314};
12'd2140:{rom_a,rom_theta}<={9'd131,9'd314};
12'd2141:{rom_a,rom_theta}<={9'd131,9'd314};
12'd2142:{rom_a,rom_theta}<={9'd132,9'd314};
12'd2143:{rom_a,rom_theta}<={9'd132,9'd314};
12'd2144:{rom_a,rom_theta}<={9'd132,9'd314};
12'd2145:{rom_a,rom_theta}<={9'd132,9'd314};
12'd2146:{rom_a,rom_theta}<={9'd132,9'd315};
12'd2147:{rom_a,rom_theta}<={9'd132,9'd315};
12'd2148:{rom_a,rom_theta}<={9'd132,9'd315};
12'd2149:{rom_a,rom_theta}<={9'd132,9'd315};
12'd2150:{rom_a,rom_theta}<={9'd132,9'd315};
12'd2151:{rom_a,rom_theta}<={9'd133,9'd315};
12'd2152:{rom_a,rom_theta}<={9'd133,9'd315};
12'd2153:{rom_a,rom_theta}<={9'd133,9'd315};
12'd2154:{rom_a,rom_theta}<={9'd133,9'd316};
12'd2155:{rom_a,rom_theta}<={9'd133,9'd316};
12'd2156:{rom_a,rom_theta}<={9'd133,9'd316};
12'd2157:{rom_a,rom_theta}<={9'd133,9'd316};
12'd2158:{rom_a,rom_theta}<={9'd133,9'd316};
12'd2159:{rom_a,rom_theta}<={9'd134,9'd316};
12'd2160:{rom_a,rom_theta}<={9'd134,9'd316};
12'd2161:{rom_a,rom_theta}<={9'd134,9'd316};
12'd2162:{rom_a,rom_theta}<={9'd134,9'd317};
12'd2163:{rom_a,rom_theta}<={9'd134,9'd317};
12'd2164:{rom_a,rom_theta}<={9'd134,9'd317};
12'd2165:{rom_a,rom_theta}<={9'd134,9'd317};
12'd2166:{rom_a,rom_theta}<={9'd134,9'd317};
12'd2167:{rom_a,rom_theta}<={9'd134,9'd317};
12'd2168:{rom_a,rom_theta}<={9'd135,9'd317};
12'd2169:{rom_a,rom_theta}<={9'd135,9'd317};
12'd2170:{rom_a,rom_theta}<={9'd135,9'd318};
12'd2171:{rom_a,rom_theta}<={9'd135,9'd318};
12'd2172:{rom_a,rom_theta}<={9'd135,9'd318};
12'd2173:{rom_a,rom_theta}<={9'd135,9'd318};
12'd2174:{rom_a,rom_theta}<={9'd135,9'd318};
12'd2175:{rom_a,rom_theta}<={9'd135,9'd318};
12'd2176:{rom_a,rom_theta}<={9'd136,9'd318};
12'd2177:{rom_a,rom_theta}<={9'd136,9'd318};
12'd2178:{rom_a,rom_theta}<={9'd136,9'd319};
12'd2179:{rom_a,rom_theta}<={9'd136,9'd319};
12'd2180:{rom_a,rom_theta}<={9'd136,9'd319};
12'd2181:{rom_a,rom_theta}<={9'd136,9'd319};
12'd2182:{rom_a,rom_theta}<={9'd136,9'd319};
12'd2183:{rom_a,rom_theta}<={9'd136,9'd319};
12'd2184:{rom_a,rom_theta}<={9'd136,9'd319};
12'd2185:{rom_a,rom_theta}<={9'd137,9'd319};
12'd2186:{rom_a,rom_theta}<={9'd137,9'd320};
12'd2187:{rom_a,rom_theta}<={9'd137,9'd320};
12'd2188:{rom_a,rom_theta}<={9'd137,9'd320};
12'd2189:{rom_a,rom_theta}<={9'd137,9'd320};
12'd2190:{rom_a,rom_theta}<={9'd137,9'd320};
12'd2191:{rom_a,rom_theta}<={9'd137,9'd320};
12'd2192:{rom_a,rom_theta}<={9'd137,9'd320};
12'd2193:{rom_a,rom_theta}<={9'd138,9'd320};
12'd2194:{rom_a,rom_theta}<={9'd138,9'd321};
12'd2195:{rom_a,rom_theta}<={9'd138,9'd321};
12'd2196:{rom_a,rom_theta}<={9'd138,9'd321};
12'd2197:{rom_a,rom_theta}<={9'd138,9'd321};
12'd2198:{rom_a,rom_theta}<={9'd138,9'd321};
12'd2199:{rom_a,rom_theta}<={9'd138,9'd321};
12'd2200:{rom_a,rom_theta}<={9'd138,9'd321};
12'd2201:{rom_a,rom_theta}<={9'd138,9'd321};
12'd2202:{rom_a,rom_theta}<={9'd139,9'd322};
12'd2203:{rom_a,rom_theta}<={9'd139,9'd322};
12'd2204:{rom_a,rom_theta}<={9'd139,9'd322};
12'd2205:{rom_a,rom_theta}<={9'd139,9'd322};
12'd2206:{rom_a,rom_theta}<={9'd139,9'd322};
12'd2207:{rom_a,rom_theta}<={9'd139,9'd322};
12'd2208:{rom_a,rom_theta}<={9'd139,9'd322};
12'd2209:{rom_a,rom_theta}<={9'd139,9'd322};
12'd2210:{rom_a,rom_theta}<={9'd140,9'd323};
12'd2211:{rom_a,rom_theta}<={9'd140,9'd323};
12'd2212:{rom_a,rom_theta}<={9'd140,9'd323};
12'd2213:{rom_a,rom_theta}<={9'd140,9'd323};
12'd2214:{rom_a,rom_theta}<={9'd140,9'd323};
12'd2215:{rom_a,rom_theta}<={9'd140,9'd323};
12'd2216:{rom_a,rom_theta}<={9'd140,9'd323};
12'd2217:{rom_a,rom_theta}<={9'd140,9'd323};
12'd2218:{rom_a,rom_theta}<={9'd140,9'd324};
12'd2219:{rom_a,rom_theta}<={9'd141,9'd324};
12'd2220:{rom_a,rom_theta}<={9'd141,9'd324};
12'd2221:{rom_a,rom_theta}<={9'd141,9'd324};
12'd2222:{rom_a,rom_theta}<={9'd141,9'd324};
12'd2223:{rom_a,rom_theta}<={9'd141,9'd324};
12'd2224:{rom_a,rom_theta}<={9'd141,9'd324};
12'd2225:{rom_a,rom_theta}<={9'd141,9'd324};
12'd2226:{rom_a,rom_theta}<={9'd141,9'd325};
12'd2227:{rom_a,rom_theta}<={9'd142,9'd325};
12'd2228:{rom_a,rom_theta}<={9'd142,9'd325};
12'd2229:{rom_a,rom_theta}<={9'd142,9'd325};
12'd2230:{rom_a,rom_theta}<={9'd142,9'd325};
12'd2231:{rom_a,rom_theta}<={9'd142,9'd325};
12'd2232:{rom_a,rom_theta}<={9'd142,9'd325};
12'd2233:{rom_a,rom_theta}<={9'd142,9'd325};
12'd2234:{rom_a,rom_theta}<={9'd142,9'd326};
12'd2235:{rom_a,rom_theta}<={9'd143,9'd326};
12'd2236:{rom_a,rom_theta}<={9'd143,9'd326};
12'd2237:{rom_a,rom_theta}<={9'd143,9'd326};
12'd2238:{rom_a,rom_theta}<={9'd143,9'd326};
12'd2239:{rom_a,rom_theta}<={9'd143,9'd326};
12'd2240:{rom_a,rom_theta}<={9'd143,9'd326};
12'd2241:{rom_a,rom_theta}<={9'd143,9'd326};
12'd2242:{rom_a,rom_theta}<={9'd143,9'd326};
12'd2243:{rom_a,rom_theta}<={9'd143,9'd327};
12'd2244:{rom_a,rom_theta}<={9'd144,9'd327};
12'd2245:{rom_a,rom_theta}<={9'd144,9'd327};
12'd2246:{rom_a,rom_theta}<={9'd144,9'd327};
12'd2247:{rom_a,rom_theta}<={9'd144,9'd327};
12'd2248:{rom_a,rom_theta}<={9'd144,9'd327};
12'd2249:{rom_a,rom_theta}<={9'd144,9'd327};
12'd2250:{rom_a,rom_theta}<={9'd144,9'd327};
12'd2251:{rom_a,rom_theta}<={9'd144,9'd328};
12'd2252:{rom_a,rom_theta}<={9'd145,9'd328};
12'd2253:{rom_a,rom_theta}<={9'd145,9'd328};
12'd2254:{rom_a,rom_theta}<={9'd145,9'd328};
12'd2255:{rom_a,rom_theta}<={9'd145,9'd328};
12'd2256:{rom_a,rom_theta}<={9'd145,9'd328};
12'd2257:{rom_a,rom_theta}<={9'd145,9'd328};
12'd2258:{rom_a,rom_theta}<={9'd145,9'd328};
12'd2259:{rom_a,rom_theta}<={9'd145,9'd329};
12'd2260:{rom_a,rom_theta}<={9'd146,9'd329};
12'd2261:{rom_a,rom_theta}<={9'd146,9'd329};
12'd2262:{rom_a,rom_theta}<={9'd146,9'd329};
12'd2263:{rom_a,rom_theta}<={9'd146,9'd329};
12'd2264:{rom_a,rom_theta}<={9'd146,9'd329};
12'd2265:{rom_a,rom_theta}<={9'd146,9'd329};
12'd2266:{rom_a,rom_theta}<={9'd146,9'd329};
12'd2267:{rom_a,rom_theta}<={9'd146,9'd330};
12'd2268:{rom_a,rom_theta}<={9'd146,9'd330};
12'd2269:{rom_a,rom_theta}<={9'd147,9'd330};
12'd2270:{rom_a,rom_theta}<={9'd147,9'd330};
12'd2271:{rom_a,rom_theta}<={9'd147,9'd330};
12'd2272:{rom_a,rom_theta}<={9'd147,9'd330};
12'd2273:{rom_a,rom_theta}<={9'd147,9'd330};
12'd2274:{rom_a,rom_theta}<={9'd147,9'd330};
12'd2275:{rom_a,rom_theta}<={9'd147,9'd331};
12'd2276:{rom_a,rom_theta}<={9'd147,9'd331};
12'd2277:{rom_a,rom_theta}<={9'd148,9'd331};
12'd2278:{rom_a,rom_theta}<={9'd148,9'd331};
12'd2279:{rom_a,rom_theta}<={9'd148,9'd331};
12'd2280:{rom_a,rom_theta}<={9'd148,9'd331};
12'd2281:{rom_a,rom_theta}<={9'd148,9'd331};
12'd2282:{rom_a,rom_theta}<={9'd148,9'd331};
12'd2283:{rom_a,rom_theta}<={9'd148,9'd331};
12'd2284:{rom_a,rom_theta}<={9'd148,9'd332};
12'd2285:{rom_a,rom_theta}<={9'd149,9'd332};
12'd2286:{rom_a,rom_theta}<={9'd149,9'd332};
12'd2287:{rom_a,rom_theta}<={9'd149,9'd332};
12'd2288:{rom_a,rom_theta}<={9'd149,9'd332};
12'd2289:{rom_a,rom_theta}<={9'd149,9'd332};
12'd2290:{rom_a,rom_theta}<={9'd149,9'd332};
12'd2291:{rom_a,rom_theta}<={9'd149,9'd332};
12'd2292:{rom_a,rom_theta}<={9'd149,9'd333};
12'd2293:{rom_a,rom_theta}<={9'd150,9'd333};
12'd2294:{rom_a,rom_theta}<={9'd150,9'd333};
12'd2295:{rom_a,rom_theta}<={9'd150,9'd333};
12'd2296:{rom_a,rom_theta}<={9'd150,9'd333};
12'd2297:{rom_a,rom_theta}<={9'd150,9'd333};
12'd2298:{rom_a,rom_theta}<={9'd150,9'd333};
12'd2299:{rom_a,rom_theta}<={9'd150,9'd333};
12'd2300:{rom_a,rom_theta}<={9'd150,9'd334};
12'd2301:{rom_a,rom_theta}<={9'd151,9'd334};
12'd2302:{rom_a,rom_theta}<={9'd151,9'd334};
12'd2303:{rom_a,rom_theta}<={9'd151,9'd334};
12'd2304:{rom_a,rom_theta}<={9'd151,9'd334};
12'd2305:{rom_a,rom_theta}<={9'd151,9'd334};
12'd2306:{rom_a,rom_theta}<={9'd151,9'd334};
12'd2307:{rom_a,rom_theta}<={9'd151,9'd334};
12'd2308:{rom_a,rom_theta}<={9'd151,9'd335};
12'd2309:{rom_a,rom_theta}<={9'd151,9'd335};
12'd2310:{rom_a,rom_theta}<={9'd152,9'd335};
12'd2311:{rom_a,rom_theta}<={9'd152,9'd335};
12'd2312:{rom_a,rom_theta}<={9'd152,9'd335};
12'd2313:{rom_a,rom_theta}<={9'd152,9'd335};
12'd2314:{rom_a,rom_theta}<={9'd152,9'd335};
12'd2315:{rom_a,rom_theta}<={9'd152,9'd335};
12'd2316:{rom_a,rom_theta}<={9'd152,9'd335};
12'd2317:{rom_a,rom_theta}<={9'd152,9'd336};
12'd2318:{rom_a,rom_theta}<={9'd153,9'd336};
12'd2319:{rom_a,rom_theta}<={9'd153,9'd336};
12'd2320:{rom_a,rom_theta}<={9'd153,9'd336};
12'd2321:{rom_a,rom_theta}<={9'd153,9'd336};
12'd2322:{rom_a,rom_theta}<={9'd153,9'd336};
12'd2323:{rom_a,rom_theta}<={9'd153,9'd336};
12'd2324:{rom_a,rom_theta}<={9'd153,9'd336};
12'd2325:{rom_a,rom_theta}<={9'd153,9'd337};
12'd2326:{rom_a,rom_theta}<={9'd154,9'd337};
12'd2327:{rom_a,rom_theta}<={9'd154,9'd337};
12'd2328:{rom_a,rom_theta}<={9'd154,9'd337};
12'd2329:{rom_a,rom_theta}<={9'd154,9'd337};
12'd2330:{rom_a,rom_theta}<={9'd154,9'd337};
12'd2331:{rom_a,rom_theta}<={9'd154,9'd337};
12'd2332:{rom_a,rom_theta}<={9'd154,9'd337};
12'd2333:{rom_a,rom_theta}<={9'd154,9'd338};
12'd2334:{rom_a,rom_theta}<={9'd155,9'd338};
12'd2335:{rom_a,rom_theta}<={9'd155,9'd338};
12'd2336:{rom_a,rom_theta}<={9'd155,9'd338};
12'd2337:{rom_a,rom_theta}<={9'd155,9'd338};
12'd2338:{rom_a,rom_theta}<={9'd155,9'd338};
12'd2339:{rom_a,rom_theta}<={9'd155,9'd338};
12'd2340:{rom_a,rom_theta}<={9'd155,9'd338};
12'd2341:{rom_a,rom_theta}<={9'd155,9'd338};
12'd2342:{rom_a,rom_theta}<={9'd156,9'd339};
12'd2343:{rom_a,rom_theta}<={9'd156,9'd339};
12'd2344:{rom_a,rom_theta}<={9'd156,9'd339};
12'd2345:{rom_a,rom_theta}<={9'd156,9'd339};
12'd2346:{rom_a,rom_theta}<={9'd156,9'd339};
12'd2347:{rom_a,rom_theta}<={9'd156,9'd339};
12'd2348:{rom_a,rom_theta}<={9'd156,9'd339};
12'd2349:{rom_a,rom_theta}<={9'd156,9'd339};
12'd2350:{rom_a,rom_theta}<={9'd157,9'd340};
12'd2351:{rom_a,rom_theta}<={9'd157,9'd340};
12'd2352:{rom_a,rom_theta}<={9'd157,9'd340};
12'd2353:{rom_a,rom_theta}<={9'd157,9'd340};
12'd2354:{rom_a,rom_theta}<={9'd157,9'd340};
12'd2355:{rom_a,rom_theta}<={9'd157,9'd340};
12'd2356:{rom_a,rom_theta}<={9'd157,9'd340};
12'd2357:{rom_a,rom_theta}<={9'd157,9'd340};
12'd2358:{rom_a,rom_theta}<={9'd158,9'd341};
12'd2359:{rom_a,rom_theta}<={9'd158,9'd341};
12'd2360:{rom_a,rom_theta}<={9'd158,9'd341};
12'd2361:{rom_a,rom_theta}<={9'd158,9'd341};
12'd2362:{rom_a,rom_theta}<={9'd158,9'd341};
12'd2363:{rom_a,rom_theta}<={9'd158,9'd341};
12'd2364:{rom_a,rom_theta}<={9'd158,9'd341};
12'd2365:{rom_a,rom_theta}<={9'd158,9'd341};
12'd2366:{rom_a,rom_theta}<={9'd159,9'd341};
12'd2367:{rom_a,rom_theta}<={9'd159,9'd342};
12'd2368:{rom_a,rom_theta}<={9'd159,9'd342};
12'd2369:{rom_a,rom_theta}<={9'd159,9'd342};
12'd2370:{rom_a,rom_theta}<={9'd159,9'd342};
12'd2371:{rom_a,rom_theta}<={9'd159,9'd342};
12'd2372:{rom_a,rom_theta}<={9'd159,9'd342};
12'd2373:{rom_a,rom_theta}<={9'd159,9'd342};
12'd2374:{rom_a,rom_theta}<={9'd160,9'd342};
12'd2375:{rom_a,rom_theta}<={9'd160,9'd343};
12'd2376:{rom_a,rom_theta}<={9'd160,9'd343};
12'd2377:{rom_a,rom_theta}<={9'd160,9'd343};
12'd2378:{rom_a,rom_theta}<={9'd160,9'd343};
12'd2379:{rom_a,rom_theta}<={9'd160,9'd343};
12'd2380:{rom_a,rom_theta}<={9'd160,9'd343};
12'd2381:{rom_a,rom_theta}<={9'd160,9'd343};
12'd2382:{rom_a,rom_theta}<={9'd161,9'd343};
12'd2383:{rom_a,rom_theta}<={9'd161,9'd343};
12'd2384:{rom_a,rom_theta}<={9'd161,9'd344};
12'd2385:{rom_a,rom_theta}<={9'd161,9'd344};
12'd2386:{rom_a,rom_theta}<={9'd161,9'd344};
12'd2387:{rom_a,rom_theta}<={9'd161,9'd344};
12'd2388:{rom_a,rom_theta}<={9'd161,9'd344};
12'd2389:{rom_a,rom_theta}<={9'd161,9'd344};
12'd2390:{rom_a,rom_theta}<={9'd162,9'd344};
12'd2391:{rom_a,rom_theta}<={9'd162,9'd344};
12'd2392:{rom_a,rom_theta}<={9'd162,9'd345};
12'd2393:{rom_a,rom_theta}<={9'd162,9'd345};
12'd2394:{rom_a,rom_theta}<={9'd162,9'd345};
12'd2395:{rom_a,rom_theta}<={9'd162,9'd345};
12'd2396:{rom_a,rom_theta}<={9'd162,9'd345};
12'd2397:{rom_a,rom_theta}<={9'd162,9'd345};
12'd2398:{rom_a,rom_theta}<={9'd163,9'd345};
12'd2399:{rom_a,rom_theta}<={9'd163,9'd345};
12'd2400:{rom_a,rom_theta}<={9'd163,9'd346};
12'd2401:{rom_a,rom_theta}<={9'd163,9'd346};
12'd2402:{rom_a,rom_theta}<={9'd163,9'd346};
12'd2403:{rom_a,rom_theta}<={9'd163,9'd346};
12'd2404:{rom_a,rom_theta}<={9'd163,9'd346};
12'd2405:{rom_a,rom_theta}<={9'd163,9'd346};
12'd2406:{rom_a,rom_theta}<={9'd164,9'd346};
12'd2407:{rom_a,rom_theta}<={9'd164,9'd346};
12'd2408:{rom_a,rom_theta}<={9'd164,9'd346};
12'd2409:{rom_a,rom_theta}<={9'd164,9'd347};
12'd2410:{rom_a,rom_theta}<={9'd164,9'd347};
12'd2411:{rom_a,rom_theta}<={9'd164,9'd347};
12'd2412:{rom_a,rom_theta}<={9'd164,9'd347};
12'd2413:{rom_a,rom_theta}<={9'd164,9'd347};
12'd2414:{rom_a,rom_theta}<={9'd165,9'd347};
12'd2415:{rom_a,rom_theta}<={9'd165,9'd347};
12'd2416:{rom_a,rom_theta}<={9'd165,9'd347};
12'd2417:{rom_a,rom_theta}<={9'd165,9'd348};
12'd2418:{rom_a,rom_theta}<={9'd165,9'd348};
12'd2419:{rom_a,rom_theta}<={9'd165,9'd348};
12'd2420:{rom_a,rom_theta}<={9'd165,9'd348};
12'd2421:{rom_a,rom_theta}<={9'd165,9'd348};
12'd2422:{rom_a,rom_theta}<={9'd166,9'd348};
12'd2423:{rom_a,rom_theta}<={9'd166,9'd348};
12'd2424:{rom_a,rom_theta}<={9'd166,9'd348};
12'd2425:{rom_a,rom_theta}<={9'd166,9'd348};
12'd2426:{rom_a,rom_theta}<={9'd166,9'd349};
12'd2427:{rom_a,rom_theta}<={9'd166,9'd349};
12'd2428:{rom_a,rom_theta}<={9'd166,9'd349};
12'd2429:{rom_a,rom_theta}<={9'd167,9'd349};
12'd2430:{rom_a,rom_theta}<={9'd167,9'd349};
12'd2431:{rom_a,rom_theta}<={9'd167,9'd349};
12'd2432:{rom_a,rom_theta}<={9'd167,9'd349};
12'd2433:{rom_a,rom_theta}<={9'd167,9'd349};
12'd2434:{rom_a,rom_theta}<={9'd167,9'd350};
12'd2435:{rom_a,rom_theta}<={9'd167,9'd350};
12'd2436:{rom_a,rom_theta}<={9'd167,9'd350};
12'd2437:{rom_a,rom_theta}<={9'd168,9'd350};
12'd2438:{rom_a,rom_theta}<={9'd168,9'd350};
12'd2439:{rom_a,rom_theta}<={9'd168,9'd350};
12'd2440:{rom_a,rom_theta}<={9'd168,9'd350};
12'd2441:{rom_a,rom_theta}<={9'd168,9'd350};
12'd2442:{rom_a,rom_theta}<={9'd168,9'd350};
12'd2443:{rom_a,rom_theta}<={9'd168,9'd351};
12'd2444:{rom_a,rom_theta}<={9'd168,9'd351};
12'd2445:{rom_a,rom_theta}<={9'd169,9'd351};
12'd2446:{rom_a,rom_theta}<={9'd169,9'd351};
12'd2447:{rom_a,rom_theta}<={9'd169,9'd351};
12'd2448:{rom_a,rom_theta}<={9'd169,9'd351};
12'd2449:{rom_a,rom_theta}<={9'd169,9'd351};
12'd2450:{rom_a,rom_theta}<={9'd169,9'd351};
12'd2451:{rom_a,rom_theta}<={9'd169,9'd352};
12'd2452:{rom_a,rom_theta}<={9'd169,9'd352};
12'd2453:{rom_a,rom_theta}<={9'd170,9'd352};
12'd2454:{rom_a,rom_theta}<={9'd170,9'd352};
12'd2455:{rom_a,rom_theta}<={9'd170,9'd352};
12'd2456:{rom_a,rom_theta}<={9'd170,9'd352};
12'd2457:{rom_a,rom_theta}<={9'd170,9'd352};
12'd2458:{rom_a,rom_theta}<={9'd170,9'd352};
12'd2459:{rom_a,rom_theta}<={9'd170,9'd352};
12'd2460:{rom_a,rom_theta}<={9'd170,9'd353};
12'd2461:{rom_a,rom_theta}<={9'd171,9'd353};
12'd2462:{rom_a,rom_theta}<={9'd171,9'd353};
12'd2463:{rom_a,rom_theta}<={9'd171,9'd353};
12'd2464:{rom_a,rom_theta}<={9'd171,9'd353};
12'd2465:{rom_a,rom_theta}<={9'd171,9'd353};
12'd2466:{rom_a,rom_theta}<={9'd171,9'd353};
12'd2467:{rom_a,rom_theta}<={9'd171,9'd353};
12'd2468:{rom_a,rom_theta}<={9'd172,9'd354};
12'd2469:{rom_a,rom_theta}<={9'd172,9'd354};
12'd2470:{rom_a,rom_theta}<={9'd172,9'd354};
12'd2471:{rom_a,rom_theta}<={9'd172,9'd354};
12'd2472:{rom_a,rom_theta}<={9'd172,9'd354};
12'd2473:{rom_a,rom_theta}<={9'd172,9'd354};
12'd2474:{rom_a,rom_theta}<={9'd172,9'd354};
12'd2475:{rom_a,rom_theta}<={9'd172,9'd354};
12'd2476:{rom_a,rom_theta}<={9'd173,9'd354};
12'd2477:{rom_a,rom_theta}<={9'd173,9'd355};
12'd2478:{rom_a,rom_theta}<={9'd173,9'd355};
12'd2479:{rom_a,rom_theta}<={9'd173,9'd355};
12'd2480:{rom_a,rom_theta}<={9'd173,9'd355};
12'd2481:{rom_a,rom_theta}<={9'd173,9'd355};
12'd2482:{rom_a,rom_theta}<={9'd173,9'd355};
12'd2483:{rom_a,rom_theta}<={9'd173,9'd355};
12'd2484:{rom_a,rom_theta}<={9'd174,9'd355};
12'd2485:{rom_a,rom_theta}<={9'd174,9'd355};
12'd2486:{rom_a,rom_theta}<={9'd174,9'd356};
12'd2487:{rom_a,rom_theta}<={9'd174,9'd356};
12'd2488:{rom_a,rom_theta}<={9'd174,9'd356};
12'd2489:{rom_a,rom_theta}<={9'd174,9'd356};
12'd2490:{rom_a,rom_theta}<={9'd174,9'd356};
12'd2491:{rom_a,rom_theta}<={9'd174,9'd356};
12'd2492:{rom_a,rom_theta}<={9'd175,9'd356};
12'd2493:{rom_a,rom_theta}<={9'd175,9'd356};
12'd2494:{rom_a,rom_theta}<={9'd175,9'd357};
12'd2495:{rom_a,rom_theta}<={9'd175,9'd357};
12'd2496:{rom_a,rom_theta}<={9'd175,9'd357};
12'd2497:{rom_a,rom_theta}<={9'd175,9'd357};
12'd2498:{rom_a,rom_theta}<={9'd175,9'd357};
12'd2499:{rom_a,rom_theta}<={9'd176,9'd357};
12'd2500:{rom_a,rom_theta}<={9'd176,9'd357};
12'd2501:{rom_a,rom_theta}<={9'd176,9'd357};
12'd2502:{rom_a,rom_theta}<={9'd176,9'd357};
12'd2503:{rom_a,rom_theta}<={9'd176,9'd358};
12'd2504:{rom_a,rom_theta}<={9'd176,9'd358};
12'd2505:{rom_a,rom_theta}<={9'd176,9'd358};
12'd2506:{rom_a,rom_theta}<={9'd176,9'd358};
12'd2507:{rom_a,rom_theta}<={9'd177,9'd358};
12'd2508:{rom_a,rom_theta}<={9'd177,9'd358};
12'd2509:{rom_a,rom_theta}<={9'd177,9'd358};
12'd2510:{rom_a,rom_theta}<={9'd177,9'd358};
12'd2511:{rom_a,rom_theta}<={9'd177,9'd359};
12'd2512:{rom_a,rom_theta}<={9'd177,9'd359};
12'd2513:{rom_a,rom_theta}<={9'd177,9'd359};
12'd2514:{rom_a,rom_theta}<={9'd177,9'd359};
12'd2515:{rom_a,rom_theta}<={9'd178,9'd359};
12'd2516:{rom_a,rom_theta}<={9'd178,9'd359};
12'd2517:{rom_a,rom_theta}<={9'd178,9'd359};
12'd2518:{rom_a,rom_theta}<={9'd178,9'd359};
12'd2519:{rom_a,rom_theta}<={9'd178,9'd359};
12'd2520:{rom_a,rom_theta}<={9'd178,9'd360};
12'd2521:{rom_a,rom_theta}<={9'd178,9'd360};
12'd2522:{rom_a,rom_theta}<={9'd179,9'd360};
12'd2523:{rom_a,rom_theta}<={9'd179,9'd360};
12'd2524:{rom_a,rom_theta}<={9'd179,9'd360};
12'd2525:{rom_a,rom_theta}<={9'd179,9'd360};
12'd2526:{rom_a,rom_theta}<={9'd179,9'd360};
12'd2527:{rom_a,rom_theta}<={9'd179,9'd360};
12'd2528:{rom_a,rom_theta}<={9'd179,9'd360};
12'd2529:{rom_a,rom_theta}<={9'd179,9'd361};
12'd2530:{rom_a,rom_theta}<={9'd180,9'd361};
12'd2531:{rom_a,rom_theta}<={9'd180,9'd361};
12'd2532:{rom_a,rom_theta}<={9'd180,9'd361};
12'd2533:{rom_a,rom_theta}<={9'd180,9'd361};
12'd2534:{rom_a,rom_theta}<={9'd180,9'd361};
12'd2535:{rom_a,rom_theta}<={9'd180,9'd361};
12'd2536:{rom_a,rom_theta}<={9'd180,9'd361};
12'd2537:{rom_a,rom_theta}<={9'd181,9'd362};
12'd2538:{rom_a,rom_theta}<={9'd181,9'd362};
12'd2539:{rom_a,rom_theta}<={9'd181,9'd362};
12'd2540:{rom_a,rom_theta}<={9'd181,9'd362};
12'd2541:{rom_a,rom_theta}<={9'd181,9'd362};
12'd2542:{rom_a,rom_theta}<={9'd181,9'd362};
12'd2543:{rom_a,rom_theta}<={9'd181,9'd362};
12'd2544:{rom_a,rom_theta}<={9'd181,9'd362};
12'd2545:{rom_a,rom_theta}<={9'd182,9'd362};
12'd2546:{rom_a,rom_theta}<={9'd182,9'd363};
12'd2547:{rom_a,rom_theta}<={9'd182,9'd363};
12'd2548:{rom_a,rom_theta}<={9'd182,9'd363};
12'd2549:{rom_a,rom_theta}<={9'd182,9'd363};
12'd2550:{rom_a,rom_theta}<={9'd182,9'd363};
12'd2551:{rom_a,rom_theta}<={9'd182,9'd363};
12'd2552:{rom_a,rom_theta}<={9'd182,9'd363};
12'd2553:{rom_a,rom_theta}<={9'd183,9'd363};
12'd2554:{rom_a,rom_theta}<={9'd183,9'd363};
12'd2555:{rom_a,rom_theta}<={9'd183,9'd364};
12'd2556:{rom_a,rom_theta}<={9'd183,9'd364};
12'd2557:{rom_a,rom_theta}<={9'd183,9'd364};
12'd2558:{rom_a,rom_theta}<={9'd183,9'd364};
12'd2559:{rom_a,rom_theta}<={9'd183,9'd364};
12'd2560:{rom_a,rom_theta}<={9'd184,9'd364};
12'd2561:{rom_a,rom_theta}<={9'd184,9'd364};
12'd2562:{rom_a,rom_theta}<={9'd184,9'd364};
12'd2563:{rom_a,rom_theta}<={9'd184,9'd364};
12'd2564:{rom_a,rom_theta}<={9'd184,9'd365};
12'd2565:{rom_a,rom_theta}<={9'd184,9'd365};
12'd2566:{rom_a,rom_theta}<={9'd184,9'd365};
12'd2567:{rom_a,rom_theta}<={9'd184,9'd365};
12'd2568:{rom_a,rom_theta}<={9'd185,9'd365};
12'd2569:{rom_a,rom_theta}<={9'd185,9'd365};
12'd2570:{rom_a,rom_theta}<={9'd185,9'd365};
12'd2571:{rom_a,rom_theta}<={9'd185,9'd365};
12'd2572:{rom_a,rom_theta}<={9'd185,9'd366};
12'd2573:{rom_a,rom_theta}<={9'd185,9'd366};
12'd2574:{rom_a,rom_theta}<={9'd185,9'd366};
12'd2575:{rom_a,rom_theta}<={9'd186,9'd366};
12'd2576:{rom_a,rom_theta}<={9'd186,9'd366};
12'd2577:{rom_a,rom_theta}<={9'd186,9'd366};
12'd2578:{rom_a,rom_theta}<={9'd186,9'd366};
12'd2579:{rom_a,rom_theta}<={9'd186,9'd366};
12'd2580:{rom_a,rom_theta}<={9'd186,9'd366};
12'd2581:{rom_a,rom_theta}<={9'd186,9'd367};
12'd2582:{rom_a,rom_theta}<={9'd186,9'd367};
12'd2583:{rom_a,rom_theta}<={9'd187,9'd367};
12'd2584:{rom_a,rom_theta}<={9'd187,9'd367};
12'd2585:{rom_a,rom_theta}<={9'd187,9'd367};
12'd2586:{rom_a,rom_theta}<={9'd187,9'd367};
12'd2587:{rom_a,rom_theta}<={9'd187,9'd367};
12'd2588:{rom_a,rom_theta}<={9'd187,9'd367};
12'd2589:{rom_a,rom_theta}<={9'd187,9'd367};
12'd2590:{rom_a,rom_theta}<={9'd188,9'd368};
12'd2591:{rom_a,rom_theta}<={9'd188,9'd368};
12'd2592:{rom_a,rom_theta}<={9'd188,9'd368};
12'd2593:{rom_a,rom_theta}<={9'd188,9'd368};
12'd2594:{rom_a,rom_theta}<={9'd188,9'd368};
12'd2595:{rom_a,rom_theta}<={9'd188,9'd368};
12'd2596:{rom_a,rom_theta}<={9'd188,9'd368};
12'd2597:{rom_a,rom_theta}<={9'd188,9'd368};
12'd2598:{rom_a,rom_theta}<={9'd189,9'd368};
12'd2599:{rom_a,rom_theta}<={9'd189,9'd369};
12'd2600:{rom_a,rom_theta}<={9'd189,9'd369};
12'd2601:{rom_a,rom_theta}<={9'd189,9'd369};
12'd2602:{rom_a,rom_theta}<={9'd189,9'd369};
12'd2603:{rom_a,rom_theta}<={9'd189,9'd369};
12'd2604:{rom_a,rom_theta}<={9'd189,9'd369};
12'd2605:{rom_a,rom_theta}<={9'd190,9'd369};
12'd2606:{rom_a,rom_theta}<={9'd190,9'd369};
12'd2607:{rom_a,rom_theta}<={9'd190,9'd370};
12'd2608:{rom_a,rom_theta}<={9'd190,9'd370};
12'd2609:{rom_a,rom_theta}<={9'd190,9'd370};
12'd2610:{rom_a,rom_theta}<={9'd190,9'd370};
12'd2611:{rom_a,rom_theta}<={9'd190,9'd370};
12'd2612:{rom_a,rom_theta}<={9'd190,9'd370};
12'd2613:{rom_a,rom_theta}<={9'd191,9'd370};
12'd2614:{rom_a,rom_theta}<={9'd191,9'd370};
12'd2615:{rom_a,rom_theta}<={9'd191,9'd370};
12'd2616:{rom_a,rom_theta}<={9'd191,9'd371};
12'd2617:{rom_a,rom_theta}<={9'd191,9'd371};
12'd2618:{rom_a,rom_theta}<={9'd191,9'd371};
12'd2619:{rom_a,rom_theta}<={9'd191,9'd371};
12'd2620:{rom_a,rom_theta}<={9'd192,9'd371};
12'd2621:{rom_a,rom_theta}<={9'd192,9'd371};
12'd2622:{rom_a,rom_theta}<={9'd192,9'd371};
12'd2623:{rom_a,rom_theta}<={9'd192,9'd371};
12'd2624:{rom_a,rom_theta}<={9'd192,9'd371};
12'd2625:{rom_a,rom_theta}<={9'd192,9'd372};
12'd2626:{rom_a,rom_theta}<={9'd192,9'd372};
12'd2627:{rom_a,rom_theta}<={9'd193,9'd372};
12'd2628:{rom_a,rom_theta}<={9'd193,9'd372};
12'd2629:{rom_a,rom_theta}<={9'd193,9'd372};
12'd2630:{rom_a,rom_theta}<={9'd193,9'd372};
12'd2631:{rom_a,rom_theta}<={9'd193,9'd372};
12'd2632:{rom_a,rom_theta}<={9'd193,9'd372};
12'd2633:{rom_a,rom_theta}<={9'd193,9'd372};
12'd2634:{rom_a,rom_theta}<={9'd193,9'd373};
12'd2635:{rom_a,rom_theta}<={9'd194,9'd373};
12'd2636:{rom_a,rom_theta}<={9'd194,9'd373};
12'd2637:{rom_a,rom_theta}<={9'd194,9'd373};
12'd2638:{rom_a,rom_theta}<={9'd194,9'd373};
12'd2639:{rom_a,rom_theta}<={9'd194,9'd373};
12'd2640:{rom_a,rom_theta}<={9'd194,9'd373};
12'd2641:{rom_a,rom_theta}<={9'd194,9'd373};
12'd2642:{rom_a,rom_theta}<={9'd195,9'd373};
12'd2643:{rom_a,rom_theta}<={9'd195,9'd374};
12'd2644:{rom_a,rom_theta}<={9'd195,9'd374};
12'd2645:{rom_a,rom_theta}<={9'd195,9'd374};
12'd2646:{rom_a,rom_theta}<={9'd195,9'd374};
12'd2647:{rom_a,rom_theta}<={9'd195,9'd374};
12'd2648:{rom_a,rom_theta}<={9'd195,9'd374};
12'd2649:{rom_a,rom_theta}<={9'd195,9'd374};
12'd2650:{rom_a,rom_theta}<={9'd196,9'd374};
12'd2651:{rom_a,rom_theta}<={9'd196,9'd374};
12'd2652:{rom_a,rom_theta}<={9'd196,9'd375};
12'd2653:{rom_a,rom_theta}<={9'd196,9'd375};
12'd2654:{rom_a,rom_theta}<={9'd196,9'd375};
12'd2655:{rom_a,rom_theta}<={9'd196,9'd375};
12'd2656:{rom_a,rom_theta}<={9'd196,9'd375};
12'd2657:{rom_a,rom_theta}<={9'd197,9'd375};
12'd2658:{rom_a,rom_theta}<={9'd197,9'd375};
12'd2659:{rom_a,rom_theta}<={9'd197,9'd375};
12'd2660:{rom_a,rom_theta}<={9'd197,9'd375};
12'd2661:{rom_a,rom_theta}<={9'd197,9'd376};
12'd2662:{rom_a,rom_theta}<={9'd197,9'd376};
12'd2663:{rom_a,rom_theta}<={9'd197,9'd376};
12'd2664:{rom_a,rom_theta}<={9'd198,9'd376};
12'd2665:{rom_a,rom_theta}<={9'd198,9'd376};
12'd2666:{rom_a,rom_theta}<={9'd198,9'd376};
12'd2667:{rom_a,rom_theta}<={9'd198,9'd376};
12'd2668:{rom_a,rom_theta}<={9'd198,9'd376};
12'd2669:{rom_a,rom_theta}<={9'd198,9'd376};
12'd2670:{rom_a,rom_theta}<={9'd198,9'd377};
12'd2671:{rom_a,rom_theta}<={9'd198,9'd377};
12'd2672:{rom_a,rom_theta}<={9'd199,9'd377};
12'd2673:{rom_a,rom_theta}<={9'd199,9'd377};
12'd2674:{rom_a,rom_theta}<={9'd199,9'd377};
12'd2675:{rom_a,rom_theta}<={9'd199,9'd377};
12'd2676:{rom_a,rom_theta}<={9'd199,9'd377};
12'd2677:{rom_a,rom_theta}<={9'd199,9'd377};
12'd2678:{rom_a,rom_theta}<={9'd199,9'd377};
12'd2679:{rom_a,rom_theta}<={9'd200,9'd378};
12'd2680:{rom_a,rom_theta}<={9'd200,9'd378};
12'd2681:{rom_a,rom_theta}<={9'd200,9'd378};
12'd2682:{rom_a,rom_theta}<={9'd200,9'd378};
12'd2683:{rom_a,rom_theta}<={9'd200,9'd378};
12'd2684:{rom_a,rom_theta}<={9'd200,9'd378};
12'd2685:{rom_a,rom_theta}<={9'd200,9'd378};
12'd2686:{rom_a,rom_theta}<={9'd201,9'd378};
12'd2687:{rom_a,rom_theta}<={9'd201,9'd378};
12'd2688:{rom_a,rom_theta}<={9'd201,9'd379};
12'd2689:{rom_a,rom_theta}<={9'd201,9'd379};
12'd2690:{rom_a,rom_theta}<={9'd201,9'd379};
12'd2691:{rom_a,rom_theta}<={9'd201,9'd379};
12'd2692:{rom_a,rom_theta}<={9'd201,9'd379};
12'd2693:{rom_a,rom_theta}<={9'd201,9'd379};
12'd2694:{rom_a,rom_theta}<={9'd202,9'd379};
12'd2695:{rom_a,rom_theta}<={9'd202,9'd379};
12'd2696:{rom_a,rom_theta}<={9'd202,9'd379};
12'd2697:{rom_a,rom_theta}<={9'd202,9'd380};
12'd2698:{rom_a,rom_theta}<={9'd202,9'd380};
12'd2699:{rom_a,rom_theta}<={9'd202,9'd380};
12'd2700:{rom_a,rom_theta}<={9'd202,9'd380};
12'd2701:{rom_a,rom_theta}<={9'd203,9'd380};
12'd2702:{rom_a,rom_theta}<={9'd203,9'd380};
12'd2703:{rom_a,rom_theta}<={9'd203,9'd380};
12'd2704:{rom_a,rom_theta}<={9'd203,9'd380};
12'd2705:{rom_a,rom_theta}<={9'd203,9'd380};
12'd2706:{rom_a,rom_theta}<={9'd203,9'd381};
12'd2707:{rom_a,rom_theta}<={9'd203,9'd381};
12'd2708:{rom_a,rom_theta}<={9'd204,9'd381};
12'd2709:{rom_a,rom_theta}<={9'd204,9'd381};
12'd2710:{rom_a,rom_theta}<={9'd204,9'd381};
12'd2711:{rom_a,rom_theta}<={9'd204,9'd381};
12'd2712:{rom_a,rom_theta}<={9'd204,9'd381};
12'd2713:{rom_a,rom_theta}<={9'd204,9'd381};
12'd2714:{rom_a,rom_theta}<={9'd204,9'd381};
12'd2715:{rom_a,rom_theta}<={9'd205,9'd382};
12'd2716:{rom_a,rom_theta}<={9'd205,9'd382};
12'd2717:{rom_a,rom_theta}<={9'd205,9'd382};
12'd2718:{rom_a,rom_theta}<={9'd205,9'd382};
12'd2719:{rom_a,rom_theta}<={9'd205,9'd382};
12'd2720:{rom_a,rom_theta}<={9'd205,9'd382};
12'd2721:{rom_a,rom_theta}<={9'd205,9'd382};
12'd2722:{rom_a,rom_theta}<={9'd205,9'd382};
12'd2723:{rom_a,rom_theta}<={9'd206,9'd382};
12'd2724:{rom_a,rom_theta}<={9'd206,9'd383};
12'd2725:{rom_a,rom_theta}<={9'd206,9'd383};
12'd2726:{rom_a,rom_theta}<={9'd206,9'd383};
12'd2727:{rom_a,rom_theta}<={9'd206,9'd383};
12'd2728:{rom_a,rom_theta}<={9'd206,9'd383};
12'd2729:{rom_a,rom_theta}<={9'd206,9'd383};
12'd2730:{rom_a,rom_theta}<={9'd207,9'd383};
12'd2731:{rom_a,rom_theta}<={9'd207,9'd383};
12'd2732:{rom_a,rom_theta}<={9'd207,9'd383};
12'd2733:{rom_a,rom_theta}<={9'd207,9'd384};
12'd2734:{rom_a,rom_theta}<={9'd207,9'd384};
12'd2735:{rom_a,rom_theta}<={9'd207,9'd384};
12'd2736:{rom_a,rom_theta}<={9'd207,9'd384};
12'd2737:{rom_a,rom_theta}<={9'd208,9'd384};
12'd2738:{rom_a,rom_theta}<={9'd208,9'd384};
12'd2739:{rom_a,rom_theta}<={9'd208,9'd384};
12'd2740:{rom_a,rom_theta}<={9'd208,9'd384};
12'd2741:{rom_a,rom_theta}<={9'd208,9'd384};
12'd2742:{rom_a,rom_theta}<={9'd208,9'd385};
12'd2743:{rom_a,rom_theta}<={9'd208,9'd385};
12'd2744:{rom_a,rom_theta}<={9'd209,9'd385};
12'd2745:{rom_a,rom_theta}<={9'd209,9'd385};
12'd2746:{rom_a,rom_theta}<={9'd209,9'd385};
12'd2747:{rom_a,rom_theta}<={9'd209,9'd385};
12'd2748:{rom_a,rom_theta}<={9'd209,9'd385};
12'd2749:{rom_a,rom_theta}<={9'd209,9'd385};
12'd2750:{rom_a,rom_theta}<={9'd209,9'd385};
12'd2751:{rom_a,rom_theta}<={9'd210,9'd386};
12'd2752:{rom_a,rom_theta}<={9'd210,9'd386};
12'd2753:{rom_a,rom_theta}<={9'd210,9'd386};
12'd2754:{rom_a,rom_theta}<={9'd210,9'd386};
12'd2755:{rom_a,rom_theta}<={9'd210,9'd386};
12'd2756:{rom_a,rom_theta}<={9'd210,9'd386};
12'd2757:{rom_a,rom_theta}<={9'd210,9'd386};
12'd2758:{rom_a,rom_theta}<={9'd210,9'd386};
12'd2759:{rom_a,rom_theta}<={9'd211,9'd386};
12'd2760:{rom_a,rom_theta}<={9'd211,9'd387};
12'd2761:{rom_a,rom_theta}<={9'd211,9'd387};
12'd2762:{rom_a,rom_theta}<={9'd211,9'd387};
12'd2763:{rom_a,rom_theta}<={9'd211,9'd387};
12'd2764:{rom_a,rom_theta}<={9'd211,9'd387};
12'd2765:{rom_a,rom_theta}<={9'd211,9'd387};
12'd2766:{rom_a,rom_theta}<={9'd212,9'd387};
12'd2767:{rom_a,rom_theta}<={9'd212,9'd387};
12'd2768:{rom_a,rom_theta}<={9'd212,9'd387};
12'd2769:{rom_a,rom_theta}<={9'd212,9'd388};
12'd2770:{rom_a,rom_theta}<={9'd212,9'd388};
12'd2771:{rom_a,rom_theta}<={9'd212,9'd388};
12'd2772:{rom_a,rom_theta}<={9'd212,9'd388};
12'd2773:{rom_a,rom_theta}<={9'd213,9'd388};
12'd2774:{rom_a,rom_theta}<={9'd213,9'd388};
12'd2775:{rom_a,rom_theta}<={9'd213,9'd388};
12'd2776:{rom_a,rom_theta}<={9'd213,9'd388};
12'd2777:{rom_a,rom_theta}<={9'd213,9'd388};
12'd2778:{rom_a,rom_theta}<={9'd213,9'd389};
12'd2779:{rom_a,rom_theta}<={9'd213,9'd389};
12'd2780:{rom_a,rom_theta}<={9'd214,9'd389};
12'd2781:{rom_a,rom_theta}<={9'd214,9'd389};
12'd2782:{rom_a,rom_theta}<={9'd214,9'd389};
12'd2783:{rom_a,rom_theta}<={9'd214,9'd389};
12'd2784:{rom_a,rom_theta}<={9'd214,9'd389};
12'd2785:{rom_a,rom_theta}<={9'd214,9'd389};
12'd2786:{rom_a,rom_theta}<={9'd214,9'd389};
12'd2787:{rom_a,rom_theta}<={9'd215,9'd389};
12'd2788:{rom_a,rom_theta}<={9'd215,9'd390};
12'd2789:{rom_a,rom_theta}<={9'd215,9'd390};
12'd2790:{rom_a,rom_theta}<={9'd215,9'd390};
12'd2791:{rom_a,rom_theta}<={9'd215,9'd390};
12'd2792:{rom_a,rom_theta}<={9'd215,9'd390};
12'd2793:{rom_a,rom_theta}<={9'd215,9'd390};
12'd2794:{rom_a,rom_theta}<={9'd216,9'd390};
12'd2795:{rom_a,rom_theta}<={9'd216,9'd390};
12'd2796:{rom_a,rom_theta}<={9'd216,9'd390};
12'd2797:{rom_a,rom_theta}<={9'd216,9'd391};
12'd2798:{rom_a,rom_theta}<={9'd216,9'd391};
12'd2799:{rom_a,rom_theta}<={9'd216,9'd391};
12'd2800:{rom_a,rom_theta}<={9'd216,9'd391};
12'd2801:{rom_a,rom_theta}<={9'd217,9'd391};
12'd2802:{rom_a,rom_theta}<={9'd217,9'd391};
12'd2803:{rom_a,rom_theta}<={9'd217,9'd391};
12'd2804:{rom_a,rom_theta}<={9'd217,9'd391};
12'd2805:{rom_a,rom_theta}<={9'd217,9'd391};
12'd2806:{rom_a,rom_theta}<={9'd217,9'd392};
12'd2807:{rom_a,rom_theta}<={9'd217,9'd392};
12'd2808:{rom_a,rom_theta}<={9'd218,9'd392};
12'd2809:{rom_a,rom_theta}<={9'd218,9'd392};
12'd2810:{rom_a,rom_theta}<={9'd218,9'd392};
12'd2811:{rom_a,rom_theta}<={9'd218,9'd392};
12'd2812:{rom_a,rom_theta}<={9'd218,9'd392};
12'd2813:{rom_a,rom_theta}<={9'd218,9'd392};
12'd2814:{rom_a,rom_theta}<={9'd218,9'd392};
12'd2815:{rom_a,rom_theta}<={9'd219,9'd393};
12'd2816:{rom_a,rom_theta}<={9'd219,9'd393};
12'd2817:{rom_a,rom_theta}<={9'd219,9'd393};
12'd2818:{rom_a,rom_theta}<={9'd219,9'd393};
12'd2819:{rom_a,rom_theta}<={9'd219,9'd393};
12'd2820:{rom_a,rom_theta}<={9'd219,9'd393};
12'd2821:{rom_a,rom_theta}<={9'd219,9'd393};
12'd2822:{rom_a,rom_theta}<={9'd220,9'd393};
12'd2823:{rom_a,rom_theta}<={9'd220,9'd393};
12'd2824:{rom_a,rom_theta}<={9'd220,9'd393};
12'd2825:{rom_a,rom_theta}<={9'd220,9'd394};
12'd2826:{rom_a,rom_theta}<={9'd220,9'd394};
12'd2827:{rom_a,rom_theta}<={9'd220,9'd394};
12'd2828:{rom_a,rom_theta}<={9'd220,9'd394};
12'd2829:{rom_a,rom_theta}<={9'd220,9'd394};
12'd2830:{rom_a,rom_theta}<={9'd221,9'd394};
12'd2831:{rom_a,rom_theta}<={9'd221,9'd394};
12'd2832:{rom_a,rom_theta}<={9'd221,9'd394};
12'd2833:{rom_a,rom_theta}<={9'd221,9'd394};
12'd2834:{rom_a,rom_theta}<={9'd221,9'd395};
12'd2835:{rom_a,rom_theta}<={9'd221,9'd395};
12'd2836:{rom_a,rom_theta}<={9'd221,9'd395};
12'd2837:{rom_a,rom_theta}<={9'd222,9'd395};
12'd2838:{rom_a,rom_theta}<={9'd222,9'd395};
12'd2839:{rom_a,rom_theta}<={9'd222,9'd395};
12'd2840:{rom_a,rom_theta}<={9'd222,9'd395};
12'd2841:{rom_a,rom_theta}<={9'd222,9'd395};
12'd2842:{rom_a,rom_theta}<={9'd222,9'd395};
12'd2843:{rom_a,rom_theta}<={9'd222,9'd396};
12'd2844:{rom_a,rom_theta}<={9'd223,9'd396};
12'd2845:{rom_a,rom_theta}<={9'd223,9'd396};
12'd2846:{rom_a,rom_theta}<={9'd223,9'd396};
12'd2847:{rom_a,rom_theta}<={9'd223,9'd396};
12'd2848:{rom_a,rom_theta}<={9'd223,9'd396};
12'd2849:{rom_a,rom_theta}<={9'd223,9'd396};
12'd2850:{rom_a,rom_theta}<={9'd223,9'd396};
12'd2851:{rom_a,rom_theta}<={9'd224,9'd396};
12'd2852:{rom_a,rom_theta}<={9'd224,9'd397};
12'd2853:{rom_a,rom_theta}<={9'd224,9'd397};
12'd2854:{rom_a,rom_theta}<={9'd224,9'd397};
12'd2855:{rom_a,rom_theta}<={9'd224,9'd397};
12'd2856:{rom_a,rom_theta}<={9'd224,9'd397};
12'd2857:{rom_a,rom_theta}<={9'd224,9'd397};
12'd2858:{rom_a,rom_theta}<={9'd225,9'd397};
12'd2859:{rom_a,rom_theta}<={9'd225,9'd397};
12'd2860:{rom_a,rom_theta}<={9'd225,9'd397};
12'd2861:{rom_a,rom_theta}<={9'd225,9'd397};
12'd2862:{rom_a,rom_theta}<={9'd225,9'd398};
12'd2863:{rom_a,rom_theta}<={9'd225,9'd398};
12'd2864:{rom_a,rom_theta}<={9'd225,9'd398};
12'd2865:{rom_a,rom_theta}<={9'd226,9'd398};
12'd2866:{rom_a,rom_theta}<={9'd226,9'd398};
12'd2867:{rom_a,rom_theta}<={9'd226,9'd398};
12'd2868:{rom_a,rom_theta}<={9'd226,9'd398};
12'd2869:{rom_a,rom_theta}<={9'd226,9'd398};
12'd2870:{rom_a,rom_theta}<={9'd226,9'd398};
12'd2871:{rom_a,rom_theta}<={9'd226,9'd399};
12'd2872:{rom_a,rom_theta}<={9'd227,9'd399};
12'd2873:{rom_a,rom_theta}<={9'd227,9'd399};
12'd2874:{rom_a,rom_theta}<={9'd227,9'd399};
12'd2875:{rom_a,rom_theta}<={9'd227,9'd399};
12'd2876:{rom_a,rom_theta}<={9'd227,9'd399};
12'd2877:{rom_a,rom_theta}<={9'd227,9'd399};
12'd2878:{rom_a,rom_theta}<={9'd228,9'd399};
12'd2879:{rom_a,rom_theta}<={9'd228,9'd399};
12'd2880:{rom_a,rom_theta}<={9'd228,9'd399};
12'd2881:{rom_a,rom_theta}<={9'd228,9'd400};
12'd2882:{rom_a,rom_theta}<={9'd228,9'd400};
12'd2883:{rom_a,rom_theta}<={9'd228,9'd400};
12'd2884:{rom_a,rom_theta}<={9'd228,9'd400};
12'd2885:{rom_a,rom_theta}<={9'd229,9'd400};
12'd2886:{rom_a,rom_theta}<={9'd229,9'd400};
12'd2887:{rom_a,rom_theta}<={9'd229,9'd400};
12'd2888:{rom_a,rom_theta}<={9'd229,9'd400};
12'd2889:{rom_a,rom_theta}<={9'd229,9'd400};
12'd2890:{rom_a,rom_theta}<={9'd229,9'd401};
12'd2891:{rom_a,rom_theta}<={9'd229,9'd401};
12'd2892:{rom_a,rom_theta}<={9'd230,9'd401};
12'd2893:{rom_a,rom_theta}<={9'd230,9'd401};
12'd2894:{rom_a,rom_theta}<={9'd230,9'd401};
12'd2895:{rom_a,rom_theta}<={9'd230,9'd401};
12'd2896:{rom_a,rom_theta}<={9'd230,9'd401};
12'd2897:{rom_a,rom_theta}<={9'd230,9'd401};
12'd2898:{rom_a,rom_theta}<={9'd230,9'd401};
12'd2899:{rom_a,rom_theta}<={9'd231,9'd402};
12'd2900:{rom_a,rom_theta}<={9'd231,9'd402};
12'd2901:{rom_a,rom_theta}<={9'd231,9'd402};
12'd2902:{rom_a,rom_theta}<={9'd231,9'd402};
12'd2903:{rom_a,rom_theta}<={9'd231,9'd402};
12'd2904:{rom_a,rom_theta}<={9'd231,9'd402};
12'd2905:{rom_a,rom_theta}<={9'd231,9'd402};
12'd2906:{rom_a,rom_theta}<={9'd232,9'd402};
12'd2907:{rom_a,rom_theta}<={9'd232,9'd402};
12'd2908:{rom_a,rom_theta}<={9'd232,9'd402};
12'd2909:{rom_a,rom_theta}<={9'd232,9'd403};
12'd2910:{rom_a,rom_theta}<={9'd232,9'd403};
12'd2911:{rom_a,rom_theta}<={9'd232,9'd403};
12'd2912:{rom_a,rom_theta}<={9'd232,9'd403};
12'd2913:{rom_a,rom_theta}<={9'd233,9'd403};
12'd2914:{rom_a,rom_theta}<={9'd233,9'd403};
12'd2915:{rom_a,rom_theta}<={9'd233,9'd403};
12'd2916:{rom_a,rom_theta}<={9'd233,9'd403};
12'd2917:{rom_a,rom_theta}<={9'd233,9'd403};
12'd2918:{rom_a,rom_theta}<={9'd233,9'd404};
12'd2919:{rom_a,rom_theta}<={9'd233,9'd404};
12'd2920:{rom_a,rom_theta}<={9'd234,9'd404};
12'd2921:{rom_a,rom_theta}<={9'd234,9'd404};
12'd2922:{rom_a,rom_theta}<={9'd234,9'd404};
12'd2923:{rom_a,rom_theta}<={9'd234,9'd404};
12'd2924:{rom_a,rom_theta}<={9'd234,9'd404};
12'd2925:{rom_a,rom_theta}<={9'd234,9'd404};
12'd2926:{rom_a,rom_theta}<={9'd234,9'd404};
12'd2927:{rom_a,rom_theta}<={9'd235,9'd404};
12'd2928:{rom_a,rom_theta}<={9'd235,9'd405};
12'd2929:{rom_a,rom_theta}<={9'd235,9'd405};
12'd2930:{rom_a,rom_theta}<={9'd235,9'd405};
12'd2931:{rom_a,rom_theta}<={9'd235,9'd405};
12'd2932:{rom_a,rom_theta}<={9'd235,9'd405};
12'd2933:{rom_a,rom_theta}<={9'd235,9'd405};
12'd2934:{rom_a,rom_theta}<={9'd236,9'd405};
12'd2935:{rom_a,rom_theta}<={9'd236,9'd405};
12'd2936:{rom_a,rom_theta}<={9'd236,9'd405};
12'd2937:{rom_a,rom_theta}<={9'd236,9'd406};
12'd2938:{rom_a,rom_theta}<={9'd236,9'd406};
12'd2939:{rom_a,rom_theta}<={9'd236,9'd406};
12'd2940:{rom_a,rom_theta}<={9'd236,9'd406};
12'd2941:{rom_a,rom_theta}<={9'd237,9'd406};
12'd2942:{rom_a,rom_theta}<={9'd237,9'd406};
12'd2943:{rom_a,rom_theta}<={9'd237,9'd406};
12'd2944:{rom_a,rom_theta}<={9'd237,9'd406};
12'd2945:{rom_a,rom_theta}<={9'd237,9'd406};
12'd2946:{rom_a,rom_theta}<={9'd237,9'd406};
12'd2947:{rom_a,rom_theta}<={9'd237,9'd407};
12'd2948:{rom_a,rom_theta}<={9'd238,9'd407};
12'd2949:{rom_a,rom_theta}<={9'd238,9'd407};
12'd2950:{rom_a,rom_theta}<={9'd238,9'd407};
12'd2951:{rom_a,rom_theta}<={9'd238,9'd407};
12'd2952:{rom_a,rom_theta}<={9'd238,9'd407};
12'd2953:{rom_a,rom_theta}<={9'd238,9'd407};
12'd2954:{rom_a,rom_theta}<={9'd239,9'd407};
12'd2955:{rom_a,rom_theta}<={9'd239,9'd407};
12'd2956:{rom_a,rom_theta}<={9'd239,9'd408};
12'd2957:{rom_a,rom_theta}<={9'd239,9'd408};
12'd2958:{rom_a,rom_theta}<={9'd239,9'd408};
12'd2959:{rom_a,rom_theta}<={9'd239,9'd408};
12'd2960:{rom_a,rom_theta}<={9'd239,9'd408};
12'd2961:{rom_a,rom_theta}<={9'd240,9'd408};
12'd2962:{rom_a,rom_theta}<={9'd240,9'd408};
12'd2963:{rom_a,rom_theta}<={9'd240,9'd408};
12'd2964:{rom_a,rom_theta}<={9'd240,9'd408};
12'd2965:{rom_a,rom_theta}<={9'd240,9'd408};
12'd2966:{rom_a,rom_theta}<={9'd240,9'd409};
12'd2967:{rom_a,rom_theta}<={9'd240,9'd409};
12'd2968:{rom_a,rom_theta}<={9'd241,9'd409};
12'd2969:{rom_a,rom_theta}<={9'd241,9'd409};
12'd2970:{rom_a,rom_theta}<={9'd241,9'd409};
12'd2971:{rom_a,rom_theta}<={9'd241,9'd409};
12'd2972:{rom_a,rom_theta}<={9'd241,9'd409};
12'd2973:{rom_a,rom_theta}<={9'd241,9'd409};
12'd2974:{rom_a,rom_theta}<={9'd241,9'd409};
12'd2975:{rom_a,rom_theta}<={9'd242,9'd410};
12'd2976:{rom_a,rom_theta}<={9'd242,9'd410};
12'd2977:{rom_a,rom_theta}<={9'd242,9'd410};
12'd2978:{rom_a,rom_theta}<={9'd242,9'd410};
12'd2979:{rom_a,rom_theta}<={9'd242,9'd410};
12'd2980:{rom_a,rom_theta}<={9'd242,9'd410};
12'd2981:{rom_a,rom_theta}<={9'd242,9'd410};
12'd2982:{rom_a,rom_theta}<={9'd243,9'd410};
12'd2983:{rom_a,rom_theta}<={9'd243,9'd410};
12'd2984:{rom_a,rom_theta}<={9'd243,9'd410};
12'd2985:{rom_a,rom_theta}<={9'd243,9'd411};
12'd2986:{rom_a,rom_theta}<={9'd243,9'd411};
12'd2987:{rom_a,rom_theta}<={9'd243,9'd411};
12'd2988:{rom_a,rom_theta}<={9'd244,9'd411};
12'd2989:{rom_a,rom_theta}<={9'd244,9'd411};
12'd2990:{rom_a,rom_theta}<={9'd244,9'd411};
12'd2991:{rom_a,rom_theta}<={9'd244,9'd411};
12'd2992:{rom_a,rom_theta}<={9'd244,9'd411};
12'd2993:{rom_a,rom_theta}<={9'd244,9'd411};
12'd2994:{rom_a,rom_theta}<={9'd244,9'd411};
12'd2995:{rom_a,rom_theta}<={9'd245,9'd412};
12'd2996:{rom_a,rom_theta}<={9'd245,9'd412};
12'd2997:{rom_a,rom_theta}<={9'd245,9'd412};
12'd2998:{rom_a,rom_theta}<={9'd245,9'd412};
12'd2999:{rom_a,rom_theta}<={9'd245,9'd412};
12'd3000:{rom_a,rom_theta}<={9'd245,9'd412};
12'd3001:{rom_a,rom_theta}<={9'd245,9'd412};
12'd3002:{rom_a,rom_theta}<={9'd246,9'd412};
12'd3003:{rom_a,rom_theta}<={9'd246,9'd412};
12'd3004:{rom_a,rom_theta}<={9'd246,9'd413};
12'd3005:{rom_a,rom_theta}<={9'd246,9'd413};
12'd3006:{rom_a,rom_theta}<={9'd246,9'd413};
12'd3007:{rom_a,rom_theta}<={9'd246,9'd413};
12'd3008:{rom_a,rom_theta}<={9'd246,9'd413};
12'd3009:{rom_a,rom_theta}<={9'd247,9'd413};
12'd3010:{rom_a,rom_theta}<={9'd247,9'd413};
12'd3011:{rom_a,rom_theta}<={9'd247,9'd413};
12'd3012:{rom_a,rom_theta}<={9'd247,9'd413};
12'd3013:{rom_a,rom_theta}<={9'd247,9'd413};
12'd3014:{rom_a,rom_theta}<={9'd247,9'd414};
12'd3015:{rom_a,rom_theta}<={9'd248,9'd414};
12'd3016:{rom_a,rom_theta}<={9'd248,9'd414};
12'd3017:{rom_a,rom_theta}<={9'd248,9'd414};
12'd3018:{rom_a,rom_theta}<={9'd248,9'd414};
12'd3019:{rom_a,rom_theta}<={9'd248,9'd414};
12'd3020:{rom_a,rom_theta}<={9'd248,9'd414};
12'd3021:{rom_a,rom_theta}<={9'd248,9'd414};
12'd3022:{rom_a,rom_theta}<={9'd249,9'd414};
12'd3023:{rom_a,rom_theta}<={9'd249,9'd414};
12'd3024:{rom_a,rom_theta}<={9'd249,9'd415};
12'd3025:{rom_a,rom_theta}<={9'd249,9'd415};
12'd3026:{rom_a,rom_theta}<={9'd249,9'd415};
12'd3027:{rom_a,rom_theta}<={9'd249,9'd415};
12'd3028:{rom_a,rom_theta}<={9'd249,9'd415};
12'd3029:{rom_a,rom_theta}<={9'd250,9'd415};
12'd3030:{rom_a,rom_theta}<={9'd250,9'd415};
12'd3031:{rom_a,rom_theta}<={9'd250,9'd415};
12'd3032:{rom_a,rom_theta}<={9'd250,9'd415};
12'd3033:{rom_a,rom_theta}<={9'd250,9'd416};
12'd3034:{rom_a,rom_theta}<={9'd250,9'd416};
12'd3035:{rom_a,rom_theta}<={9'd250,9'd416};
12'd3036:{rom_a,rom_theta}<={9'd251,9'd416};
12'd3037:{rom_a,rom_theta}<={9'd251,9'd416};
12'd3038:{rom_a,rom_theta}<={9'd251,9'd416};
12'd3039:{rom_a,rom_theta}<={9'd251,9'd416};
12'd3040:{rom_a,rom_theta}<={9'd251,9'd416};
12'd3041:{rom_a,rom_theta}<={9'd251,9'd416};
12'd3042:{rom_a,rom_theta}<={9'd252,9'd416};
12'd3043:{rom_a,rom_theta}<={9'd252,9'd417};
12'd3044:{rom_a,rom_theta}<={9'd252,9'd417};
12'd3045:{rom_a,rom_theta}<={9'd252,9'd417};
12'd3046:{rom_a,rom_theta}<={9'd252,9'd417};
12'd3047:{rom_a,rom_theta}<={9'd252,9'd417};
12'd3048:{rom_a,rom_theta}<={9'd252,9'd417};
12'd3049:{rom_a,rom_theta}<={9'd253,9'd417};
12'd3050:{rom_a,rom_theta}<={9'd253,9'd417};
12'd3051:{rom_a,rom_theta}<={9'd253,9'd417};
12'd3052:{rom_a,rom_theta}<={9'd253,9'd417};
12'd3053:{rom_a,rom_theta}<={9'd253,9'd418};
12'd3054:{rom_a,rom_theta}<={9'd253,9'd418};
12'd3055:{rom_a,rom_theta}<={9'd253,9'd418};
12'd3056:{rom_a,rom_theta}<={9'd254,9'd418};
12'd3057:{rom_a,rom_theta}<={9'd254,9'd418};
12'd3058:{rom_a,rom_theta}<={9'd254,9'd418};
12'd3059:{rom_a,rom_theta}<={9'd254,9'd418};
12'd3060:{rom_a,rom_theta}<={9'd254,9'd418};
12'd3061:{rom_a,rom_theta}<={9'd254,9'd418};
12'd3062:{rom_a,rom_theta}<={9'd255,9'd418};
12'd3063:{rom_a,rom_theta}<={9'd255,9'd419};
12'd3064:{rom_a,rom_theta}<={9'd255,9'd419};
12'd3065:{rom_a,rom_theta}<={9'd255,9'd419};
12'd3066:{rom_a,rom_theta}<={9'd255,9'd419};
12'd3067:{rom_a,rom_theta}<={9'd255,9'd419};
12'd3068:{rom_a,rom_theta}<={9'd255,9'd419};
12'd3069:{rom_a,rom_theta}<={9'd256,9'd419};
12'd3070:{rom_a,rom_theta}<={9'd256,9'd419};
12'd3071:{rom_a,rom_theta}<={9'd256,9'd419};
12'd3072:{rom_a,rom_theta}<={9'd256,9'd419};
12'd3073:{rom_a,rom_theta}<={9'd256,9'd420};
12'd3074:{rom_a,rom_theta}<={9'd256,9'd420};
12'd3075:{rom_a,rom_theta}<={9'd256,9'd420};
12'd3076:{rom_a,rom_theta}<={9'd257,9'd420};
12'd3077:{rom_a,rom_theta}<={9'd257,9'd420};
12'd3078:{rom_a,rom_theta}<={9'd257,9'd420};
12'd3079:{rom_a,rom_theta}<={9'd257,9'd420};
12'd3080:{rom_a,rom_theta}<={9'd257,9'd420};
12'd3081:{rom_a,rom_theta}<={9'd257,9'd420};
12'd3082:{rom_a,rom_theta}<={9'd258,9'd421};
12'd3083:{rom_a,rom_theta}<={9'd258,9'd421};
12'd3084:{rom_a,rom_theta}<={9'd258,9'd421};
12'd3085:{rom_a,rom_theta}<={9'd258,9'd421};
12'd3086:{rom_a,rom_theta}<={9'd258,9'd421};
12'd3087:{rom_a,rom_theta}<={9'd258,9'd421};
12'd3088:{rom_a,rom_theta}<={9'd258,9'd421};
12'd3089:{rom_a,rom_theta}<={9'd259,9'd421};
12'd3090:{rom_a,rom_theta}<={9'd259,9'd421};
12'd3091:{rom_a,rom_theta}<={9'd259,9'd421};
12'd3092:{rom_a,rom_theta}<={9'd259,9'd422};
12'd3093:{rom_a,rom_theta}<={9'd259,9'd422};
12'd3094:{rom_a,rom_theta}<={9'd259,9'd422};
12'd3095:{rom_a,rom_theta}<={9'd259,9'd422};
12'd3096:{rom_a,rom_theta}<={9'd260,9'd422};
12'd3097:{rom_a,rom_theta}<={9'd260,9'd422};
12'd3098:{rom_a,rom_theta}<={9'd260,9'd422};
12'd3099:{rom_a,rom_theta}<={9'd260,9'd422};
12'd3100:{rom_a,rom_theta}<={9'd260,9'd422};
12'd3101:{rom_a,rom_theta}<={9'd260,9'd422};
12'd3102:{rom_a,rom_theta}<={9'd261,9'd423};
12'd3103:{rom_a,rom_theta}<={9'd261,9'd423};
12'd3104:{rom_a,rom_theta}<={9'd261,9'd423};
12'd3105:{rom_a,rom_theta}<={9'd261,9'd423};
12'd3106:{rom_a,rom_theta}<={9'd261,9'd423};
12'd3107:{rom_a,rom_theta}<={9'd261,9'd423};
12'd3108:{rom_a,rom_theta}<={9'd261,9'd423};
12'd3109:{rom_a,rom_theta}<={9'd262,9'd423};
12'd3110:{rom_a,rom_theta}<={9'd262,9'd423};
12'd3111:{rom_a,rom_theta}<={9'd262,9'd423};
12'd3112:{rom_a,rom_theta}<={9'd262,9'd424};
12'd3113:{rom_a,rom_theta}<={9'd262,9'd424};
12'd3114:{rom_a,rom_theta}<={9'd262,9'd424};
12'd3115:{rom_a,rom_theta}<={9'd262,9'd424};
12'd3116:{rom_a,rom_theta}<={9'd263,9'd424};
12'd3117:{rom_a,rom_theta}<={9'd263,9'd424};
12'd3118:{rom_a,rom_theta}<={9'd263,9'd424};
12'd3119:{rom_a,rom_theta}<={9'd263,9'd424};
12'd3120:{rom_a,rom_theta}<={9'd263,9'd424};
12'd3121:{rom_a,rom_theta}<={9'd263,9'd424};
12'd3122:{rom_a,rom_theta}<={9'd264,9'd425};
12'd3123:{rom_a,rom_theta}<={9'd264,9'd425};
12'd3124:{rom_a,rom_theta}<={9'd264,9'd425};
12'd3125:{rom_a,rom_theta}<={9'd264,9'd425};
12'd3126:{rom_a,rom_theta}<={9'd264,9'd425};
12'd3127:{rom_a,rom_theta}<={9'd264,9'd425};
12'd3128:{rom_a,rom_theta}<={9'd264,9'd425};
12'd3129:{rom_a,rom_theta}<={9'd265,9'd425};
12'd3130:{rom_a,rom_theta}<={9'd265,9'd425};
12'd3131:{rom_a,rom_theta}<={9'd265,9'd425};
12'd3132:{rom_a,rom_theta}<={9'd265,9'd426};
12'd3133:{rom_a,rom_theta}<={9'd265,9'd426};
12'd3134:{rom_a,rom_theta}<={9'd265,9'd426};
12'd3135:{rom_a,rom_theta}<={9'd266,9'd426};
12'd3136:{rom_a,rom_theta}<={9'd266,9'd426};
12'd3137:{rom_a,rom_theta}<={9'd266,9'd426};
12'd3138:{rom_a,rom_theta}<={9'd266,9'd426};
12'd3139:{rom_a,rom_theta}<={9'd266,9'd426};
12'd3140:{rom_a,rom_theta}<={9'd266,9'd426};
12'd3141:{rom_a,rom_theta}<={9'd266,9'd426};
12'd3142:{rom_a,rom_theta}<={9'd267,9'd427};
12'd3143:{rom_a,rom_theta}<={9'd267,9'd427};
12'd3144:{rom_a,rom_theta}<={9'd267,9'd427};
12'd3145:{rom_a,rom_theta}<={9'd267,9'd427};
12'd3146:{rom_a,rom_theta}<={9'd267,9'd427};
12'd3147:{rom_a,rom_theta}<={9'd267,9'd427};
12'd3148:{rom_a,rom_theta}<={9'd267,9'd427};
12'd3149:{rom_a,rom_theta}<={9'd268,9'd427};
12'd3150:{rom_a,rom_theta}<={9'd268,9'd427};
12'd3151:{rom_a,rom_theta}<={9'd268,9'd427};
12'd3152:{rom_a,rom_theta}<={9'd268,9'd428};
12'd3153:{rom_a,rom_theta}<={9'd268,9'd428};
12'd3154:{rom_a,rom_theta}<={9'd268,9'd428};
12'd3155:{rom_a,rom_theta}<={9'd269,9'd428};
12'd3156:{rom_a,rom_theta}<={9'd269,9'd428};
12'd3157:{rom_a,rom_theta}<={9'd269,9'd428};
12'd3158:{rom_a,rom_theta}<={9'd269,9'd428};
12'd3159:{rom_a,rom_theta}<={9'd269,9'd428};
12'd3160:{rom_a,rom_theta}<={9'd269,9'd428};
12'd3161:{rom_a,rom_theta}<={9'd269,9'd428};
12'd3162:{rom_a,rom_theta}<={9'd270,9'd429};
12'd3163:{rom_a,rom_theta}<={9'd270,9'd429};
12'd3164:{rom_a,rom_theta}<={9'd270,9'd429};
12'd3165:{rom_a,rom_theta}<={9'd270,9'd429};
12'd3166:{rom_a,rom_theta}<={9'd270,9'd429};
12'd3167:{rom_a,rom_theta}<={9'd270,9'd429};
12'd3168:{rom_a,rom_theta}<={9'd271,9'd429};
12'd3169:{rom_a,rom_theta}<={9'd271,9'd429};
12'd3170:{rom_a,rom_theta}<={9'd271,9'd429};
12'd3171:{rom_a,rom_theta}<={9'd271,9'd429};
12'd3172:{rom_a,rom_theta}<={9'd271,9'd430};
12'd3173:{rom_a,rom_theta}<={9'd271,9'd430};
12'd3174:{rom_a,rom_theta}<={9'd271,9'd430};
12'd3175:{rom_a,rom_theta}<={9'd272,9'd430};
12'd3176:{rom_a,rom_theta}<={9'd272,9'd430};
12'd3177:{rom_a,rom_theta}<={9'd272,9'd430};
12'd3178:{rom_a,rom_theta}<={9'd272,9'd430};
12'd3179:{rom_a,rom_theta}<={9'd272,9'd430};
12'd3180:{rom_a,rom_theta}<={9'd272,9'd430};
12'd3181:{rom_a,rom_theta}<={9'd273,9'd430};
12'd3182:{rom_a,rom_theta}<={9'd273,9'd431};
12'd3183:{rom_a,rom_theta}<={9'd273,9'd431};
12'd3184:{rom_a,rom_theta}<={9'd273,9'd431};
12'd3185:{rom_a,rom_theta}<={9'd273,9'd431};
12'd3186:{rom_a,rom_theta}<={9'd273,9'd431};
12'd3187:{rom_a,rom_theta}<={9'd273,9'd431};
12'd3188:{rom_a,rom_theta}<={9'd274,9'd431};
12'd3189:{rom_a,rom_theta}<={9'd274,9'd431};
12'd3190:{rom_a,rom_theta}<={9'd274,9'd431};
12'd3191:{rom_a,rom_theta}<={9'd274,9'd431};
12'd3192:{rom_a,rom_theta}<={9'd274,9'd432};
12'd3193:{rom_a,rom_theta}<={9'd274,9'd432};
12'd3194:{rom_a,rom_theta}<={9'd275,9'd432};
12'd3195:{rom_a,rom_theta}<={9'd275,9'd432};
12'd3196:{rom_a,rom_theta}<={9'd275,9'd432};
12'd3197:{rom_a,rom_theta}<={9'd275,9'd432};
12'd3198:{rom_a,rom_theta}<={9'd275,9'd432};
12'd3199:{rom_a,rom_theta}<={9'd275,9'd432};
12'd3200:{rom_a,rom_theta}<={9'd275,9'd432};
12'd3201:{rom_a,rom_theta}<={9'd276,9'd432};
12'd3202:{rom_a,rom_theta}<={9'd276,9'd433};
12'd3203:{rom_a,rom_theta}<={9'd276,9'd433};
12'd3204:{rom_a,rom_theta}<={9'd276,9'd433};
12'd3205:{rom_a,rom_theta}<={9'd276,9'd433};
12'd3206:{rom_a,rom_theta}<={9'd276,9'd433};
12'd3207:{rom_a,rom_theta}<={9'd277,9'd433};
12'd3208:{rom_a,rom_theta}<={9'd277,9'd433};
12'd3209:{rom_a,rom_theta}<={9'd277,9'd433};
12'd3210:{rom_a,rom_theta}<={9'd277,9'd433};
12'd3211:{rom_a,rom_theta}<={9'd277,9'd433};
12'd3212:{rom_a,rom_theta}<={9'd277,9'd434};
12'd3213:{rom_a,rom_theta}<={9'd277,9'd434};
12'd3214:{rom_a,rom_theta}<={9'd278,9'd434};
12'd3215:{rom_a,rom_theta}<={9'd278,9'd434};
12'd3216:{rom_a,rom_theta}<={9'd278,9'd434};
12'd3217:{rom_a,rom_theta}<={9'd278,9'd434};
12'd3218:{rom_a,rom_theta}<={9'd278,9'd434};
12'd3219:{rom_a,rom_theta}<={9'd278,9'd434};
12'd3220:{rom_a,rom_theta}<={9'd279,9'd434};
12'd3221:{rom_a,rom_theta}<={9'd279,9'd434};
12'd3222:{rom_a,rom_theta}<={9'd279,9'd435};
12'd3223:{rom_a,rom_theta}<={9'd279,9'd435};
12'd3224:{rom_a,rom_theta}<={9'd279,9'd435};
12'd3225:{rom_a,rom_theta}<={9'd279,9'd435};
12'd3226:{rom_a,rom_theta}<={9'd279,9'd435};
12'd3227:{rom_a,rom_theta}<={9'd280,9'd435};
12'd3228:{rom_a,rom_theta}<={9'd280,9'd435};
12'd3229:{rom_a,rom_theta}<={9'd280,9'd435};
12'd3230:{rom_a,rom_theta}<={9'd280,9'd435};
12'd3231:{rom_a,rom_theta}<={9'd280,9'd435};
12'd3232:{rom_a,rom_theta}<={9'd280,9'd435};
12'd3233:{rom_a,rom_theta}<={9'd281,9'd436};
12'd3234:{rom_a,rom_theta}<={9'd281,9'd436};
12'd3235:{rom_a,rom_theta}<={9'd281,9'd436};
12'd3236:{rom_a,rom_theta}<={9'd281,9'd436};
12'd3237:{rom_a,rom_theta}<={9'd281,9'd436};
12'd3238:{rom_a,rom_theta}<={9'd281,9'd436};
12'd3239:{rom_a,rom_theta}<={9'd281,9'd436};
12'd3240:{rom_a,rom_theta}<={9'd282,9'd436};
12'd3241:{rom_a,rom_theta}<={9'd282,9'd436};
12'd3242:{rom_a,rom_theta}<={9'd282,9'd436};
12'd3243:{rom_a,rom_theta}<={9'd282,9'd437};
12'd3244:{rom_a,rom_theta}<={9'd282,9'd437};
12'd3245:{rom_a,rom_theta}<={9'd282,9'd437};
12'd3246:{rom_a,rom_theta}<={9'd283,9'd437};
12'd3247:{rom_a,rom_theta}<={9'd283,9'd437};
12'd3248:{rom_a,rom_theta}<={9'd283,9'd437};
12'd3249:{rom_a,rom_theta}<={9'd283,9'd437};
12'd3250:{rom_a,rom_theta}<={9'd283,9'd437};
12'd3251:{rom_a,rom_theta}<={9'd283,9'd437};
12'd3252:{rom_a,rom_theta}<={9'd283,9'd437};
12'd3253:{rom_a,rom_theta}<={9'd284,9'd438};
12'd3254:{rom_a,rom_theta}<={9'd284,9'd438};
12'd3255:{rom_a,rom_theta}<={9'd284,9'd438};
12'd3256:{rom_a,rom_theta}<={9'd284,9'd438};
12'd3257:{rom_a,rom_theta}<={9'd284,9'd438};
12'd3258:{rom_a,rom_theta}<={9'd284,9'd438};
12'd3259:{rom_a,rom_theta}<={9'd285,9'd438};
12'd3260:{rom_a,rom_theta}<={9'd285,9'd438};
12'd3261:{rom_a,rom_theta}<={9'd285,9'd438};
12'd3262:{rom_a,rom_theta}<={9'd285,9'd438};
12'd3263:{rom_a,rom_theta}<={9'd285,9'd439};
12'd3264:{rom_a,rom_theta}<={9'd285,9'd439};
12'd3265:{rom_a,rom_theta}<={9'd286,9'd439};
12'd3266:{rom_a,rom_theta}<={9'd286,9'd439};
12'd3267:{rom_a,rom_theta}<={9'd286,9'd439};
12'd3268:{rom_a,rom_theta}<={9'd286,9'd439};
12'd3269:{rom_a,rom_theta}<={9'd286,9'd439};
12'd3270:{rom_a,rom_theta}<={9'd286,9'd439};
12'd3271:{rom_a,rom_theta}<={9'd286,9'd439};
12'd3272:{rom_a,rom_theta}<={9'd287,9'd439};
12'd3273:{rom_a,rom_theta}<={9'd287,9'd439};
12'd3274:{rom_a,rom_theta}<={9'd287,9'd440};
12'd3275:{rom_a,rom_theta}<={9'd287,9'd440};
12'd3276:{rom_a,rom_theta}<={9'd287,9'd440};
12'd3277:{rom_a,rom_theta}<={9'd287,9'd440};
12'd3278:{rom_a,rom_theta}<={9'd288,9'd440};
12'd3279:{rom_a,rom_theta}<={9'd288,9'd440};
12'd3280:{rom_a,rom_theta}<={9'd288,9'd440};
12'd3281:{rom_a,rom_theta}<={9'd288,9'd440};
12'd3282:{rom_a,rom_theta}<={9'd288,9'd440};
12'd3283:{rom_a,rom_theta}<={9'd288,9'd440};
12'd3284:{rom_a,rom_theta}<={9'd288,9'd441};
12'd3285:{rom_a,rom_theta}<={9'd289,9'd441};
12'd3286:{rom_a,rom_theta}<={9'd289,9'd441};
12'd3287:{rom_a,rom_theta}<={9'd289,9'd441};
12'd3288:{rom_a,rom_theta}<={9'd289,9'd441};
12'd3289:{rom_a,rom_theta}<={9'd289,9'd441};
12'd3290:{rom_a,rom_theta}<={9'd289,9'd441};
12'd3291:{rom_a,rom_theta}<={9'd290,9'd441};
12'd3292:{rom_a,rom_theta}<={9'd290,9'd441};
12'd3293:{rom_a,rom_theta}<={9'd290,9'd441};
12'd3294:{rom_a,rom_theta}<={9'd290,9'd442};
12'd3295:{rom_a,rom_theta}<={9'd290,9'd442};
12'd3296:{rom_a,rom_theta}<={9'd290,9'd442};
12'd3297:{rom_a,rom_theta}<={9'd291,9'd442};
12'd3298:{rom_a,rom_theta}<={9'd291,9'd442};
12'd3299:{rom_a,rom_theta}<={9'd291,9'd442};
12'd3300:{rom_a,rom_theta}<={9'd291,9'd442};
12'd3301:{rom_a,rom_theta}<={9'd291,9'd442};
12'd3302:{rom_a,rom_theta}<={9'd291,9'd442};
12'd3303:{rom_a,rom_theta}<={9'd291,9'd442};
12'd3304:{rom_a,rom_theta}<={9'd292,9'd442};
12'd3305:{rom_a,rom_theta}<={9'd292,9'd443};
12'd3306:{rom_a,rom_theta}<={9'd292,9'd443};
12'd3307:{rom_a,rom_theta}<={9'd292,9'd443};
12'd3308:{rom_a,rom_theta}<={9'd292,9'd443};
12'd3309:{rom_a,rom_theta}<={9'd292,9'd443};
12'd3310:{rom_a,rom_theta}<={9'd293,9'd443};
12'd3311:{rom_a,rom_theta}<={9'd293,9'd443};
12'd3312:{rom_a,rom_theta}<={9'd293,9'd443};
12'd3313:{rom_a,rom_theta}<={9'd293,9'd443};
12'd3314:{rom_a,rom_theta}<={9'd293,9'd443};
12'd3315:{rom_a,rom_theta}<={9'd293,9'd444};
12'd3316:{rom_a,rom_theta}<={9'd294,9'd444};
12'd3317:{rom_a,rom_theta}<={9'd294,9'd444};
12'd3318:{rom_a,rom_theta}<={9'd294,9'd444};
12'd3319:{rom_a,rom_theta}<={9'd294,9'd444};
12'd3320:{rom_a,rom_theta}<={9'd294,9'd444};
12'd3321:{rom_a,rom_theta}<={9'd294,9'd444};
12'd3322:{rom_a,rom_theta}<={9'd294,9'd444};
12'd3323:{rom_a,rom_theta}<={9'd295,9'd444};
12'd3324:{rom_a,rom_theta}<={9'd295,9'd444};
12'd3325:{rom_a,rom_theta}<={9'd295,9'd445};
12'd3326:{rom_a,rom_theta}<={9'd295,9'd445};
12'd3327:{rom_a,rom_theta}<={9'd295,9'd445};
12'd3328:{rom_a,rom_theta}<={9'd295,9'd445};
12'd3329:{rom_a,rom_theta}<={9'd296,9'd445};
12'd3330:{rom_a,rom_theta}<={9'd296,9'd445};
12'd3331:{rom_a,rom_theta}<={9'd296,9'd445};
12'd3332:{rom_a,rom_theta}<={9'd296,9'd445};
12'd3333:{rom_a,rom_theta}<={9'd296,9'd445};
12'd3334:{rom_a,rom_theta}<={9'd296,9'd445};
12'd3335:{rom_a,rom_theta}<={9'd296,9'd445};
12'd3336:{rom_a,rom_theta}<={9'd297,9'd446};
12'd3337:{rom_a,rom_theta}<={9'd297,9'd446};
12'd3338:{rom_a,rom_theta}<={9'd297,9'd446};
12'd3339:{rom_a,rom_theta}<={9'd297,9'd446};
12'd3340:{rom_a,rom_theta}<={9'd297,9'd446};
12'd3341:{rom_a,rom_theta}<={9'd297,9'd446};
12'd3342:{rom_a,rom_theta}<={9'd298,9'd446};
12'd3343:{rom_a,rom_theta}<={9'd298,9'd446};
12'd3344:{rom_a,rom_theta}<={9'd298,9'd446};
12'd3345:{rom_a,rom_theta}<={9'd298,9'd446};
12'd3346:{rom_a,rom_theta}<={9'd298,9'd447};
12'd3347:{rom_a,rom_theta}<={9'd298,9'd447};
12'd3348:{rom_a,rom_theta}<={9'd299,9'd447};
12'd3349:{rom_a,rom_theta}<={9'd299,9'd447};
12'd3350:{rom_a,rom_theta}<={9'd299,9'd447};
12'd3351:{rom_a,rom_theta}<={9'd299,9'd447};
12'd3352:{rom_a,rom_theta}<={9'd299,9'd447};
12'd3353:{rom_a,rom_theta}<={9'd299,9'd447};
12'd3354:{rom_a,rom_theta}<={9'd300,9'd447};
12'd3355:{rom_a,rom_theta}<={9'd300,9'd447};
12'd3356:{rom_a,rom_theta}<={9'd300,9'd447};
12'd3357:{rom_a,rom_theta}<={9'd300,9'd448};
12'd3358:{rom_a,rom_theta}<={9'd300,9'd448};
12'd3359:{rom_a,rom_theta}<={9'd300,9'd448};
12'd3360:{rom_a,rom_theta}<={9'd300,9'd448};
12'd3361:{rom_a,rom_theta}<={9'd301,9'd448};
12'd3362:{rom_a,rom_theta}<={9'd301,9'd448};
12'd3363:{rom_a,rom_theta}<={9'd301,9'd448};
12'd3364:{rom_a,rom_theta}<={9'd301,9'd448};
12'd3365:{rom_a,rom_theta}<={9'd301,9'd448};
12'd3366:{rom_a,rom_theta}<={9'd301,9'd448};
12'd3367:{rom_a,rom_theta}<={9'd302,9'd449};
12'd3368:{rom_a,rom_theta}<={9'd302,9'd449};
12'd3369:{rom_a,rom_theta}<={9'd302,9'd449};
12'd3370:{rom_a,rom_theta}<={9'd302,9'd449};
12'd3371:{rom_a,rom_theta}<={9'd302,9'd449};
12'd3372:{rom_a,rom_theta}<={9'd302,9'd449};
12'd3373:{rom_a,rom_theta}<={9'd303,9'd449};
12'd3374:{rom_a,rom_theta}<={9'd303,9'd449};
12'd3375:{rom_a,rom_theta}<={9'd303,9'd449};
12'd3376:{rom_a,rom_theta}<={9'd303,9'd449};
12'd3377:{rom_a,rom_theta}<={9'd303,9'd449};
12'd3378:{rom_a,rom_theta}<={9'd303,9'd450};
12'd3379:{rom_a,rom_theta}<={9'd303,9'd450};
12'd3380:{rom_a,rom_theta}<={9'd304,9'd450};
12'd3381:{rom_a,rom_theta}<={9'd304,9'd450};
12'd3382:{rom_a,rom_theta}<={9'd304,9'd450};
12'd3383:{rom_a,rom_theta}<={9'd304,9'd450};
12'd3384:{rom_a,rom_theta}<={9'd304,9'd450};
12'd3385:{rom_a,rom_theta}<={9'd304,9'd450};
12'd3386:{rom_a,rom_theta}<={9'd305,9'd450};
12'd3387:{rom_a,rom_theta}<={9'd305,9'd450};
12'd3388:{rom_a,rom_theta}<={9'd305,9'd451};
12'd3389:{rom_a,rom_theta}<={9'd305,9'd451};
12'd3390:{rom_a,rom_theta}<={9'd305,9'd451};
12'd3391:{rom_a,rom_theta}<={9'd305,9'd451};
12'd3392:{rom_a,rom_theta}<={9'd306,9'd451};
12'd3393:{rom_a,rom_theta}<={9'd306,9'd451};
12'd3394:{rom_a,rom_theta}<={9'd306,9'd451};
12'd3395:{rom_a,rom_theta}<={9'd306,9'd451};
12'd3396:{rom_a,rom_theta}<={9'd306,9'd451};
12'd3397:{rom_a,rom_theta}<={9'd306,9'd451};
12'd3398:{rom_a,rom_theta}<={9'd306,9'd451};
12'd3399:{rom_a,rom_theta}<={9'd307,9'd452};
12'd3400:{rom_a,rom_theta}<={9'd307,9'd452};
12'd3401:{rom_a,rom_theta}<={9'd307,9'd452};
12'd3402:{rom_a,rom_theta}<={9'd307,9'd452};
12'd3403:{rom_a,rom_theta}<={9'd307,9'd452};
12'd3404:{rom_a,rom_theta}<={9'd307,9'd452};
12'd3405:{rom_a,rom_theta}<={9'd308,9'd452};
12'd3406:{rom_a,rom_theta}<={9'd308,9'd452};
12'd3407:{rom_a,rom_theta}<={9'd308,9'd452};
12'd3408:{rom_a,rom_theta}<={9'd308,9'd452};
12'd3409:{rom_a,rom_theta}<={9'd308,9'd452};
12'd3410:{rom_a,rom_theta}<={9'd308,9'd453};
12'd3411:{rom_a,rom_theta}<={9'd309,9'd453};
12'd3412:{rom_a,rom_theta}<={9'd309,9'd453};
12'd3413:{rom_a,rom_theta}<={9'd309,9'd453};
12'd3414:{rom_a,rom_theta}<={9'd309,9'd453};
12'd3415:{rom_a,rom_theta}<={9'd309,9'd453};
12'd3416:{rom_a,rom_theta}<={9'd309,9'd453};
12'd3417:{rom_a,rom_theta}<={9'd310,9'd453};
12'd3418:{rom_a,rom_theta}<={9'd310,9'd453};
12'd3419:{rom_a,rom_theta}<={9'd310,9'd453};
12'd3420:{rom_a,rom_theta}<={9'd310,9'd454};
12'd3421:{rom_a,rom_theta}<={9'd310,9'd454};
12'd3422:{rom_a,rom_theta}<={9'd310,9'd454};
12'd3423:{rom_a,rom_theta}<={9'd310,9'd454};
12'd3424:{rom_a,rom_theta}<={9'd311,9'd454};
12'd3425:{rom_a,rom_theta}<={9'd311,9'd454};
12'd3426:{rom_a,rom_theta}<={9'd311,9'd454};
12'd3427:{rom_a,rom_theta}<={9'd311,9'd454};
12'd3428:{rom_a,rom_theta}<={9'd311,9'd454};
12'd3429:{rom_a,rom_theta}<={9'd311,9'd454};
12'd3430:{rom_a,rom_theta}<={9'd312,9'd454};
12'd3431:{rom_a,rom_theta}<={9'd312,9'd455};
12'd3432:{rom_a,rom_theta}<={9'd312,9'd455};
12'd3433:{rom_a,rom_theta}<={9'd312,9'd455};
12'd3434:{rom_a,rom_theta}<={9'd312,9'd455};
12'd3435:{rom_a,rom_theta}<={9'd312,9'd455};
12'd3436:{rom_a,rom_theta}<={9'd313,9'd455};
12'd3437:{rom_a,rom_theta}<={9'd313,9'd455};
12'd3438:{rom_a,rom_theta}<={9'd313,9'd455};
12'd3439:{rom_a,rom_theta}<={9'd313,9'd455};
12'd3440:{rom_a,rom_theta}<={9'd313,9'd455};
12'd3441:{rom_a,rom_theta}<={9'd313,9'd455};
12'd3442:{rom_a,rom_theta}<={9'd314,9'd456};
12'd3443:{rom_a,rom_theta}<={9'd314,9'd456};
12'd3444:{rom_a,rom_theta}<={9'd314,9'd456};
12'd3445:{rom_a,rom_theta}<={9'd314,9'd456};
12'd3446:{rom_a,rom_theta}<={9'd314,9'd456};
12'd3447:{rom_a,rom_theta}<={9'd314,9'd456};
12'd3448:{rom_a,rom_theta}<={9'd315,9'd456};
12'd3449:{rom_a,rom_theta}<={9'd315,9'd456};
12'd3450:{rom_a,rom_theta}<={9'd315,9'd456};
12'd3451:{rom_a,rom_theta}<={9'd315,9'd456};
12'd3452:{rom_a,rom_theta}<={9'd315,9'd457};
12'd3453:{rom_a,rom_theta}<={9'd315,9'd457};
12'd3454:{rom_a,rom_theta}<={9'd315,9'd457};
12'd3455:{rom_a,rom_theta}<={9'd316,9'd457};
12'd3456:{rom_a,rom_theta}<={9'd316,9'd457};
12'd3457:{rom_a,rom_theta}<={9'd316,9'd457};
12'd3458:{rom_a,rom_theta}<={9'd316,9'd457};
12'd3459:{rom_a,rom_theta}<={9'd316,9'd457};
12'd3460:{rom_a,rom_theta}<={9'd316,9'd457};
12'd3461:{rom_a,rom_theta}<={9'd317,9'd457};
12'd3462:{rom_a,rom_theta}<={9'd317,9'd457};
12'd3463:{rom_a,rom_theta}<={9'd317,9'd458};
12'd3464:{rom_a,rom_theta}<={9'd317,9'd458};
12'd3465:{rom_a,rom_theta}<={9'd317,9'd458};
12'd3466:{rom_a,rom_theta}<={9'd317,9'd458};
12'd3467:{rom_a,rom_theta}<={9'd318,9'd458};
12'd3468:{rom_a,rom_theta}<={9'd318,9'd458};
12'd3469:{rom_a,rom_theta}<={9'd318,9'd458};
12'd3470:{rom_a,rom_theta}<={9'd318,9'd458};
12'd3471:{rom_a,rom_theta}<={9'd318,9'd458};
12'd3472:{rom_a,rom_theta}<={9'd318,9'd458};
12'd3473:{rom_a,rom_theta}<={9'd319,9'd458};
12'd3474:{rom_a,rom_theta}<={9'd319,9'd459};
12'd3475:{rom_a,rom_theta}<={9'd319,9'd459};
12'd3476:{rom_a,rom_theta}<={9'd319,9'd459};
12'd3477:{rom_a,rom_theta}<={9'd319,9'd459};
12'd3478:{rom_a,rom_theta}<={9'd319,9'd459};
12'd3479:{rom_a,rom_theta}<={9'd320,9'd459};
12'd3480:{rom_a,rom_theta}<={9'd320,9'd459};
12'd3481:{rom_a,rom_theta}<={9'd320,9'd459};
12'd3482:{rom_a,rom_theta}<={9'd320,9'd459};
12'd3483:{rom_a,rom_theta}<={9'd320,9'd459};
12'd3484:{rom_a,rom_theta}<={9'd320,9'd459};
12'd3485:{rom_a,rom_theta}<={9'd320,9'd460};
12'd3486:{rom_a,rom_theta}<={9'd321,9'd460};
12'd3487:{rom_a,rom_theta}<={9'd321,9'd460};
12'd3488:{rom_a,rom_theta}<={9'd321,9'd460};
12'd3489:{rom_a,rom_theta}<={9'd321,9'd460};
12'd3490:{rom_a,rom_theta}<={9'd321,9'd460};
12'd3491:{rom_a,rom_theta}<={9'd321,9'd460};
12'd3492:{rom_a,rom_theta}<={9'd322,9'd460};
12'd3493:{rom_a,rom_theta}<={9'd322,9'd460};
12'd3494:{rom_a,rom_theta}<={9'd322,9'd460};
12'd3495:{rom_a,rom_theta}<={9'd322,9'd460};
12'd3496:{rom_a,rom_theta}<={9'd322,9'd461};
12'd3497:{rom_a,rom_theta}<={9'd322,9'd461};
12'd3498:{rom_a,rom_theta}<={9'd323,9'd461};
12'd3499:{rom_a,rom_theta}<={9'd323,9'd461};
12'd3500:{rom_a,rom_theta}<={9'd323,9'd461};
12'd3501:{rom_a,rom_theta}<={9'd323,9'd461};
12'd3502:{rom_a,rom_theta}<={9'd323,9'd461};
12'd3503:{rom_a,rom_theta}<={9'd323,9'd461};
12'd3504:{rom_a,rom_theta}<={9'd324,9'd461};
12'd3505:{rom_a,rom_theta}<={9'd324,9'd461};
12'd3506:{rom_a,rom_theta}<={9'd324,9'd462};
12'd3507:{rom_a,rom_theta}<={9'd324,9'd462};
12'd3508:{rom_a,rom_theta}<={9'd324,9'd462};
12'd3509:{rom_a,rom_theta}<={9'd324,9'd462};
12'd3510:{rom_a,rom_theta}<={9'd325,9'd462};
12'd3511:{rom_a,rom_theta}<={9'd325,9'd462};
12'd3512:{rom_a,rom_theta}<={9'd325,9'd462};
12'd3513:{rom_a,rom_theta}<={9'd325,9'd462};
12'd3514:{rom_a,rom_theta}<={9'd325,9'd462};
12'd3515:{rom_a,rom_theta}<={9'd325,9'd462};
12'd3516:{rom_a,rom_theta}<={9'd326,9'd462};
12'd3517:{rom_a,rom_theta}<={9'd326,9'd463};
12'd3518:{rom_a,rom_theta}<={9'd326,9'd463};
12'd3519:{rom_a,rom_theta}<={9'd326,9'd463};
12'd3520:{rom_a,rom_theta}<={9'd326,9'd463};
12'd3521:{rom_a,rom_theta}<={9'd326,9'd463};
12'd3522:{rom_a,rom_theta}<={9'd327,9'd463};
12'd3523:{rom_a,rom_theta}<={9'd327,9'd463};
12'd3524:{rom_a,rom_theta}<={9'd327,9'd463};
12'd3525:{rom_a,rom_theta}<={9'd327,9'd463};
12'd3526:{rom_a,rom_theta}<={9'd327,9'd463};
12'd3527:{rom_a,rom_theta}<={9'd327,9'd463};
12'd3528:{rom_a,rom_theta}<={9'd327,9'd464};
12'd3529:{rom_a,rom_theta}<={9'd328,9'd464};
12'd3530:{rom_a,rom_theta}<={9'd328,9'd464};
12'd3531:{rom_a,rom_theta}<={9'd328,9'd464};
12'd3532:{rom_a,rom_theta}<={9'd328,9'd464};
12'd3533:{rom_a,rom_theta}<={9'd328,9'd464};
12'd3534:{rom_a,rom_theta}<={9'd328,9'd464};
12'd3535:{rom_a,rom_theta}<={9'd329,9'd464};
12'd3536:{rom_a,rom_theta}<={9'd329,9'd464};
12'd3537:{rom_a,rom_theta}<={9'd329,9'd464};
12'd3538:{rom_a,rom_theta}<={9'd329,9'd464};
12'd3539:{rom_a,rom_theta}<={9'd329,9'd465};
12'd3540:{rom_a,rom_theta}<={9'd329,9'd465};
12'd3541:{rom_a,rom_theta}<={9'd330,9'd465};
12'd3542:{rom_a,rom_theta}<={9'd330,9'd465};
12'd3543:{rom_a,rom_theta}<={9'd330,9'd465};
12'd3544:{rom_a,rom_theta}<={9'd330,9'd465};
12'd3545:{rom_a,rom_theta}<={9'd330,9'd465};
12'd3546:{rom_a,rom_theta}<={9'd330,9'd465};
12'd3547:{rom_a,rom_theta}<={9'd331,9'd465};
12'd3548:{rom_a,rom_theta}<={9'd331,9'd465};
12'd3549:{rom_a,rom_theta}<={9'd331,9'd465};
12'd3550:{rom_a,rom_theta}<={9'd331,9'd466};
12'd3551:{rom_a,rom_theta}<={9'd331,9'd466};
12'd3552:{rom_a,rom_theta}<={9'd331,9'd466};
12'd3553:{rom_a,rom_theta}<={9'd332,9'd466};
12'd3554:{rom_a,rom_theta}<={9'd332,9'd466};
12'd3555:{rom_a,rom_theta}<={9'd332,9'd466};
12'd3556:{rom_a,rom_theta}<={9'd332,9'd466};
12'd3557:{rom_a,rom_theta}<={9'd332,9'd466};
12'd3558:{rom_a,rom_theta}<={9'd332,9'd466};
12'd3559:{rom_a,rom_theta}<={9'd333,9'd466};
12'd3560:{rom_a,rom_theta}<={9'd333,9'd466};
12'd3561:{rom_a,rom_theta}<={9'd333,9'd467};
12'd3562:{rom_a,rom_theta}<={9'd333,9'd467};
12'd3563:{rom_a,rom_theta}<={9'd333,9'd467};
12'd3564:{rom_a,rom_theta}<={9'd333,9'd467};
12'd3565:{rom_a,rom_theta}<={9'd334,9'd467};
12'd3566:{rom_a,rom_theta}<={9'd334,9'd467};
12'd3567:{rom_a,rom_theta}<={9'd334,9'd467};
12'd3568:{rom_a,rom_theta}<={9'd334,9'd467};
12'd3569:{rom_a,rom_theta}<={9'd334,9'd467};
12'd3570:{rom_a,rom_theta}<={9'd334,9'd467};
12'd3571:{rom_a,rom_theta}<={9'd335,9'd467};
12'd3572:{rom_a,rom_theta}<={9'd335,9'd468};
12'd3573:{rom_a,rom_theta}<={9'd335,9'd468};
12'd3574:{rom_a,rom_theta}<={9'd335,9'd468};
12'd3575:{rom_a,rom_theta}<={9'd335,9'd468};
12'd3576:{rom_a,rom_theta}<={9'd335,9'd468};
12'd3577:{rom_a,rom_theta}<={9'd336,9'd468};
12'd3578:{rom_a,rom_theta}<={9'd336,9'd468};
12'd3579:{rom_a,rom_theta}<={9'd336,9'd468};
12'd3580:{rom_a,rom_theta}<={9'd336,9'd468};
12'd3581:{rom_a,rom_theta}<={9'd336,9'd468};
12'd3582:{rom_a,rom_theta}<={9'd336,9'd468};
12'd3583:{rom_a,rom_theta}<={9'd336,9'd469};
12'd3584:{rom_a,rom_theta}<={9'd337,9'd469};
12'd3585:{rom_a,rom_theta}<={9'd337,9'd469};
12'd3586:{rom_a,rom_theta}<={9'd337,9'd469};
12'd3587:{rom_a,rom_theta}<={9'd337,9'd469};
12'd3588:{rom_a,rom_theta}<={9'd337,9'd469};
12'd3589:{rom_a,rom_theta}<={9'd337,9'd469};
12'd3590:{rom_a,rom_theta}<={9'd338,9'd469};
12'd3591:{rom_a,rom_theta}<={9'd338,9'd469};
12'd3592:{rom_a,rom_theta}<={9'd338,9'd469};
12'd3593:{rom_a,rom_theta}<={9'd338,9'd469};
12'd3594:{rom_a,rom_theta}<={9'd338,9'd470};
12'd3595:{rom_a,rom_theta}<={9'd338,9'd470};
12'd3596:{rom_a,rom_theta}<={9'd339,9'd470};
12'd3597:{rom_a,rom_theta}<={9'd339,9'd470};
12'd3598:{rom_a,rom_theta}<={9'd339,9'd470};
12'd3599:{rom_a,rom_theta}<={9'd339,9'd470};
12'd3600:{rom_a,rom_theta}<={9'd339,9'd470};
12'd3601:{rom_a,rom_theta}<={9'd339,9'd470};
12'd3602:{rom_a,rom_theta}<={9'd340,9'd470};
12'd3603:{rom_a,rom_theta}<={9'd340,9'd470};
12'd3604:{rom_a,rom_theta}<={9'd340,9'd470};
12'd3605:{rom_a,rom_theta}<={9'd340,9'd470};
12'd3606:{rom_a,rom_theta}<={9'd340,9'd471};
12'd3607:{rom_a,rom_theta}<={9'd340,9'd471};
12'd3608:{rom_a,rom_theta}<={9'd341,9'd471};
12'd3609:{rom_a,rom_theta}<={9'd341,9'd471};
12'd3610:{rom_a,rom_theta}<={9'd341,9'd471};
12'd3611:{rom_a,rom_theta}<={9'd341,9'd471};
12'd3612:{rom_a,rom_theta}<={9'd341,9'd471};
12'd3613:{rom_a,rom_theta}<={9'd341,9'd471};
12'd3614:{rom_a,rom_theta}<={9'd342,9'd471};
12'd3615:{rom_a,rom_theta}<={9'd342,9'd471};
12'd3616:{rom_a,rom_theta}<={9'd342,9'd471};
12'd3617:{rom_a,rom_theta}<={9'd342,9'd472};
12'd3618:{rom_a,rom_theta}<={9'd342,9'd472};
12'd3619:{rom_a,rom_theta}<={9'd342,9'd472};
12'd3620:{rom_a,rom_theta}<={9'd343,9'd472};
12'd3621:{rom_a,rom_theta}<={9'd343,9'd472};
12'd3622:{rom_a,rom_theta}<={9'd343,9'd472};
12'd3623:{rom_a,rom_theta}<={9'd343,9'd472};
12'd3624:{rom_a,rom_theta}<={9'd343,9'd472};
12'd3625:{rom_a,rom_theta}<={9'd343,9'd472};
12'd3626:{rom_a,rom_theta}<={9'd344,9'd472};
12'd3627:{rom_a,rom_theta}<={9'd344,9'd472};
12'd3628:{rom_a,rom_theta}<={9'd344,9'd473};
12'd3629:{rom_a,rom_theta}<={9'd344,9'd473};
12'd3630:{rom_a,rom_theta}<={9'd344,9'd473};
12'd3631:{rom_a,rom_theta}<={9'd344,9'd473};
12'd3632:{rom_a,rom_theta}<={9'd345,9'd473};
12'd3633:{rom_a,rom_theta}<={9'd345,9'd473};
12'd3634:{rom_a,rom_theta}<={9'd345,9'd473};
12'd3635:{rom_a,rom_theta}<={9'd345,9'd473};
12'd3636:{rom_a,rom_theta}<={9'd345,9'd473};
12'd3637:{rom_a,rom_theta}<={9'd345,9'd473};
12'd3638:{rom_a,rom_theta}<={9'd346,9'd473};
12'd3639:{rom_a,rom_theta}<={9'd346,9'd474};
12'd3640:{rom_a,rom_theta}<={9'd346,9'd474};
12'd3641:{rom_a,rom_theta}<={9'd346,9'd474};
12'd3642:{rom_a,rom_theta}<={9'd346,9'd474};
12'd3643:{rom_a,rom_theta}<={9'd346,9'd474};
12'd3644:{rom_a,rom_theta}<={9'd347,9'd474};
12'd3645:{rom_a,rom_theta}<={9'd347,9'd474};
12'd3646:{rom_a,rom_theta}<={9'd347,9'd474};
12'd3647:{rom_a,rom_theta}<={9'd347,9'd474};
12'd3648:{rom_a,rom_theta}<={9'd347,9'd474};
12'd3649:{rom_a,rom_theta}<={9'd347,9'd474};
12'd3650:{rom_a,rom_theta}<={9'd348,9'd475};
12'd3651:{rom_a,rom_theta}<={9'd348,9'd475};
12'd3652:{rom_a,rom_theta}<={9'd348,9'd475};
12'd3653:{rom_a,rom_theta}<={9'd348,9'd475};
12'd3654:{rom_a,rom_theta}<={9'd348,9'd475};
12'd3655:{rom_a,rom_theta}<={9'd348,9'd475};
12'd3656:{rom_a,rom_theta}<={9'd349,9'd475};
12'd3657:{rom_a,rom_theta}<={9'd349,9'd475};
12'd3658:{rom_a,rom_theta}<={9'd349,9'd475};
12'd3659:{rom_a,rom_theta}<={9'd349,9'd475};
12'd3660:{rom_a,rom_theta}<={9'd349,9'd475};
12'd3661:{rom_a,rom_theta}<={9'd349,9'd475};
12'd3662:{rom_a,rom_theta}<={9'd350,9'd476};
12'd3663:{rom_a,rom_theta}<={9'd350,9'd476};
12'd3664:{rom_a,rom_theta}<={9'd350,9'd476};
12'd3665:{rom_a,rom_theta}<={9'd350,9'd476};
12'd3666:{rom_a,rom_theta}<={9'd350,9'd476};
12'd3667:{rom_a,rom_theta}<={9'd350,9'd476};
12'd3668:{rom_a,rom_theta}<={9'd351,9'd476};
12'd3669:{rom_a,rom_theta}<={9'd351,9'd476};
12'd3670:{rom_a,rom_theta}<={9'd351,9'd476};
12'd3671:{rom_a,rom_theta}<={9'd351,9'd476};
12'd3672:{rom_a,rom_theta}<={9'd351,9'd476};
12'd3673:{rom_a,rom_theta}<={9'd351,9'd477};
12'd3674:{rom_a,rom_theta}<={9'd352,9'd477};
12'd3675:{rom_a,rom_theta}<={9'd352,9'd477};
12'd3676:{rom_a,rom_theta}<={9'd352,9'd477};
12'd3677:{rom_a,rom_theta}<={9'd352,9'd477};
12'd3678:{rom_a,rom_theta}<={9'd352,9'd477};
12'd3679:{rom_a,rom_theta}<={9'd352,9'd477};
12'd3680:{rom_a,rom_theta}<={9'd353,9'd477};
12'd3681:{rom_a,rom_theta}<={9'd353,9'd477};
12'd3682:{rom_a,rom_theta}<={9'd353,9'd477};
12'd3683:{rom_a,rom_theta}<={9'd353,9'd477};
12'd3684:{rom_a,rom_theta}<={9'd353,9'd478};
12'd3685:{rom_a,rom_theta}<={9'd353,9'd478};
12'd3686:{rom_a,rom_theta}<={9'd354,9'd478};
12'd3687:{rom_a,rom_theta}<={9'd354,9'd478};
12'd3688:{rom_a,rom_theta}<={9'd354,9'd478};
12'd3689:{rom_a,rom_theta}<={9'd354,9'd478};
12'd3690:{rom_a,rom_theta}<={9'd354,9'd478};
12'd3691:{rom_a,rom_theta}<={9'd354,9'd478};
12'd3692:{rom_a,rom_theta}<={9'd355,9'd478};
12'd3693:{rom_a,rom_theta}<={9'd355,9'd478};
12'd3694:{rom_a,rom_theta}<={9'd355,9'd478};
12'd3695:{rom_a,rom_theta}<={9'd355,9'd478};
12'd3696:{rom_a,rom_theta}<={9'd355,9'd479};
12'd3697:{rom_a,rom_theta}<={9'd355,9'd479};
12'd3698:{rom_a,rom_theta}<={9'd356,9'd479};
12'd3699:{rom_a,rom_theta}<={9'd356,9'd479};
12'd3700:{rom_a,rom_theta}<={9'd356,9'd479};
12'd3701:{rom_a,rom_theta}<={9'd356,9'd479};
12'd3702:{rom_a,rom_theta}<={9'd356,9'd479};
12'd3703:{rom_a,rom_theta}<={9'd356,9'd479};
12'd3704:{rom_a,rom_theta}<={9'd357,9'd479};
12'd3705:{rom_a,rom_theta}<={9'd357,9'd479};
12'd3706:{rom_a,rom_theta}<={9'd357,9'd479};
12'd3707:{rom_a,rom_theta}<={9'd357,9'd480};
12'd3708:{rom_a,rom_theta}<={9'd357,9'd480};
12'd3709:{rom_a,rom_theta}<={9'd357,9'd480};
12'd3710:{rom_a,rom_theta}<={9'd358,9'd480};
12'd3711:{rom_a,rom_theta}<={9'd358,9'd480};
12'd3712:{rom_a,rom_theta}<={9'd358,9'd480};
12'd3713:{rom_a,rom_theta}<={9'd358,9'd480};
12'd3714:{rom_a,rom_theta}<={9'd358,9'd480};
12'd3715:{rom_a,rom_theta}<={9'd358,9'd480};
12'd3716:{rom_a,rom_theta}<={9'd359,9'd480};
12'd3717:{rom_a,rom_theta}<={9'd359,9'd480};
12'd3718:{rom_a,rom_theta}<={9'd359,9'd480};
12'd3719:{rom_a,rom_theta}<={9'd359,9'd481};
12'd3720:{rom_a,rom_theta}<={9'd359,9'd481};
12'd3721:{rom_a,rom_theta}<={9'd359,9'd481};
12'd3722:{rom_a,rom_theta}<={9'd360,9'd481};
12'd3723:{rom_a,rom_theta}<={9'd360,9'd481};
12'd3724:{rom_a,rom_theta}<={9'd360,9'd481};
12'd3725:{rom_a,rom_theta}<={9'd360,9'd481};
12'd3726:{rom_a,rom_theta}<={9'd360,9'd481};
12'd3727:{rom_a,rom_theta}<={9'd360,9'd481};
12'd3728:{rom_a,rom_theta}<={9'd361,9'd481};
12'd3729:{rom_a,rom_theta}<={9'd361,9'd481};
12'd3730:{rom_a,rom_theta}<={9'd361,9'd482};
12'd3731:{rom_a,rom_theta}<={9'd361,9'd482};
12'd3732:{rom_a,rom_theta}<={9'd361,9'd482};
12'd3733:{rom_a,rom_theta}<={9'd361,9'd482};
12'd3734:{rom_a,rom_theta}<={9'd362,9'd482};
12'd3735:{rom_a,rom_theta}<={9'd362,9'd482};
12'd3736:{rom_a,rom_theta}<={9'd362,9'd482};
12'd3737:{rom_a,rom_theta}<={9'd362,9'd482};
12'd3738:{rom_a,rom_theta}<={9'd362,9'd482};
12'd3739:{rom_a,rom_theta}<={9'd362,9'd482};
12'd3740:{rom_a,rom_theta}<={9'd363,9'd482};
12'd3741:{rom_a,rom_theta}<={9'd363,9'd482};
12'd3742:{rom_a,rom_theta}<={9'd363,9'd483};
12'd3743:{rom_a,rom_theta}<={9'd363,9'd483};
12'd3744:{rom_a,rom_theta}<={9'd363,9'd483};
12'd3745:{rom_a,rom_theta}<={9'd363,9'd483};
12'd3746:{rom_a,rom_theta}<={9'd364,9'd483};
12'd3747:{rom_a,rom_theta}<={9'd364,9'd483};
12'd3748:{rom_a,rom_theta}<={9'd364,9'd483};
12'd3749:{rom_a,rom_theta}<={9'd364,9'd483};
12'd3750:{rom_a,rom_theta}<={9'd364,9'd483};
12'd3751:{rom_a,rom_theta}<={9'd365,9'd483};
12'd3752:{rom_a,rom_theta}<={9'd365,9'd483};
12'd3753:{rom_a,rom_theta}<={9'd365,9'd484};
12'd3754:{rom_a,rom_theta}<={9'd365,9'd484};
12'd3755:{rom_a,rom_theta}<={9'd365,9'd484};
12'd3756:{rom_a,rom_theta}<={9'd365,9'd484};
12'd3757:{rom_a,rom_theta}<={9'd366,9'd484};
12'd3758:{rom_a,rom_theta}<={9'd366,9'd484};
12'd3759:{rom_a,rom_theta}<={9'd366,9'd484};
12'd3760:{rom_a,rom_theta}<={9'd366,9'd484};
12'd3761:{rom_a,rom_theta}<={9'd366,9'd484};
12'd3762:{rom_a,rom_theta}<={9'd366,9'd484};
12'd3763:{rom_a,rom_theta}<={9'd367,9'd484};
12'd3764:{rom_a,rom_theta}<={9'd367,9'd484};
12'd3765:{rom_a,rom_theta}<={9'd367,9'd485};
12'd3766:{rom_a,rom_theta}<={9'd367,9'd485};
12'd3767:{rom_a,rom_theta}<={9'd367,9'd485};
12'd3768:{rom_a,rom_theta}<={9'd367,9'd485};
12'd3769:{rom_a,rom_theta}<={9'd368,9'd485};
12'd3770:{rom_a,rom_theta}<={9'd368,9'd485};
12'd3771:{rom_a,rom_theta}<={9'd368,9'd485};
12'd3772:{rom_a,rom_theta}<={9'd368,9'd485};
12'd3773:{rom_a,rom_theta}<={9'd368,9'd485};
12'd3774:{rom_a,rom_theta}<={9'd368,9'd485};
12'd3775:{rom_a,rom_theta}<={9'd369,9'd485};
12'd3776:{rom_a,rom_theta}<={9'd369,9'd486};
12'd3777:{rom_a,rom_theta}<={9'd369,9'd486};
12'd3778:{rom_a,rom_theta}<={9'd369,9'd486};
12'd3779:{rom_a,rom_theta}<={9'd369,9'd486};
12'd3780:{rom_a,rom_theta}<={9'd369,9'd486};
12'd3781:{rom_a,rom_theta}<={9'd370,9'd486};
12'd3782:{rom_a,rom_theta}<={9'd370,9'd486};
12'd3783:{rom_a,rom_theta}<={9'd370,9'd486};
12'd3784:{rom_a,rom_theta}<={9'd370,9'd486};
12'd3785:{rom_a,rom_theta}<={9'd370,9'd486};
12'd3786:{rom_a,rom_theta}<={9'd370,9'd486};
12'd3787:{rom_a,rom_theta}<={9'd371,9'd486};
12'd3788:{rom_a,rom_theta}<={9'd371,9'd487};
12'd3789:{rom_a,rom_theta}<={9'd371,9'd487};
12'd3790:{rom_a,rom_theta}<={9'd371,9'd487};
12'd3791:{rom_a,rom_theta}<={9'd371,9'd487};
12'd3792:{rom_a,rom_theta}<={9'd371,9'd487};
12'd3793:{rom_a,rom_theta}<={9'd372,9'd487};
12'd3794:{rom_a,rom_theta}<={9'd372,9'd487};
12'd3795:{rom_a,rom_theta}<={9'd372,9'd487};
12'd3796:{rom_a,rom_theta}<={9'd372,9'd487};
12'd3797:{rom_a,rom_theta}<={9'd372,9'd487};
12'd3798:{rom_a,rom_theta}<={9'd372,9'd487};
12'd3799:{rom_a,rom_theta}<={9'd373,9'd487};
12'd3800:{rom_a,rom_theta}<={9'd373,9'd488};
12'd3801:{rom_a,rom_theta}<={9'd373,9'd488};
12'd3802:{rom_a,rom_theta}<={9'd373,9'd488};
12'd3803:{rom_a,rom_theta}<={9'd373,9'd488};
12'd3804:{rom_a,rom_theta}<={9'd373,9'd488};
12'd3805:{rom_a,rom_theta}<={9'd374,9'd488};
12'd3806:{rom_a,rom_theta}<={9'd374,9'd488};
12'd3807:{rom_a,rom_theta}<={9'd374,9'd488};
12'd3808:{rom_a,rom_theta}<={9'd374,9'd488};
12'd3809:{rom_a,rom_theta}<={9'd374,9'd488};
12'd3810:{rom_a,rom_theta}<={9'd375,9'd488};
12'd3811:{rom_a,rom_theta}<={9'd375,9'd489};
12'd3812:{rom_a,rom_theta}<={9'd375,9'd489};
12'd3813:{rom_a,rom_theta}<={9'd375,9'd489};
12'd3814:{rom_a,rom_theta}<={9'd375,9'd489};
12'd3815:{rom_a,rom_theta}<={9'd375,9'd489};
12'd3816:{rom_a,rom_theta}<={9'd376,9'd489};
12'd3817:{rom_a,rom_theta}<={9'd376,9'd489};
12'd3818:{rom_a,rom_theta}<={9'd376,9'd489};
12'd3819:{rom_a,rom_theta}<={9'd376,9'd489};
12'd3820:{rom_a,rom_theta}<={9'd376,9'd489};
12'd3821:{rom_a,rom_theta}<={9'd376,9'd489};
12'd3822:{rom_a,rom_theta}<={9'd377,9'd489};
12'd3823:{rom_a,rom_theta}<={9'd377,9'd490};
12'd3824:{rom_a,rom_theta}<={9'd377,9'd490};
12'd3825:{rom_a,rom_theta}<={9'd377,9'd490};
12'd3826:{rom_a,rom_theta}<={9'd377,9'd490};
12'd3827:{rom_a,rom_theta}<={9'd377,9'd490};
12'd3828:{rom_a,rom_theta}<={9'd378,9'd490};
12'd3829:{rom_a,rom_theta}<={9'd378,9'd490};
12'd3830:{rom_a,rom_theta}<={9'd378,9'd490};
12'd3831:{rom_a,rom_theta}<={9'd378,9'd490};
12'd3832:{rom_a,rom_theta}<={9'd378,9'd490};
12'd3833:{rom_a,rom_theta}<={9'd378,9'd490};
12'd3834:{rom_a,rom_theta}<={9'd379,9'd490};
12'd3835:{rom_a,rom_theta}<={9'd379,9'd491};
12'd3836:{rom_a,rom_theta}<={9'd379,9'd491};
12'd3837:{rom_a,rom_theta}<={9'd379,9'd491};
12'd3838:{rom_a,rom_theta}<={9'd379,9'd491};
12'd3839:{rom_a,rom_theta}<={9'd379,9'd491};
12'd3840:{rom_a,rom_theta}<={9'd380,9'd491};
12'd3841:{rom_a,rom_theta}<={9'd380,9'd491};
12'd3842:{rom_a,rom_theta}<={9'd380,9'd491};
12'd3843:{rom_a,rom_theta}<={9'd380,9'd491};
12'd3844:{rom_a,rom_theta}<={9'd380,9'd491};
12'd3845:{rom_a,rom_theta}<={9'd380,9'd491};
12'd3846:{rom_a,rom_theta}<={9'd381,9'd491};
12'd3847:{rom_a,rom_theta}<={9'd381,9'd492};
12'd3848:{rom_a,rom_theta}<={9'd381,9'd492};
12'd3849:{rom_a,rom_theta}<={9'd381,9'd492};
12'd3850:{rom_a,rom_theta}<={9'd381,9'd492};
12'd3851:{rom_a,rom_theta}<={9'd382,9'd492};
12'd3852:{rom_a,rom_theta}<={9'd382,9'd492};
12'd3853:{rom_a,rom_theta}<={9'd382,9'd492};
12'd3854:{rom_a,rom_theta}<={9'd382,9'd492};
12'd3855:{rom_a,rom_theta}<={9'd382,9'd492};
12'd3856:{rom_a,rom_theta}<={9'd382,9'd492};
12'd3857:{rom_a,rom_theta}<={9'd383,9'd492};
12'd3858:{rom_a,rom_theta}<={9'd383,9'd492};
12'd3859:{rom_a,rom_theta}<={9'd383,9'd493};
12'd3860:{rom_a,rom_theta}<={9'd383,9'd493};
12'd3861:{rom_a,rom_theta}<={9'd383,9'd493};
12'd3862:{rom_a,rom_theta}<={9'd383,9'd493};
12'd3863:{rom_a,rom_theta}<={9'd384,9'd493};
12'd3864:{rom_a,rom_theta}<={9'd384,9'd493};
12'd3865:{rom_a,rom_theta}<={9'd384,9'd493};
12'd3866:{rom_a,rom_theta}<={9'd384,9'd493};
12'd3867:{rom_a,rom_theta}<={9'd384,9'd493};
12'd3868:{rom_a,rom_theta}<={9'd384,9'd493};
12'd3869:{rom_a,rom_theta}<={9'd385,9'd493};
12'd3870:{rom_a,rom_theta}<={9'd385,9'd494};
12'd3871:{rom_a,rom_theta}<={9'd385,9'd494};
12'd3872:{rom_a,rom_theta}<={9'd385,9'd494};
12'd3873:{rom_a,rom_theta}<={9'd385,9'd494};
12'd3874:{rom_a,rom_theta}<={9'd385,9'd494};
12'd3875:{rom_a,rom_theta}<={9'd386,9'd494};
12'd3876:{rom_a,rom_theta}<={9'd386,9'd494};
12'd3877:{rom_a,rom_theta}<={9'd386,9'd494};
12'd3878:{rom_a,rom_theta}<={9'd386,9'd494};
12'd3879:{rom_a,rom_theta}<={9'd386,9'd494};
12'd3880:{rom_a,rom_theta}<={9'd386,9'd494};
12'd3881:{rom_a,rom_theta}<={9'd387,9'd494};
12'd3882:{rom_a,rom_theta}<={9'd387,9'd495};
12'd3883:{rom_a,rom_theta}<={9'd387,9'd495};
12'd3884:{rom_a,rom_theta}<={9'd387,9'd495};
12'd3885:{rom_a,rom_theta}<={9'd387,9'd495};
12'd3886:{rom_a,rom_theta}<={9'd388,9'd495};
12'd3887:{rom_a,rom_theta}<={9'd388,9'd495};
12'd3888:{rom_a,rom_theta}<={9'd388,9'd495};
12'd3889:{rom_a,rom_theta}<={9'd388,9'd495};
12'd3890:{rom_a,rom_theta}<={9'd388,9'd495};
12'd3891:{rom_a,rom_theta}<={9'd388,9'd495};
12'd3892:{rom_a,rom_theta}<={9'd389,9'd495};
12'd3893:{rom_a,rom_theta}<={9'd389,9'd495};
12'd3894:{rom_a,rom_theta}<={9'd389,9'd496};
12'd3895:{rom_a,rom_theta}<={9'd389,9'd496};
12'd3896:{rom_a,rom_theta}<={9'd389,9'd496};
12'd3897:{rom_a,rom_theta}<={9'd389,9'd496};
12'd3898:{rom_a,rom_theta}<={9'd390,9'd496};
12'd3899:{rom_a,rom_theta}<={9'd390,9'd496};
12'd3900:{rom_a,rom_theta}<={9'd390,9'd496};
12'd3901:{rom_a,rom_theta}<={9'd390,9'd496};
12'd3902:{rom_a,rom_theta}<={9'd390,9'd496};
12'd3903:{rom_a,rom_theta}<={9'd390,9'd496};
12'd3904:{rom_a,rom_theta}<={9'd391,9'd496};
12'd3905:{rom_a,rom_theta}<={9'd391,9'd496};
12'd3906:{rom_a,rom_theta}<={9'd391,9'd497};
12'd3907:{rom_a,rom_theta}<={9'd391,9'd497};
12'd3908:{rom_a,rom_theta}<={9'd391,9'd497};
12'd3909:{rom_a,rom_theta}<={9'd391,9'd497};
12'd3910:{rom_a,rom_theta}<={9'd392,9'd497};
12'd3911:{rom_a,rom_theta}<={9'd392,9'd497};
12'd3912:{rom_a,rom_theta}<={9'd392,9'd497};
12'd3913:{rom_a,rom_theta}<={9'd392,9'd497};
12'd3914:{rom_a,rom_theta}<={9'd392,9'd497};
12'd3915:{rom_a,rom_theta}<={9'd393,9'd497};
12'd3916:{rom_a,rom_theta}<={9'd393,9'd497};
12'd3917:{rom_a,rom_theta}<={9'd393,9'd497};
12'd3918:{rom_a,rom_theta}<={9'd393,9'd498};
12'd3919:{rom_a,rom_theta}<={9'd393,9'd498};
12'd3920:{rom_a,rom_theta}<={9'd393,9'd498};
12'd3921:{rom_a,rom_theta}<={9'd394,9'd498};
12'd3922:{rom_a,rom_theta}<={9'd394,9'd498};
12'd3923:{rom_a,rom_theta}<={9'd394,9'd498};
12'd3924:{rom_a,rom_theta}<={9'd394,9'd498};
12'd3925:{rom_a,rom_theta}<={9'd394,9'd498};
12'd3926:{rom_a,rom_theta}<={9'd394,9'd498};
12'd3927:{rom_a,rom_theta}<={9'd395,9'd498};
12'd3928:{rom_a,rom_theta}<={9'd395,9'd498};
12'd3929:{rom_a,rom_theta}<={9'd395,9'd498};
12'd3930:{rom_a,rom_theta}<={9'd395,9'd499};
12'd3931:{rom_a,rom_theta}<={9'd395,9'd499};
12'd3932:{rom_a,rom_theta}<={9'd395,9'd499};
12'd3933:{rom_a,rom_theta}<={9'd396,9'd499};
12'd3934:{rom_a,rom_theta}<={9'd396,9'd499};
12'd3935:{rom_a,rom_theta}<={9'd396,9'd499};
12'd3936:{rom_a,rom_theta}<={9'd396,9'd499};
12'd3937:{rom_a,rom_theta}<={9'd396,9'd499};
12'd3938:{rom_a,rom_theta}<={9'd396,9'd499};
12'd3939:{rom_a,rom_theta}<={9'd397,9'd499};
12'd3940:{rom_a,rom_theta}<={9'd397,9'd499};
12'd3941:{rom_a,rom_theta}<={9'd397,9'd499};
12'd3942:{rom_a,rom_theta}<={9'd397,9'd500};
12'd3943:{rom_a,rom_theta}<={9'd397,9'd500};
12'd3944:{rom_a,rom_theta}<={9'd398,9'd500};
12'd3945:{rom_a,rom_theta}<={9'd398,9'd500};
12'd3946:{rom_a,rom_theta}<={9'd398,9'd500};
12'd3947:{rom_a,rom_theta}<={9'd398,9'd500};
12'd3948:{rom_a,rom_theta}<={9'd398,9'd500};
12'd3949:{rom_a,rom_theta}<={9'd398,9'd500};
12'd3950:{rom_a,rom_theta}<={9'd399,9'd500};
12'd3951:{rom_a,rom_theta}<={9'd399,9'd500};
12'd3952:{rom_a,rom_theta}<={9'd399,9'd500};
12'd3953:{rom_a,rom_theta}<={9'd399,9'd500};
12'd3954:{rom_a,rom_theta}<={9'd399,9'd501};
12'd3955:{rom_a,rom_theta}<={9'd399,9'd501};
12'd3956:{rom_a,rom_theta}<={9'd400,9'd501};
12'd3957:{rom_a,rom_theta}<={9'd400,9'd501};
12'd3958:{rom_a,rom_theta}<={9'd400,9'd501};
12'd3959:{rom_a,rom_theta}<={9'd400,9'd501};
12'd3960:{rom_a,rom_theta}<={9'd400,9'd501};
12'd3961:{rom_a,rom_theta}<={9'd400,9'd501};
12'd3962:{rom_a,rom_theta}<={9'd401,9'd501};
12'd3963:{rom_a,rom_theta}<={9'd401,9'd501};
12'd3964:{rom_a,rom_theta}<={9'd401,9'd501};
12'd3965:{rom_a,rom_theta}<={9'd401,9'd501};
12'd3966:{rom_a,rom_theta}<={9'd401,9'd501};
12'd3967:{rom_a,rom_theta}<={9'd402,9'd502};
12'd3968:{rom_a,rom_theta}<={9'd402,9'd502};
12'd3969:{rom_a,rom_theta}<={9'd402,9'd502};
12'd3970:{rom_a,rom_theta}<={9'd402,9'd502};
12'd3971:{rom_a,rom_theta}<={9'd402,9'd502};
12'd3972:{rom_a,rom_theta}<={9'd402,9'd502};
12'd3973:{rom_a,rom_theta}<={9'd403,9'd502};
12'd3974:{rom_a,rom_theta}<={9'd403,9'd502};
12'd3975:{rom_a,rom_theta}<={9'd403,9'd502};
12'd3976:{rom_a,rom_theta}<={9'd403,9'd502};
12'd3977:{rom_a,rom_theta}<={9'd403,9'd502};
12'd3978:{rom_a,rom_theta}<={9'd403,9'd502};
12'd3979:{rom_a,rom_theta}<={9'd404,9'd503};
12'd3980:{rom_a,rom_theta}<={9'd404,9'd503};
12'd3981:{rom_a,rom_theta}<={9'd404,9'd503};
12'd3982:{rom_a,rom_theta}<={9'd404,9'd503};
12'd3983:{rom_a,rom_theta}<={9'd404,9'd503};
12'd3984:{rom_a,rom_theta}<={9'd404,9'd503};
12'd3985:{rom_a,rom_theta}<={9'd405,9'd503};
12'd3986:{rom_a,rom_theta}<={9'd405,9'd503};
12'd3987:{rom_a,rom_theta}<={9'd405,9'd503};
12'd3988:{rom_a,rom_theta}<={9'd405,9'd503};
12'd3989:{rom_a,rom_theta}<={9'd405,9'd503};
12'd3990:{rom_a,rom_theta}<={9'd406,9'd503};
12'd3991:{rom_a,rom_theta}<={9'd406,9'd504};
12'd3992:{rom_a,rom_theta}<={9'd406,9'd504};
12'd3993:{rom_a,rom_theta}<={9'd406,9'd504};
12'd3994:{rom_a,rom_theta}<={9'd406,9'd504};
12'd3995:{rom_a,rom_theta}<={9'd406,9'd504};
12'd3996:{rom_a,rom_theta}<={9'd407,9'd504};
12'd3997:{rom_a,rom_theta}<={9'd407,9'd504};
12'd3998:{rom_a,rom_theta}<={9'd407,9'd504};
12'd3999:{rom_a,rom_theta}<={9'd407,9'd504};
12'd4000:{rom_a,rom_theta}<={9'd407,9'd504};
12'd4001:{rom_a,rom_theta}<={9'd407,9'd504};
12'd4002:{rom_a,rom_theta}<={9'd408,9'd504};
12'd4003:{rom_a,rom_theta}<={9'd408,9'd505};
12'd4004:{rom_a,rom_theta}<={9'd408,9'd505};
12'd4005:{rom_a,rom_theta}<={9'd408,9'd505};
12'd4006:{rom_a,rom_theta}<={9'd408,9'd505};
12'd4007:{rom_a,rom_theta}<={9'd409,9'd505};
12'd4008:{rom_a,rom_theta}<={9'd409,9'd505};
12'd4009:{rom_a,rom_theta}<={9'd409,9'd505};
12'd4010:{rom_a,rom_theta}<={9'd409,9'd505};
12'd4011:{rom_a,rom_theta}<={9'd409,9'd505};
12'd4012:{rom_a,rom_theta}<={9'd409,9'd505};
12'd4013:{rom_a,rom_theta}<={9'd410,9'd505};
12'd4014:{rom_a,rom_theta}<={9'd410,9'd505};
12'd4015:{rom_a,rom_theta}<={9'd410,9'd505};
12'd4016:{rom_a,rom_theta}<={9'd410,9'd506};
12'd4017:{rom_a,rom_theta}<={9'd410,9'd506};
12'd4018:{rom_a,rom_theta}<={9'd410,9'd506};
12'd4019:{rom_a,rom_theta}<={9'd411,9'd506};
12'd4020:{rom_a,rom_theta}<={9'd411,9'd506};
12'd4021:{rom_a,rom_theta}<={9'd411,9'd506};
12'd4022:{rom_a,rom_theta}<={9'd411,9'd506};
12'd4023:{rom_a,rom_theta}<={9'd411,9'd506};
12'd4024:{rom_a,rom_theta}<={9'd411,9'd506};
12'd4025:{rom_a,rom_theta}<={9'd412,9'd506};
12'd4026:{rom_a,rom_theta}<={9'd412,9'd506};
12'd4027:{rom_a,rom_theta}<={9'd412,9'd506};
12'd4028:{rom_a,rom_theta}<={9'd412,9'd507};
12'd4029:{rom_a,rom_theta}<={9'd412,9'd507};
12'd4030:{rom_a,rom_theta}<={9'd413,9'd507};
12'd4031:{rom_a,rom_theta}<={9'd413,9'd507};
12'd4032:{rom_a,rom_theta}<={9'd413,9'd507};
12'd4033:{rom_a,rom_theta}<={9'd413,9'd507};
12'd4034:{rom_a,rom_theta}<={9'd413,9'd507};
12'd4035:{rom_a,rom_theta}<={9'd413,9'd507};
12'd4036:{rom_a,rom_theta}<={9'd414,9'd507};
12'd4037:{rom_a,rom_theta}<={9'd414,9'd507};
12'd4038:{rom_a,rom_theta}<={9'd414,9'd507};
12'd4039:{rom_a,rom_theta}<={9'd414,9'd507};
12'd4040:{rom_a,rom_theta}<={9'd414,9'd508};
12'd4041:{rom_a,rom_theta}<={9'd414,9'd508};
12'd4042:{rom_a,rom_theta}<={9'd415,9'd508};
12'd4043:{rom_a,rom_theta}<={9'd415,9'd508};
12'd4044:{rom_a,rom_theta}<={9'd415,9'd508};
12'd4045:{rom_a,rom_theta}<={9'd415,9'd508};
12'd4046:{rom_a,rom_theta}<={9'd415,9'd508};
12'd4047:{rom_a,rom_theta}<={9'd416,9'd508};
12'd4048:{rom_a,rom_theta}<={9'd416,9'd508};
12'd4049:{rom_a,rom_theta}<={9'd416,9'd508};
12'd4050:{rom_a,rom_theta}<={9'd416,9'd508};
12'd4051:{rom_a,rom_theta}<={9'd416,9'd508};
12'd4052:{rom_a,rom_theta}<={9'd416,9'd508};
12'd4053:{rom_a,rom_theta}<={9'd417,9'd509};
12'd4054:{rom_a,rom_theta}<={9'd417,9'd509};
12'd4055:{rom_a,rom_theta}<={9'd417,9'd509};
12'd4056:{rom_a,rom_theta}<={9'd417,9'd509};
12'd4057:{rom_a,rom_theta}<={9'd417,9'd509};
12'd4058:{rom_a,rom_theta}<={9'd417,9'd509};
12'd4059:{rom_a,rom_theta}<={9'd418,9'd509};
12'd4060:{rom_a,rom_theta}<={9'd418,9'd509};
12'd4061:{rom_a,rom_theta}<={9'd418,9'd509};
12'd4062:{rom_a,rom_theta}<={9'd418,9'd509};
12'd4063:{rom_a,rom_theta}<={9'd418,9'd509};
12'd4064:{rom_a,rom_theta}<={9'd419,9'd509};
12'd4065:{rom_a,rom_theta}<={9'd419,9'd510};
12'd4066:{rom_a,rom_theta}<={9'd419,9'd510};
12'd4067:{rom_a,rom_theta}<={9'd419,9'd510};
12'd4068:{rom_a,rom_theta}<={9'd419,9'd510};
12'd4069:{rom_a,rom_theta}<={9'd419,9'd510};
12'd4070:{rom_a,rom_theta}<={9'd420,9'd510};
12'd4071:{rom_a,rom_theta}<={9'd420,9'd510};
12'd4072:{rom_a,rom_theta}<={9'd420,9'd510};
12'd4073:{rom_a,rom_theta}<={9'd420,9'd510};
12'd4074:{rom_a,rom_theta}<={9'd420,9'd510};
12'd4075:{rom_a,rom_theta}<={9'd420,9'd510};
12'd4076:{rom_a,rom_theta}<={9'd421,9'd510};
12'd4077:{rom_a,rom_theta}<={9'd421,9'd510};
12'd4078:{rom_a,rom_theta}<={9'd421,9'd511};
12'd4079:{rom_a,rom_theta}<={9'd421,9'd511};
12'd4080:{rom_a,rom_theta}<={9'd421,9'd511};
12'd4081:{rom_a,rom_theta}<={9'd422,9'd511};
12'd4082:{rom_a,rom_theta}<={9'd422,9'd511};
12'd4083:{rom_a,rom_theta}<={9'd422,9'd511};
12'd4084:{rom_a,rom_theta}<={9'd422,9'd511};
12'd4085:{rom_a,rom_theta}<={9'd422,9'd511};
12'd4086:{rom_a,rom_theta}<={9'd422,9'd511};
12'd4087:{rom_a,rom_theta}<={9'd423,9'd511};
12'd4088:{rom_a,rom_theta}<={9'd423,9'd511};
12'd4089:{rom_a,rom_theta}<={9'd423,9'd511};
12'd4090:{rom_a,rom_theta}<={9'd423,9'd511};
12'd4091:{rom_a,rom_theta}<={9'd423,9'd511};
12'd4092:{rom_a,rom_theta}<={9'd423,9'd511};
12'd4093:{rom_a,rom_theta}<={9'd424,9'd511};
12'd4094:{rom_a,rom_theta}<={9'd424,9'd511};
12'd4095:{rom_a,rom_theta}<={9'd424,9'd511};
endcase

endmodule
